/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.build.core.scannerconfig.ICfgScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.build.internal.core.scannerconfig.CfgDiscoveredPathManager;
import org.eclipse.cdt.build.internal.core.scannerconfig.CfgScannerConfigUtil;
import org.eclipse.cdt.build.internal.core.scannerconfig2.CfgScannerConfigProfileManager;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.model.util.CDTListComparator;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.ui.language.settings.providers.LanguageSettingsProvidersPage;
import org.eclipse.cdt.internal.ui.newui.StatusMessageLine;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollectorCleaner;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathInfo;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredScannerInfoStore;
import org.eclipse.cdt.make.internal.core.scannerconfig2.DefaultRunSIProvider;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.make.ui.dialogs.AbstractDiscoveryOptionsBlock;
import org.eclipse.cdt.make.ui.dialogs.AbstractDiscoveryPage;
import org.eclipse.cdt.make.ui.dialogs.GCCPerProjectSCDProfilePage;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.DiscoveryPageWrapper;
import org.eclipse.cdt.managedbuilder.ui.properties.IBuildInfoContainer;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIPlugin;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class DiscoveryTab
extends AbstractCBuildPropertyTab
implements IBuildInfoContainer {
    @Deprecated
    protected static final String PREFIX = "ScannerConfigOptionsDialog";
    private static final String GCC_PER_PROJECT_PROFILE = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".GCCStandardMakePerProjectProfile";
    private static final String MAKEFILE_PROJECT_TOOLCHAIN_ID = "org.eclipse.cdt.build.core.prefbase.toolchain";
    private static final String NAMESPACE = "org.eclipse.cdt.make.ui";
    private static final String POINT = "DiscoveryProfilePage";
    private static final String PROFILE_PAGE = "profilePage";
    private static final String PROFILE_ID = "profileId";
    private static final String PROFILE_NAME = "name";
    private static final int DEFAULT_HEIGHT = 150;
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{10, 20};
    private Label fTableDefinition;
    private Combo scopeComboBox;
    private Table resTable;
    private Group autoDiscoveryGroup;
    private Button autoDiscoveryCheckBox;
    private Button reportProblemsCheckBox;
    private Combo profileComboBox;
    private Composite profileOptionsComposite;
    private Button clearButton;
    private ICfgScannerConfigBuilderInfo2Set cbi;
    private Map<InfoContext, IScannerConfigBuilderInfo2> baseInfoMap;
    private IScannerConfigBuilderInfo2 buildInfo;
    private CfgInfoContext iContext;
    private List<DiscoveryProfilePageConfiguration> pagesList = null;
    private List<String> visibleProfilesList = null;
    private IPath configPath;
    private AbstractDiscoveryPage[] realPages;
    protected SashForm sashForm;
    private DiscoveryPageWrapper wrapper = null;
    private StatusMessageLine fStatusLine;

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.wrapper = new DiscoveryPageWrapper(this.page, this);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        if (this.page.isForProject() || this.page.isForPrefs()) {
            Group scopeGroup = this.setupGroup(this.usercomp, Messages.DiscoveryTab_0, 1, 768);
            scopeGroup.setLayoutData((Object)new GridData(768));
            this.scopeComboBox = new Combo((Composite)scopeGroup, 2060);
            this.scopeComboBox.setLayoutData((Object)new GridData(768));
            this.scopeComboBox.add(Messages.DiscoveryTab_1);
            this.scopeComboBox.add(Messages.DiscoveryTab_2);
            this.scopeComboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (DiscoveryTab.this.cbi == null) {
                        return;
                    }
                    DiscoveryTab.this.cbi.setPerRcTypeDiscovery(DiscoveryTab.this.scopeComboBox.getSelectionIndex() == 0);
                    DiscoveryTab.this.updateData();
                }
            });
        }
        this.sashForm = new SashForm(this.usercomp, 0);
        this.sashForm.setOrientation(256);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        Composite comp = new Composite((Composite)this.sashForm, 0);
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setLayoutData((Object)new GridData(1808));
        this.fTableDefinition = new Label(comp, 16384);
        this.fTableDefinition.setLayoutData((Object)new GridData(768));
        this.resTable = new Table(comp, 2820);
        GridData gd = new GridData(1808);
        gd.widthHint = 150;
        this.resTable.setLayoutData((Object)gd);
        this.resTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoveryTab.this.handleToolSelected();
            }
        });
        this.initializeProfilePageMap();
        Composite c = new Composite((Composite)this.sashForm, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        c.setLayoutData((Object)new GridData(1808));
        this.createScannerConfigControls(c);
        this.profileOptionsComposite = new Composite(c, 0);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)DiscoveryTab.getFontMetrics((Control)parent), (int)150);
        this.profileOptionsComposite.setLayoutData((Object)gd);
        this.profileOptionsComposite.setLayout((Layout)new TabFolderLayout());
        this.fStatusLine = new StatusMessageLine(this.usercomp, 16384, 2);
        this.setEnablement();
        this.sashForm.setWeights(DEFAULT_SASH_WEIGHTS);
    }

    private void createScannerConfigControls(Composite parent) {
        this.autoDiscoveryGroup = this.setupGroup(parent, Messages.ScannerConfigOptionsDialog_scGroup_label, 2, 768);
        this.autoDiscoveryCheckBox = this.setupCheck((Composite)this.autoDiscoveryGroup, Messages.ScannerConfigOptionsDialog_scGroup_enabled_button, 2, 768);
        this.autoDiscoveryCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoveryTab.this.enableAllControls();
                boolean isSCDEnabled = DiscoveryTab.this.autoDiscoveryCheckBox.getSelection();
                DiscoveryTab.this.buildInfo.setAutoDiscoveryEnabled(isSCDEnabled);
                if (isSCDEnabled) {
                    String id = (String)DiscoveryTab.this.visibleProfilesList.get(DiscoveryTab.this.profileComboBox.getSelectionIndex());
                    DiscoveryTab.this.buildInfo.setSelectedProfileId(id);
                    DiscoveryTab.this.handleDiscoveryProfileChanged();
                }
                DiscoveryTab.this.showStatusLine();
            }
        });
        this.reportProblemsCheckBox = this.setupCheck((Composite)this.autoDiscoveryGroup, Messages.ScannerConfigOptionsDialog_scGroup_problemReporting_enabled_button, 2, 768);
        this.reportProblemsCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoveryTab.this.buildInfo.setProblemReportingEnabled(DiscoveryTab.this.reportProblemsCheckBox.getSelection());
            }
        });
        this.setupLabel((Composite)this.autoDiscoveryGroup, Messages.ScannerConfigOptionsDialog_scGroup_selectedProfile_combo, 1, 1);
        this.profileComboBox = new Combo((Composite)this.autoDiscoveryGroup, 2060);
        this.profileComboBox.setLayoutData((Object)new GridData(768));
        this.profileComboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int x = DiscoveryTab.this.profileComboBox.getSelectionIndex();
                String s = (String)DiscoveryTab.this.visibleProfilesList.get(x);
                DiscoveryTab.this.buildInfo.setSelectedProfileId(s);
                DiscoveryTab.this.handleDiscoveryProfileChanged();
            }
        });
        ControlFactory.createLabel((Composite)this.autoDiscoveryGroup, (String)Messages.DiscoveryTab_ClearDisoveredEntries);
        this.clearButton = ControlFactory.createPushButton((Composite)this.autoDiscoveryGroup, (String)Messages.DiscoveryTab_Clear);
        GridData gd = (GridData)this.clearButton.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 131072;
        final Shell shell = parent.getShell();
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String title = Messages.DiscoveryTab_ClearEntries;
                try {
                    DiscoveryTab.this.clearDiscoveredEntries();
                    MessageDialog.openInformation((Shell)shell, (String)title, (String)Messages.DiscoveryTab_DiscoveredEntriesCleared);
                }
                catch (CoreException e) {
                    MessageDialog.openError((Shell)shell, (String)title, (String)(String.valueOf(Messages.DiscoveryTab_ErrorClearingEntries) + e.getLocalizedMessage()));
                }
            }
        });
    }

    private void enableAllControls() {
        boolean isSCDEnabled = this.autoDiscoveryCheckBox.getSelection();
        this.reportProblemsCheckBox.setEnabled(isSCDEnabled);
        this.profileComboBox.setEnabled(isSCDEnabled);
        this.profileOptionsComposite.setVisible(isSCDEnabled);
    }

    public void updateData(ICResourceDescription rcfg) {
        if (this.page.isMultiCfg()) {
            this.setAllVisible(false, null);
            return;
        }
        this.setAllVisible(true, null);
        this.configPath = rcfg.getPath();
        IConfiguration cfg = DiscoveryTab.getCfg(rcfg.getConfiguration());
        this.cbi = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo((IConfiguration)cfg);
        if (!this.page.isForPrefs() && this.baseInfoMap == null) {
            try {
                IProject project = cfg.getOwner().getProject();
                IScannerConfigBuilderInfo2Set baseCbi = ScannerConfigProfileManager.createScannerConfigBuildInfo2Set((IProject)project);
                this.baseInfoMap = baseCbi.getInfoMap();
            }
            catch (CoreException coreException) {}
        }
        this.updateData();
    }

    private void updateData() {
        int selScope = 0;
        String lblText = Messages.DiscoveryTab_5;
        if (!this.cbi.isPerRcTypeDiscovery()) {
            selScope = 1;
            lblText = Messages.DiscoveryTab_8;
        }
        if (this.scopeComboBox != null) {
            this.scopeComboBox.select(selScope);
        }
        this.fTableDefinition.setText(lblText);
        Map infoMap = this.cbi.getInfoMap();
        int pos = this.resTable.getSelectionIndex();
        this.resTable.removeAll();
        for (CfgInfoContext cfgInfoContext : infoMap.keySet()) {
            String s = null;
            IResourceInfo rcInfo = cfgInfoContext.getResourceInfo();
            if (rcInfo == null) {
                s = cfgInfoContext.getConfiguration().getName();
            } else {
                ITool tool;
                if (!this.configPath.equals((Object)rcInfo.getPath())) continue;
                IInputType typ = cfgInfoContext.getInputType();
                if (typ != null) {
                    s = typ.getName();
                }
                if (s == null && (tool = cfgInfoContext.getTool()) != null) {
                    s = tool.getName();
                }
                if (s == null) {
                    s = Messages.DiscoveryTab_3;
                }
            }
            IScannerConfigBuilderInfo2 bi2 = (IScannerConfigBuilderInfo2)infoMap.get(cfgInfoContext);
            TableItem ti = new TableItem(this.resTable, 0);
            ti.setText(s);
            ti.setData("cont", (Object)cfgInfoContext);
            ti.setData("info", (Object)bi2);
        }
        int len = this.resTable.getItemCount();
        if (len > 0) {
            this.setVisibility(null);
            this.resTable.select(pos < len && pos > -1 ? pos : 0);
            this.handleToolSelected();
        } else {
            this.setVisibility(Messages.DiscoveryTab_6);
        }
        this.setEnablement();
    }

    private void setEnablement() {
        ICConfigurationDescription cfgDescription = this.page.getResDesc().getConfiguration();
        boolean isEnabled = !LanguageSettingsProvidersPage.isLanguageSettingsProvidersEnabled((IProject)this.getProject()) || ScannerDiscoveryLegacySupport.isMbsLanguageSettingsProviderOn((ICConfigurationDescription)cfgDescription);
        this.scopeComboBox.setEnabled(isEnabled);
        this.resTable.setEnabled(isEnabled);
        boolean isSCDEnabled = this.autoDiscoveryCheckBox.getSelection();
        this.reportProblemsCheckBox.setEnabled(isEnabled && isSCDEnabled);
        this.autoDiscoveryCheckBox.setEnabled(isEnabled);
        this.autoDiscoveryGroup.setEnabled(isEnabled);
        this.clearButton.setEnabled(isEnabled);
        this.showStatusLine();
    }

    private void showStatusLine() {
        ICConfigurationDescription cfgDescription = this.page.getResDesc().getConfiguration();
        boolean isEnabled = !LanguageSettingsProvidersPage.isLanguageSettingsProvidersEnabled((IProject)this.getProject()) || ScannerDiscoveryLegacySupport.isMbsLanguageSettingsProviderOn((ICConfigurationDescription)cfgDescription);
        Status status = null;
        if (isEnabled) {
            if (this.autoDiscoveryCheckBox.getSelection()) {
                status = new Status(2, "org.eclipse.cdt.ui", "This discovery method is deprecated, use 'Preprocessor Include Paths' instead.");
            }
        } else {
            status = new Status(1, "org.eclipse.cdt.ui", org.eclipse.cdt.internal.ui.newui.Messages.AbstractLangsListTab_MbsProviderNotEnabled);
        }
        this.fStatusLine.setErrorStatus((IStatus)status);
    }

    private void setVisibility(String errMsg) {
        this.autoDiscoveryGroup.setVisible(errMsg == null);
        this.profileOptionsComposite.setVisible(errMsg == null);
        this.resTable.setEnabled(errMsg == null);
        if (errMsg != null) {
            String[] ss;
            String[] stringArray = ss = errMsg.split("\n");
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                new TableItem(this.resTable, 0).setText(line);
                ++n2;
            }
        }
    }

    private String getProfileName(String id) {
        int x = id.lastIndexOf(".");
        return x == -1 ? id : id.substring(x + 1);
    }

    private boolean isMakefileProjectToolChain(IToolChain toolchain) {
        return toolchain != null && (toolchain.getId().equals(MAKEFILE_PROJECT_TOOLCHAIN_ID) || this.isMakefileProjectToolChain(toolchain.getSuperClass()));
    }

    private void handleToolSelected() {
        if (this.resTable.getSelectionCount() == 0) {
            return;
        }
        this.performOK(false);
        TableItem ti = this.resTable.getSelection()[0];
        this.buildInfo = (IScannerConfigBuilderInfo2)ti.getData("info");
        String selectedProfileId = this.buildInfo.getSelectedProfileId();
        this.iContext = (CfgInfoContext)ti.getData("cont");
        boolean autodiscoveryEnabled2 = this.buildInfo.isAutoDiscoveryEnabled();
        if (autodiscoveryEnabled2) {
            IConfiguration cfg = this.iContext.getConfiguration();
            ICConfigurationDescription cfgDescription = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)cfg);
            autodiscoveryEnabled2 = ScannerDiscoveryLegacySupport.isLegacyScannerDiscoveryOn((ICConfigurationDescription)cfgDescription);
        }
        this.autoDiscoveryCheckBox.setSelection(autodiscoveryEnabled2 && !selectedProfileId.equals(""));
        this.reportProblemsCheckBox.setSelection(this.buildInfo.isProblemReportingEnabled());
        this.profileComboBox.removeAll();
        List profilesList = this.buildInfo.getProfileIdList();
        Collections.sort(profilesList, CDTListComparator.getInstance());
        if (this.realPages != null && this.realPages.length > 0) {
            AbstractDiscoveryPage[] abstractDiscoveryPageArray = this.realPages;
            int n = this.realPages.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractDiscoveryPage realPage = abstractDiscoveryPageArray[n2];
                if (realPage != null) {
                    realPage.setVisible(false);
                    realPage.dispose();
                }
                ++n2;
            }
        }
        boolean needPerRcProfile = this.cbi.isPerRcTypeDiscovery();
        Set contextProfiles = null;
        if (this.page.isForPrefs()) {
            contextProfiles = new TreeSet(profilesList);
        } else if (!needPerRcProfile) {
            IToolChain toolchain;
            IConfiguration cfg = this.iContext.getConfiguration();
            IToolChain iToolChain = toolchain = cfg != null ? cfg.getToolChain() : null;
            if (toolchain == null) {
                ManagedBuilderUIPlugin.log((IStatus)new Status(4, ManagedBuilderUIPlugin.getUniqueIdentifier(), "Toolchain=null while trying to get discovery profile per project"));
                return;
            }
            contextProfiles = this.isMakefileProjectToolChain(toolchain) ? new TreeSet(profilesList) : CfgScannerConfigUtil.getAllScannerDiscoveryProfileIds((IToolChain)toolchain);
            if (contextProfiles.size() == 0) {
                contextProfiles.add(GCC_PER_PROJECT_PROFILE);
            }
        } else {
            ITool tool = this.iContext.getTool();
            if (tool == null) {
                return;
            }
            contextProfiles = CfgScannerConfigUtil.getAllScannerDiscoveryProfileIds((ITool)tool);
        }
        this.visibleProfilesList = new ArrayList<String>(contextProfiles);
        this.realPages = new AbstractDiscoveryPage[this.visibleProfilesList.size()];
        String[] labels = new String[this.visibleProfilesList.size()];
        String[] profiles = new String[this.visibleProfilesList.size()];
        int pos = 0;
        int counter = 0;
        while (counter < this.visibleProfilesList.size()) {
            String profileId = this.visibleProfilesList.get(counter);
            labels[counter] = profiles[counter] = this.getProfileName(profileId);
            if (profileId.equals(selectedProfileId)) {
                pos = counter;
            }
            this.buildInfo.setSelectedProfileId(profileId);
            for (DiscoveryProfilePageConfiguration p : this.pagesList) {
                AbstractDiscoveryPage pg;
                if (p == null || !p.profId.equals(profileId) || (pg = p.getPage()) == null) continue;
                this.realPages[counter] = pg;
                String s = p.name;
                if (s != null && s.length() > 0) {
                    labels[counter] = s;
                }
                pg.setContainer((AbstractDiscoveryOptionsBlock)this.wrapper);
                pg.createControl(this.profileOptionsComposite);
                this.profileOptionsComposite.layout(true);
                break;
            }
            ++counter;
        }
        this.profileComboBox.setItems(this.normalize(labels, profiles, this.visibleProfilesList.size()));
        this.buildInfo.setSelectedProfileId(selectedProfileId);
        if (this.profileComboBox.getItemCount() > 0) {
            this.profileComboBox.select(pos);
        }
        this.enableAllControls();
        this.handleDiscoveryProfileChanged();
    }

    private String[] normalize(String[] labels, String[] ids, int counter) {
        int j;
        int mode = CDTPrefUtil.getInt((String)"properties.discovery.naming");
        String[] tmp = new String[counter];
        if (mode == 2 || mode == 3) {
            int i = 0;
            while (i < counter) {
                tmp[i] = mode == 3 ? ids[i] : this.combine(labels[i], ids[i]);
                ++i;
            }
            return tmp;
        }
        boolean doubles = false;
        int i = 0;
        block1: while (i < counter) {
            j = 0;
            while (j < counter) {
                if (i < j && labels[i].equals(labels[j])) {
                    doubles = true;
                    break block1;
                }
                ++j;
            }
            ++i;
        }
        if (!doubles) {
            i = 0;
            while (i < counter) {
                tmp[i] = labels[i];
                ++i;
            }
        } else {
            i = 0;
            while (i < counter) {
                doubles = false;
                j = 0;
                while (j < counter) {
                    if (i != j && labels[i].equals(labels[j])) {
                        doubles = true;
                        break;
                    }
                    ++j;
                }
                tmp[i] = doubles ? (mode == 1 ? ids[i] : this.combine(labels[i], ids[i])) : labels[i];
                ++i;
            }
        }
        return tmp;
    }

    private String combine(String s1, String s2) {
        if (s1.equals(s2)) {
            return s1;
        }
        return String.valueOf(s1) + " (" + s2 + ")";
    }

    private void handleDiscoveryProfileChanged() {
        int pos = this.profileComboBox.getSelectionIndex();
        if (this.realPages != null) {
            int i = 0;
            while (i < this.realPages.length) {
                if (this.realPages[i] != null) {
                    this.realPages[i].setVisible(i == pos);
                }
                ++i;
            }
        }
    }

    private void initializeProfilePageMap() {
        IConfigurationElement[] infos;
        GCCPerProjectSCDProfilePage.isSIConsoleEnabled = DefaultRunSIProvider.isConsoleEnabled();
        this.pagesList = new ArrayList<DiscoveryProfilePageConfiguration>(5);
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE, POINT);
        if (point == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = infos = point.getConfigurationElements();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement info = iConfigurationElementArray[n2];
            if (info.getName().equals(PROFILE_PAGE)) {
                this.pagesList.add(new DiscoveryProfilePageConfiguration(info));
            }
            ++n2;
        }
    }

    public void performApply(ICResourceDescription src, ICResourceDescription dst) {
        if (this.page.isMultiCfg()) {
            return;
        }
        ICfgScannerConfigBuilderInfo2Set cbi1 = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo((IConfiguration)DiscoveryTab.getCfg(src.getConfiguration()));
        ICfgScannerConfigBuilderInfo2Set cbi2 = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo((IConfiguration)DiscoveryTab.getCfg(dst.getConfiguration()));
        cbi2.setPerRcTypeDiscovery(cbi1.isPerRcTypeDiscovery());
        Map m1 = cbi1.getInfoMap();
        Map m2 = cbi2.getInfoMap();
        for (CfgInfoContext ic : m2.keySet()) {
            if (m1.keySet().contains(ic)) {
                IScannerConfigBuilderInfo2 bi1 = (IScannerConfigBuilderInfo2)m1.get(ic);
                try {
                    cbi2.applyInfo(ic, bi1);
                }
                catch (CoreException e) {
                    ManagedBuilderUIPlugin.log(e);
                }
                continue;
            }
            Status status = new Status(4, ManagedBuilderUIPlugin.getUniqueIdentifier(), Messages.DiscoveryTab_7);
            ManagedBuilderUIPlugin.log((IStatus)status);
        }
        this.clearChangedDiscoveredInfos();
        DefaultRunSIProvider.setConsoleEnabled((boolean)GCCPerProjectSCDProfilePage.isSIConsoleEnabled);
    }

    protected void performOK() {
        this.performOK(true);
        DefaultRunSIProvider.setConsoleEnabled((boolean)GCCPerProjectSCDProfilePage.isSIConsoleEnabled);
    }

    private void performOK(boolean ok) {
        if (this.page.isMultiCfg()) {
            return;
        }
        if (this.buildInfo == null) {
            return;
        }
        String savedId = this.buildInfo.getSelectedProfileId();
        if (this.realPages != null) {
            int i = 0;
            while (i < this.realPages.length) {
                if (this.realPages[i] != null) {
                    String s = this.visibleProfilesList.get(i);
                    this.buildInfo.setSelectedProfileId(s);
                    this.realPages[i].performApply();
                    this.realPages[i].setVisible(false);
                }
                ++i;
            }
        }
        this.buildInfo.setSelectedProfileId(savedId);
        this.handleDiscoveryProfileChanged();
        if (ok) {
            this.clearChangedDiscoveredInfos();
        }
    }

    private void clearChangedDiscoveredInfos() {
        IProject project = this.getProject();
        List<CfgInfoContext> changedContexts = this.checkChanges();
        for (CfgInfoContext c : changedContexts) {
            CfgDiscoveredPathManager.getInstance().removeDiscoveredInfo(project, c);
        }
    }

    private List<CfgInfoContext> checkChanges() {
        if (this.cbi == null || this.baseInfoMap == null) {
            return new ArrayList<CfgInfoContext>(0);
        }
        Map cfgInfoMap = this.cbi.getInfoMap();
        HashMap<InfoContext, IScannerConfigBuilderInfo2> baseCopy = new HashMap<InfoContext, IScannerConfigBuilderInfo2>(this.baseInfoMap);
        ArrayList<CfgInfoContext> list = new ArrayList<CfgInfoContext>();
        for (Map.Entry entry : cfgInfoMap.entrySet()) {
            CfgInfoContext cic = (CfgInfoContext)entry.getKey();
            InfoContext c = cic.toInfoContext();
            if (c == null) continue;
            IScannerConfigBuilderInfo2 changed = (IScannerConfigBuilderInfo2)entry.getValue();
            IScannerConfigBuilderInfo2 old = baseCopy.remove(c);
            if (old == null) {
                list.add(cic);
                continue;
            }
            if (this.settingsEqual(changed, old)) continue;
            list.add(cic);
        }
        if (baseCopy.size() != 0) {
            IConfiguration cfg = this.cbi.getConfiguration();
            for (InfoContext c : baseCopy.keySet()) {
                CfgInfoContext cic = CfgInfoContext.fromInfoContext((IConfiguration)cfg, (InfoContext)c);
                if (cic == null) continue;
                list.add(cic);
            }
        }
        return list;
    }

    private boolean settingsEqual(IScannerConfigBuilderInfo2 info1, IScannerConfigBuilderInfo2 info2) {
        if (!CDataUtil.objectsEqual((Object)info1.getSelectedProfileId(), (Object)info2.getSelectedProfileId())) {
            return false;
        }
        if (!CDataUtil.objectsEqual((Object)info1.getBuildOutputFilePath(), (Object)info2.getBuildOutputFilePath())) {
            return false;
        }
        if (!CDataUtil.objectsEqual((Object)info1.getContext(), (Object)info2.getContext())) {
            return false;
        }
        if (!CDataUtil.objectsEqual((Object)info1.getSelectedProfileId(), (Object)info2.getSelectedProfileId())) {
            return false;
        }
        if (info1.isAutoDiscoveryEnabled() != info2.isAutoDiscoveryEnabled() || info1.isBuildOutputFileActionEnabled() != info2.isBuildOutputFileActionEnabled() || info1.isBuildOutputParserEnabled() != info2.isBuildOutputParserEnabled() || info1.isProblemReportingEnabled() != info2.isProblemReportingEnabled()) {
            return false;
        }
        if (!this.listEqual(info1.getProfileIdList(), info2.getProfileIdList())) {
            return false;
        }
        return this.listEqual(info1.getProviderIdList(), info2.getProviderIdList());
    }

    private boolean listEqual(List<String> l1, List<String> l2) {
        if (l1 == null && l2 == null) {
            return true;
        }
        if (l1 == null || l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        if (l1.equals(l2)) {
            return true;
        }
        for (String s : l1) {
            if (l2.contains(s)) continue;
            return false;
        }
        return true;
    }

    public boolean canBeVisible() {
        if (this.page.isMultiCfg()) {
            this.setAllVisible(false, null);
            return false;
        }
        this.setAllVisible(true, null);
        if (this.page.isForProject() || this.page.isForPrefs()) {
            return true;
        }
        IConfiguration cfg = DiscoveryTab.getCfg(this.page.getResDesc().getConfiguration());
        ICfgScannerConfigBuilderInfo2Set _cbi = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo((IConfiguration)cfg);
        return _cbi.isPerRcTypeDiscovery();
    }

    @Override
    public IScannerConfigBuilderInfo2 getBuildInfo() {
        return this.buildInfo;
    }

    @Override
    public CfgInfoContext getContext() {
        return this.iContext;
    }

    @Override
    public IProject getProject() {
        return this.page.getProject();
    }

    @Override
    public ICConfigurationDescription getConfiguration() {
        return this.getResDesc().getConfiguration();
    }

    protected void performDefaults() {
        if (this.page.isMultiCfg()) {
            return;
        }
        this.cbi.setPerRcTypeDiscovery(true);
        for (CfgInfoContext cic : this.cbi.getInfoMap().keySet()) {
            try {
                this.cbi.applyInfo(cic, null);
            }
            catch (CoreException coreException) {}
        }
        this.updateData();
        DefaultRunSIProvider.setConsoleEnabled((boolean)false);
    }

    protected void updateButtons() {
    }

    private void clearDiscoveredEntries() throws CoreException {
        CfgInfoContext cfgInfoContext = this.getContext();
        IConfiguration cfg = cfgInfoContext.getConfiguration();
        if (cfg == null) {
            cfg = cfgInfoContext.getResourceInfo().getParent();
        }
        if (cfg == null) {
            Status status = new Status(4, ManagedBuilderUIPlugin.getUniqueIdentifier(), "Unexpected cfg=null while trying to clear discovery entries");
            throw new CoreException((IStatus)status);
        }
        IProject project = (IProject)cfg.getOwner();
        DiscoveredPathInfo pathInfo = new DiscoveredPathInfo(project);
        InfoContext infoContext = cfgInfoContext.toInfoContext();
        DiscoveredScannerInfoStore dsiStore = DiscoveredScannerInfoStore.getInstance();
        dsiStore.saveDiscoveredScannerInfoToState(project, infoContext, (IDiscoveredPathManager.IDiscoveredScannerInfoSerializable)pathInfo);
        CfgDiscoveredPathManager cdpManager = CfgDiscoveredPathManager.getInstance();
        cdpManager.removeDiscoveredInfo(project, cfgInfoContext);
        ICfgScannerConfigBuilderInfo2Set info2 = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo((IConfiguration)cfg);
        Map infoMap2 = info2.getInfoMap();
        IScannerConfigBuilderInfo2 buildInfo2 = (IScannerConfigBuilderInfo2)infoMap2.get(cfgInfoContext);
        if (buildInfo2 != null) {
            String selectedProfileId;
            ScannerConfigProfileManager scpManager = ScannerConfigProfileManager.getInstance();
            SCProfileInstance profileInstance = scpManager.getSCProfileInstance(project, infoContext, selectedProfileId = buildInfo2.getSelectedProfileId());
            IScannerInfoCollector collector = profileInstance.getScannerInfoCollector();
            if (collector instanceof IScannerInfoCollectorCleaner) {
                ((IScannerInfoCollectorCleaner)collector).deleteAll((IResource)project);
            }
            buildInfo2 = null;
        }
    }

    protected static class DiscoveryProfilePageConfiguration {
        IConfigurationElement fElement;
        private String profId;
        private String name;

        protected DiscoveryProfilePageConfiguration(IConfigurationElement element) {
            this.fElement = element;
            this.profId = this.fElement.getAttribute(DiscoveryTab.PROFILE_ID);
            this.name = this.fElement.getAttribute(DiscoveryTab.PROFILE_NAME);
        }

        protected String getName() {
            return this.name;
        }

        private AbstractDiscoveryPage getPage() {
            try {
                return (AbstractDiscoveryPage)this.fElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {
                return null;
            }
        }
    }
}

