/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui.language.settings.providers;

import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractBuiltinSpecsDetector;
import org.eclipse.cdt.ui.language.settings.providers.AbstractLanguageSettingProviderOptionPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class BuiltinSpecsDetectorOptionPage
extends AbstractLanguageSettingProviderOptionPage {
    private boolean fEditable;
    private Text inputCommand;
    private Button allocateConsoleCheckBox;

    public void createControl(Composite parent) {
        this.fEditable = parent.isEnabled();
        AbstractBuiltinSpecsDetector provider = (AbstractBuiltinSpecsDetector)this.getProvider();
        Composite composite = this.createCompositeForPageArea(parent);
        this.createCompilerCommandInputControl(composite, provider);
        this.createBrowseButton(composite);
        this.createConsoleCheckbox(composite, provider);
        this.setControl((Control)composite);
    }

    private Composite createCompositeForPageArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        layout.marginRight = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)composite);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        return composite;
    }

    private void createCompilerCommandInputControl(Composite composite, AbstractBuiltinSpecsDetector provider) {
        Label label = ControlFactory.createLabel((Composite)composite, (String)Messages.BuiltinSpecsDetectorOptionPage_CompilerSpecsCommand);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label.setEnabled(this.fEditable);
        this.inputCommand = ControlFactory.createTextField((Composite)composite, (int)2052);
        String command = provider.getCommand();
        this.inputCommand.setText(command != null ? command : "");
        this.inputCommand.setEnabled(this.fEditable);
        this.inputCommand.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractBuiltinSpecsDetector provider;
                String text = BuiltinSpecsDetectorOptionPage.this.inputCommand.getText();
                if (!text.equals((provider = (AbstractBuiltinSpecsDetector)BuiltinSpecsDetectorOptionPage.this.getProvider()).getCommand())) {
                    AbstractBuiltinSpecsDetector selectedProvider = (AbstractBuiltinSpecsDetector)BuiltinSpecsDetectorOptionPage.this.getProviderWorkingCopy();
                    selectedProvider.setCommand(text);
                    BuiltinSpecsDetectorOptionPage.this.refreshItem((ILanguageSettingsProvider)selectedProvider);
                }
            }
        });
    }

    private void createBrowseButton(Composite composite) {
        Button button = ControlFactory.createPushButton((Composite)composite, (String)Messages.BuiltinSpecsDetectorOptionPage_Browse);
        button.setEnabled(this.fEditable);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog dialog = new FileDialog(BuiltinSpecsDetectorOptionPage.this.getShell(), 0);
                dialog.setText(Messages.BuiltinSpecsDetectorOptionPage_ChooseFile);
                String fileName = BuiltinSpecsDetectorOptionPage.this.inputCommand.getText();
                int space = fileName.indexOf(32);
                if (space > 0) {
                    fileName = fileName.substring(0, space);
                }
                IPath folder = new Path(fileName).removeLastSegments(1);
                dialog.setFilterPath(folder.toOSString());
                String chosenFile = dialog.open();
                if (chosenFile != null) {
                    BuiltinSpecsDetectorOptionPage.this.inputCommand.insert(chosenFile);
                }
            }
        });
    }

    private void createConsoleCheckbox(Composite composite, AbstractBuiltinSpecsDetector provider) {
        this.allocateConsoleCheckBox = new Button(composite, 32);
        this.allocateConsoleCheckBox.setText(Messages.BuiltinSpecsDetectorOptionPage_AllocateConsole);
        this.allocateConsoleCheckBox.setSelection(provider.isConsoleEnabled());
        this.allocateConsoleCheckBox.setEnabled(this.fEditable);
        this.allocateConsoleCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractBuiltinSpecsDetector provider;
                boolean enabled = BuiltinSpecsDetectorOptionPage.this.allocateConsoleCheckBox.getSelection();
                if (enabled != (provider = (AbstractBuiltinSpecsDetector)BuiltinSpecsDetectorOptionPage.this.getProvider()).isConsoleEnabled()) {
                    AbstractBuiltinSpecsDetector selectedProvider = (AbstractBuiltinSpecsDetector)BuiltinSpecsDetectorOptionPage.this.getProviderWorkingCopy();
                    selectedProvider.setConsoleEnabled(enabled);
                    BuiltinSpecsDetectorOptionPage.this.refreshItem((ILanguageSettingsProvider)selectedProvider);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        ILanguageSettingsProvider initialProvider;
        ILanguageSettingsProvider provider = this.providerTab.getProvider(this.providerId);
        if (!(!(provider instanceof AbstractBuiltinSpecsDetector) || (initialProvider = this.providerTab.getInitialProvider(this.providerId)) instanceof AbstractBuiltinSpecsDetector && ((AbstractBuiltinSpecsDetector)initialProvider).getCommand().equals(((AbstractBuiltinSpecsDetector)provider).getCommand()))) {
            ((AbstractBuiltinSpecsDetector)provider).clear();
        }
        super.performApply(monitor);
    }
}

