/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.model.ICDITargetConfiguration;
import org.eclipse.cdt.debug.mi.core.MIInferior;
import org.eclipse.cdt.debug.mi.core.MIProcess;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;

public class TargetConfiguration
extends CObject
implements ICDITargetConfiguration {
    public TargetConfiguration(Target target) {
        super(target);
    }

    public boolean supportsBreakpoints() {
        return true;
    }

    public boolean supportsDisconnect() {
        MISession miSession = ((Target)this.getTarget()).getMISession();
        return miSession.isAttachSession();
    }

    public boolean supportsExpressionEvaluation() {
        return true;
    }

    public boolean supportsInstructionStepping() {
        return true;
    }

    public boolean supportsMemoryModification() {
        return true;
    }

    public boolean supportsMemoryRetrieval() {
        return true;
    }

    public boolean supportsRegisterModification() {
        return true;
    }

    public boolean supportsRegisters() {
        return true;
    }

    public boolean supportsSharedLibrary() {
        return true;
    }

    public boolean supportsRestart() {
        MISession miSession = ((Target)this.getTarget()).getMISession();
        return !miSession.isAttachSession();
    }

    public boolean supportsStepping() {
        return true;
    }

    public boolean supportsTerminate() {
        return true;
    }

    public boolean supportsResume() {
        return true;
    }

    public boolean supportsSuspend() {
        String os = null;
        try {
            os = System.getProperty("os.name", "");
        }
        catch (SecurityException securityException) {}
        Target target = (Target)this.getTarget();
        MISession miSession = target.getMISession();
        MIProcess gdb = miSession.getGDBProcess();
        MIInferior inferior = miSession.getMIInferior();
        if (gdb.canInterrupt(inferior)) {
            if (miSession.isAttachSession()) {
                return true;
            }
            if (os.equals("SunOS")) {
                return inferior.getTTY() == null;
            }
            return true;
        }
        return false;
    }

    public boolean terminateSessionOnExit() {
        return true;
    }
}

