/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.filters;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterContainerReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.filters.ISystemFilterStringReference;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.ISystemContainer;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.references.IRSEBaseReferencedObject;
import org.eclipse.rse.core.references.SystemReferencingObject;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.core.filters.SystemFilterContainerReferenceCommonMethods;
import org.eclipse.rse.internal.core.filters.SystemFilterStringReference;

public class SystemFilterReference
extends SystemReferencingObject
implements IAdaptable,
ISystemFilterReference {
    private SystemFilterContainerReferenceCommonMethods containerHelper = new SystemFilterContainerReferenceCommonMethods(this);
    private ISystemFilterContainerReference parent = null;
    private ISystemFilter referencedFilter = null;
    private ISystemFilterStringReference[] referencedFilterStrings = null;
    protected boolean persistent = true;
    protected boolean isStale = true;
    protected ISubSystem _subSystem;
    protected HashMap cachedContents = new HashMap();
    public static final boolean PERSISTENT_YES = true;
    public static final boolean PERSISTENT_NO = false;

    protected SystemFilterReference() {
    }

    public static ISystemFilterReference createSystemFilterReference(ISubSystem subSystem, ISystemFilterContainerReference parent, ISystemFilter filter, boolean persistent) {
        SystemFilterReference newRef = new SystemFilterReference();
        newRef.persistent = persistent;
        newRef.setSubSystem(subSystem);
        newRef.setParent(parent);
        newRef.setReferencedFilter(filter);
        filter.addReference(newRef);
        return newRef;
    }

    public ISubSystem getSubSystem() {
        return this._subSystem;
    }

    public void setSubSystem(ISubSystem subSystem) {
        this._subSystem = subSystem;
    }

    public ISystemFilterPoolReferenceManager getFilterPoolReferenceManager() {
        ISystemFilterPoolReference pool = this.getParentSystemFilterReferencePool();
        if (pool != null) {
            return pool.getFilterPoolReferenceManager();
        }
        return null;
    }

    public ISystemFilterPoolReferenceManagerProvider getProvider() {
        ISystemFilterPoolReferenceManager mgr = this.getFilterPoolReferenceManager();
        if (mgr != null) {
            ISystemFilterPoolReferenceManagerProvider provider = mgr.getProvider();
            if (provider == null) {
                provider = this.getSubSystem();
            }
            return provider;
        }
        return null;
    }

    public void setParent(ISystemFilterContainerReference parent) {
        this.parent = parent;
    }

    public ISystemFilterContainerReference getParent() {
        return this.parent;
    }

    public ISystemFilter getReferencedFilter() {
        return this.persistent ? (ISystemFilter)super.getReferencedObject() : this.referencedFilter;
    }

    public void setReferencedFilter(ISystemFilter filter) {
        if (this.persistent) {
            super.setReferencedObject(filter);
        } else {
            this.referencedFilter = filter;
        }
    }

    public ISystemFilterPoolReference getParentSystemFilterReferencePool() {
        if (this.parent instanceof ISystemFilterPoolReference) {
            return (ISystemFilterPoolReference)this.parent;
        }
        return ((ISystemFilterReference)this.parent).getParentSystemFilterReferencePool();
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public ISystemFilterContainer getReferencedSystemFilterContainer() {
        return this.getReferencedFilter();
    }

    public ISystemFilterReference[] getSystemFilterReferences(ISubSystem subSystem) {
        List references = this.containerHelper.getSystemFilterReferences(subSystem);
        ISystemFilterReference[] result = new ISystemFilterReference[references.size()];
        references.toArray(result);
        return result;
    }

    public ISystemFilterReference getSystemFilterReference(ISubSystem subSystem, ISystemFilter filter) {
        return this.containerHelper.generateAndRecordFilterReference(subSystem, filter);
    }

    public ISystemFilterReference getExistingSystemFilterReference(ISubSystem subSystem, ISystemFilter filter) {
        return this.containerHelper.getExistingSystemFilterReference(subSystem, filter);
    }

    public boolean hasFilters() {
        return this.containerHelper.hasFilters();
    }

    public int getFilterCount() {
        return this.containerHelper.getFilterCount();
    }

    public String getName() {
        ISystemFilter filter = this.getReferencedFilter();
        if (filter != null) {
            return filter.getName();
        }
        return "";
    }

    public String toString() {
        return this.getName();
    }

    public int getSystemFilterStringCount() {
        int count = 0;
        ISystemFilter referencedFilter = this.getReferencedFilter();
        if (referencedFilter != null) {
            count = referencedFilter.getFilterStringCount();
        }
        return count;
    }

    public ISystemFilterStringReference[] getSystemFilterStringReferences() {
        ISystemFilterString[] filterStrings = this.getReferencedFilter().getStrings();
        List<ISystemFilterString> filterStringList = Arrays.asList(filterStrings);
        boolean needToReGen = this.compareFilterStrings(filterStringList);
        if (needToReGen) {
            this.referencedFilterStrings = this.generateFilterStringReferences(filterStringList);
        }
        return this.referencedFilterStrings;
    }

    public ISystemFilterStringReference getSystemFilterStringReference(ISystemFilterString filterString) {
        return new SystemFilterStringReference(this, filterString);
    }

    private boolean compareFilterStrings(List newFilterStrings) {
        boolean mustReGen = false;
        if (newFilterStrings == null) {
            return this.referencedFilterStrings != null;
        }
        if (this.referencedFilterStrings == null) {
            return true;
        }
        if (newFilterStrings.size() != this.referencedFilterStrings.length) {
            return true;
        }
        Iterator i = newFilterStrings.iterator();
        int idx = 0;
        while (!mustReGen && idx < this.referencedFilterStrings.length) {
            ISystemFilterString newFilterString = (ISystemFilterString)i.next();
            if (!this.referencedFilterStrings[idx].getReferencedFilterString().equals(newFilterString)) {
                mustReGen = true;
            }
            ++idx;
        }
        return mustReGen;
    }

    private ISystemFilterStringReference[] generateFilterStringReferences(List newFilterStrings) {
        if (newFilterStrings == null) {
            return null;
        }
        ISystemFilterStringReference[] refs = new ISystemFilterStringReference[newFilterStrings.size()];
        Iterator i = newFilterStrings.iterator();
        int idx = 0;
        while (i.hasNext()) {
            refs[idx++] = this.getSystemFilterStringReference((ISystemFilterString)i.next());
        }
        return refs;
    }

    public void setReferencedObject(IRSEBaseReferencedObject obj) {
        this.setReferencedFilter((ISystemFilter)obj);
    }

    public IRSEBaseReferencedObject getReferencedObject() {
        return this.getReferencedFilter();
    }

    public int removeReference() {
        int count = 0;
        if (this.persistent) {
            super.removeReference();
        }
        this.setReferencedFilter(null);
        return count;
    }

    public boolean hasContents(ISystemContentsType contentsType) {
        return this.cachedContents.containsKey(contentsType);
    }

    public Object[] getContents(ISystemContentsType contentsType) {
        return (Object[])this.cachedContents.get(contentsType);
    }

    public void setContents(ISystemContentsType type, Object[] cachedContents) {
        this.cachedContents.put(type, cachedContents);
        this.isStale = false;
    }

    public boolean isStale() {
        return this.isStale;
    }

    public void markStale(boolean isStale) {
        this.markStale(isStale, true);
    }

    public void markStale(boolean isStale, boolean clearCache) {
        this.isStale = isStale;
        if (clearCache && isStale) {
            for (Object[] arr : this.cachedContents.values()) {
                int i = 0;
                while (i < arr.length) {
                    Object obj = arr[i];
                    if (obj instanceof ISystemContainer) {
                        ((ISystemContainer)obj).markStale(true);
                    }
                    ++i;
                }
            }
            this.cachedContents.clear();
        }
    }

    public boolean commit() {
        return false;
    }

    public IRSEPersistableContainer getPersistableParent() {
        return null;
    }

    public IRSEPersistableContainer[] getPersistableChildren() {
        return IRSEPersistableContainer.NO_CHILDREN;
    }
}

