/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints.TraceVarDetailsDialog;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints.TracepointImageRegistry;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints.TracepointsMessages;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class TraceControlView
extends ViewPart
implements IViewPart,
DsfSession.SessionEndedListener {
    private static final String EMPTY_STRING = "";
    private ISelectionListener fDebugViewListener;
    private String fDebugSessionId;
    private DsfServicesTracker fServicesTracker;
    private volatile IGDBTraceControl.ITraceTargetDMContext fTargetContext;
    private StyledText fStatusText;
    protected Action fActionRefreshView;
    protected Action fOpenTraceVarDetails;
    protected Action fActionExitVisualization;
    private boolean fTracingSupported;
    private boolean fTraceVisualization;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.fDebugViewListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                TraceControlView.this.updateDebugContext();
            }
        };
        site.getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", this.fDebugViewListener);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.fStatusText = new StyledText(composite, 2);
        GridData gd = new GridData(4, 4, true, true);
        this.fStatusText.setLayoutData((Object)gd);
        this.fStatusText.setEditable(false);
        this.fStatusText.setCaret(null);
        this.createActions();
        if (this.fDebugSessionId != null) {
            this.debugSessionChanged();
        } else {
            this.updateDebugContext();
        }
        DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)this);
    }

    protected void createActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        this.fActionRefreshView = new ActionRefreshView();
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fActionRefreshView);
        manager.add((IAction)this.fActionRefreshView);
        this.fOpenTraceVarDetails = new ActionOpenTraceVarDetails();
        manager.add((IAction)this.fOpenTraceVarDetails);
        this.fActionExitVisualization = new ActionExitVisualizationModeDetails();
        manager.add((IAction)this.fActionExitVisualization);
        bars.updateActionBars();
        this.updateActionEnablement();
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", this.fDebugViewListener);
        this.fStatusText = null;
        this.setDebugContext(null);
        super.dispose();
    }

    protected void updateContent() {
        IGDBTraceControl.ITraceTargetDMContext ctx;
        if (this.fDebugSessionId != null && this.getSession() != null && (ctx = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.fTargetContext, IGDBTraceControl.ITraceTargetDMContext.class)) != null) {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IGDBTraceControl traceControl = (IGDBTraceControl)TraceControlView.this.getService(IGDBTraceControl.class);
                    if (traceControl != null) {
                        traceControl.getTraceStatus(ctx, (DataRequestMonitor)new DataRequestMonitor<IGDBTraceControl.ITraceStatusDMData>((Executor)TraceControlView.this.getSession().getExecutor(), null){

                            protected void handleCompleted() {
                                String traceStatus = TraceControlView.EMPTY_STRING;
                                if (this.isSuccess() && this.getData() != null) {
                                    TraceControlView.this.fTracingSupported = ((IGDBTraceControl.ITraceStatusDMData)this.getData()).isTracingSupported();
                                    if (TraceControlView.this.fTracingSupported && (traceStatus = ((IGDBTraceControl.ITraceStatusDMData)this.getData()).toString()).length() > 0) {
                                        Calendar cal = Calendar.getInstance();
                                        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
                                        traceStatus = String.valueOf(TracepointsMessages.TraceControlView_trace_view_content_updated_label) + sdf.format(cal.getTime()) + "\n" + traceStatus;
                                    }
                                } else {
                                    TraceControlView.this.fTracingSupported = false;
                                }
                                final String finalStatus = traceStatus;
                                TraceControlView.this.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        TraceControlView.this.fStatusText.setText(finalStatus);
                                        TraceControlView.this.updateActionEnablement();
                                    }
                                });
                            }
                        });
                    } else {
                        TraceControlView.this.fTracingSupported = false;
                        TraceControlView.this.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                TraceControlView.this.fStatusText.setText(TraceControlView.EMPTY_STRING);
                                TraceControlView.this.updateActionEnablement();
                            }
                        });
                    }
                }
            });
            return;
        }
        if (this.fStatusText != null) {
            this.fStatusText.setText(EMPTY_STRING);
        }
        this.updateActionEnablement();
    }

    protected void exitVisualizationMode() {
        if (this.fDebugSessionId == null || this.getSession() == null) {
            return;
        }
        final IGDBTraceControl.ITraceTargetDMContext ctx = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.fTargetContext, IGDBTraceControl.ITraceTargetDMContext.class);
        if (ctx == null) {
            return;
        }
        this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                IGDBTraceControl traceControl = (IGDBTraceControl)TraceControlView.this.getService(IGDBTraceControl.class);
                if (traceControl != null) {
                    IGDBTraceControl.ITraceRecordDMContext emptyDmc = traceControl.createTraceRecordContext(ctx, "-1");
                    traceControl.selectTraceRecord(emptyDmc, (RequestMonitor)new ImmediateRequestMonitor());
                }
            }
        });
    }

    protected void updateDebugContext() {
        IAdaptable debugContext = DebugUITools.getDebugContext();
        if (debugContext instanceof IDMVMContext) {
            this.setDebugContext((IDMVMContext)debugContext);
        } else {
            this.setDebugContext(null);
        }
    }

    protected void setDebugContext(IDMVMContext vmContext) {
        if (vmContext != null) {
            IDMContext dmContext = vmContext.getDMContext();
            String sessionId = dmContext.getSessionId();
            this.fTargetContext = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)dmContext, IGDBTraceControl.ITraceTargetDMContext.class);
            if (!sessionId.equals(this.fDebugSessionId)) {
                if (this.fDebugSessionId != null && this.getSession() != null) {
                    try {
                        final DsfSession session = this.getSession();
                        session.getExecutor().execute((Runnable)new DsfRunnable(){

                            public void run() {
                                session.removeServiceEventListener((Object)TraceControlView.this);
                            }
                        });
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {}
                }
                this.fDebugSessionId = sessionId;
                if (this.fServicesTracker != null) {
                    this.fServicesTracker.dispose();
                }
                this.fServicesTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), sessionId);
                this.debugSessionChanged();
            }
        } else if (this.fDebugSessionId != null) {
            if (this.getSession() != null) {
                try {
                    final DsfSession session = this.getSession();
                    session.getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            session.removeServiceEventListener((Object)TraceControlView.this);
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            }
            this.fDebugSessionId = null;
            this.fTargetContext = null;
            if (this.fServicesTracker != null) {
                this.fServicesTracker.dispose();
                this.fServicesTracker = null;
            }
            this.debugSessionChanged();
        }
    }

    private void debugSessionChanged() {
        this.fTracingSupported = false;
        if (this.fDebugSessionId != null && this.getSession() != null) {
            try {
                final DsfSession session = this.getSession();
                session.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        session.addServiceEventListener((Object)TraceControlView.this, null);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        }
        this.updateContent();
    }

    protected void updateActionEnablement() {
        this.fOpenTraceVarDetails.setEnabled(this.fTracingSupported);
        this.fActionRefreshView.setEnabled(this.fTracingSupported);
        if (this.fStatusText != null && this.fStatusText.getText().toLowerCase().indexOf("off-line") != -1) {
            this.fActionExitVisualization.setEnabled(false);
        } else {
            this.fActionExitVisualization.setEnabled(this.fTraceVisualization);
        }
    }

    private void asyncExec(Runnable runnable) {
        if (this.fStatusText != null) {
            this.fStatusText.getDisplay().asyncExec(runnable);
        }
    }

    public void sessionEnded(DsfSession session) {
        if (session.getId().equals(this.fDebugSessionId)) {
            this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    TraceControlView.this.setDebugContext(null);
                }
            });
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IGDBTraceControl.ITracingStartedDMEvent event) {
        this.updateContent();
    }

    @DsfServiceEventHandler
    public void handleEvent(IGDBTraceControl.ITracingStoppedDMEvent event) {
        this.updateContent();
    }

    @DsfServiceEventHandler
    public void handleEvent(IGDBTraceControl.ITraceRecordSelectedChangedDMEvent event) {
        this.fTraceVisualization = event.isVisualizationModeEnabled();
        this.updateContent();
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.ISuspendedDMEvent event) {
        this.updateContent();
    }

    @DsfServiceEventHandler
    public void handleEvent(IGDBTraceControl.ITracingSupportedChangeDMEvent event) {
        this.updateContent();
    }

    public void setFocus() {
        if (this.fStatusText != null) {
            this.fStatusText.setFocus();
        }
    }

    private DsfSession getSession() {
        return DsfSession.getSession((String)this.fDebugSessionId);
    }

    private <V> V getService(Class<V> serviceClass) {
        if (this.fServicesTracker != null) {
            return (V)this.fServicesTracker.getService(serviceClass);
        }
        return null;
    }

    public IGDBTraceControl.ITraceVariableDMData[] getTraceVarList() {
        if (this.fDebugSessionId == null || this.getSession() == null) {
            return null;
        }
        final IGDBTraceControl.ITraceTargetDMContext ctx = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.fTargetContext, IGDBTraceControl.ITraceTargetDMContext.class);
        if (ctx == null) {
            return null;
        }
        Query<IGDBTraceControl.ITraceVariableDMData[]> query = new Query<IGDBTraceControl.ITraceVariableDMData[]>(){

            protected void execute(final DataRequestMonitor<IGDBTraceControl.ITraceVariableDMData[]> rm) {
                IGDBTraceControl traceControl = (IGDBTraceControl)TraceControlView.this.getService(IGDBTraceControl.class);
                if (traceControl != null) {
                    traceControl.getTraceVariables(ctx, (DataRequestMonitor)new DataRequestMonitor<IGDBTraceControl.ITraceVariableDMData[]>((Executor)TraceControlView.this.getSession().getExecutor(), rm){

                        protected void handleCompleted() {
                            if (this.isSuccess()) {
                                rm.setData((Object)((IGDBTraceControl.ITraceVariableDMData[])this.getData()));
                            } else {
                                rm.setData(null);
                            }
                            rm.done();
                        }
                    });
                } else {
                    rm.setData(null);
                    rm.done();
                }
            }
        };
        try {
            this.getSession().getExecutor().execute((Runnable)query);
            return (IGDBTraceControl.ITraceVariableDMData[])query.get(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (TimeoutException timeoutException) {}
        return null;
    }

    protected void createVariable(final String name, final String value) throws FailedTraceVariableCreationException {
        if (this.fDebugSessionId == null || this.getSession() == null) {
            throw new FailedTraceVariableCreationException(TracepointsMessages.TraceControlView_create_variable_error);
        }
        final IGDBTraceControl.ITraceTargetDMContext ctx = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.fTargetContext, IGDBTraceControl.ITraceTargetDMContext.class);
        if (ctx == null) {
            throw new FailedTraceVariableCreationException(TracepointsMessages.TraceControlView_create_variable_error);
        }
        Query<String> query = new Query<String>(){

            protected void execute(DataRequestMonitor<String> rm) {
                IGDBTraceControl traceControl = (IGDBTraceControl)TraceControlView.this.getService(IGDBTraceControl.class);
                if (traceControl != null) {
                    traceControl.createTraceVariable(ctx, name, value, new RequestMonitor((Executor)TraceControlView.this.getSession().getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
                        private final /* synthetic */ DataRequestMonitor val$rm;
                        {
                            this.val$rm = dataRequestMonitor;
                            super($anonymous0, $anonymous1);
                        }

                        protected void handleFailure() {
                            String message = TracepointsMessages.TraceControlView_create_variable_error;
                            Throwable t = this.getStatus().getException();
                            if (t != null) {
                                message = t.getMessage();
                            }
                            FailedTraceVariableCreationException e = new FailedTraceVariableCreationException(message);
                            this.val$rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10001, "Backend error", (Throwable)e));
                            this.val$rm.done();
                        }
                    });
                } else {
                    FailedTraceVariableCreationException e = new FailedTraceVariableCreationException(TracepointsMessages.TraceControlView_trace_variable_tracing_unavailable);
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10001, "Tracing unavailable", (Throwable)e));
                    rm.done();
                }
            }
        };
        try {
            this.getSession().getExecutor().execute((Runnable)query);
            query.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof CoreException && (t = ((CoreException)t).getStatus().getException()) instanceof FailedTraceVariableCreationException) {
                throw (FailedTraceVariableCreationException)t;
            }
            throw new FailedTraceVariableCreationException(TracepointsMessages.TraceControlView_create_variable_error);
        }
    }

    private final class ActionExitVisualizationModeDetails
    extends Action {
        public ActionExitVisualizationModeDetails() {
            this.setText(TracepointsMessages.TraceControlView_action_exit_visualization_mode);
            this.setImageDescriptor(TracepointImageRegistry.getImageDescriptor(TracepointImageRegistry.ICON_Exit_Visualization));
        }

        public void run() {
            TraceControlView.this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    TraceControlView.this.exitVisualizationMode();
                    TraceControlView.this.updateActionEnablement();
                }
            });
        }
    }

    private final class ActionOpenTraceVarDetails
    extends Action {
        public ActionOpenTraceVarDetails() {
            this.setText(TracepointsMessages.TraceControlView_action_trace_variable_details);
            this.setImageDescriptor(TracepointImageRegistry.getImageDescriptor(TracepointImageRegistry.ICON_Trace_Variables));
        }

        public void run() {
            Shell shell = Display.getDefault().getActiveShell();
            TraceVarDetailsDialog dialog = new TraceVarDetailsDialog(shell, TraceControlView.this);
            dialog.open();
        }
    }

    private final class ActionRefreshView
    extends Action {
        public ActionRefreshView() {
            this.setText(TracepointsMessages.TraceControlView_action_Refresh_label);
            this.setImageDescriptor(TracepointImageRegistry.getImageDescriptor(TracepointImageRegistry.ICON_Refresh_enabled));
            this.setDisabledImageDescriptor(TracepointImageRegistry.getImageDescriptor(TracepointImageRegistry.ICON_Refresh_disabled));
        }

        public void run() {
            TraceControlView.this.updateContent();
        }
    }

    public class FailedTraceVariableCreationException
    extends Exception {
        private static final long serialVersionUID = -3042693455630687285L;

        FailedTraceVariableCreationException() {
        }

        FailedTraceVariableCreationException(String errorMessage) {
            super(errorMessage);
        }
    }
}

