/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.cdt.ui;

import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.cdt.ui.CDTStructureBridge;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class InterestUpdateDeltaListener
implements IElementChangedListener {
    private static boolean asyncExecMode = true;

    public void elementChanged(ElementChangedEvent event) {
        ICElementDelta delta = event.getDelta();
        this.handleDelta(delta.getAffectedChildren());
    }

    private void handleDelta(ICElementDelta[] delta) {
        try {
            IInteractionElement element;
            ICElement added = null;
            ICElement removed = null;
            ICElementDelta[] iCElementDeltaArray = delta;
            int n = delta.length;
            int n2 = 0;
            while (n2 < n) {
                ICElementDelta child = iCElementDeltaArray[n2];
                if (child.getElement() instanceof ITranslationUnit && ((ITranslationUnit)child.getElement()).getParent() != null) {
                    return;
                }
                if (child.getKind() == 1) {
                    if (added == null) {
                        added = child.getElement();
                    }
                } else if (child.getKind() == 2 && removed == null) {
                    removed = child.getElement();
                }
                this.handleDelta(child.getAffectedChildren());
                ++n2;
            }
            if (added != null && removed != null) {
                element = ContextCore.getContextManager().getElement(CDTStructureBridge.getHandleForElement(removed));
                if (element != null) {
                    this.resetHandle(element, CDTStructureBridge.getHandleForElement(added));
                }
            } else if (removed != null && (element = ContextCore.getContextManager().getElement(CDTStructureBridge.getHandleForElement(removed))) != null) {
                this.delete(element);
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", "Unexpected error while updating interest", t));
        }
    }

    private void resetHandle(final IInteractionElement element, final String newHandle) {
        if (!asyncExecMode) {
            ContextCore.getContextManager().updateHandle(element, newHandle);
        } else {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                workbench.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ContextCore.getContextManager().updateHandle(element, newHandle);
                    }
                });
            }
        }
    }

    private void delete(final IInteractionElement element) {
        if (!asyncExecMode) {
            ContextCore.getContextManager().deleteElement(element);
        } else {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                workbench.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ContextCore.getContextManager().deleteElement(element);
                    }
                });
            }
        }
    }

    public static void setAsyncExecMode(boolean asyncExecMode) {
        InterestUpdateDeltaListener.asyncExecMode = asyncExecMode;
    }
}

