/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditor;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileElement;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecfileFoldingStructureProvider {
    private static final Annotation[] EMPTY = new Annotation[0];
    private SpecfileEditor sEditor;
    private IDocument sDocument;
    private IProgressMonitor sProgressMonitor;

    public SpecfileFoldingStructureProvider(SpecfileEditor editor) {
        this.sEditor = editor;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.sProgressMonitor = progressMonitor;
    }

    public void setDocument(IDocument document) {
        this.sDocument = document;
    }

    public void updateFoldingRegions() {
        ProjectionAnnotationModel model = (ProjectionAnnotationModel)this.sEditor.getAdapter(ProjectionAnnotationModel.class);
        if (model != null) {
            this.updateFoldingRegions(model);
        }
    }

    void updateFoldingRegions(ProjectionAnnotationModel model) {
        Set<Position> structure = this.createFoldingStructure(this.sEditor.getSpecfile());
        Annotation[] deletions = this.computeDifferences(model, structure);
        Map<Annotation, Position> additions = this.computeAdditions(structure);
        if (!(deletions.length == 0 && additions.isEmpty() || this.sProgressMonitor != null && this.sProgressMonitor.isCanceled())) {
            model.modifyAnnotations(deletions, additions, EMPTY);
        }
    }

    private Map<Annotation, Position> computeAdditions(Set<Position> currentRegions) {
        HashMap<Annotation, Position> additionsMap = new HashMap<Annotation, Position>();
        for (Position position : currentRegions) {
            additionsMap.put((Annotation)new ProjectionAnnotation(), position);
        }
        return additionsMap;
    }

    private Annotation[] computeDifferences(ProjectionAnnotationModel model, Set<Position> current) {
        ArrayList<Annotation> deletions = new ArrayList<Annotation>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Annotation annotation = (Annotation)iter.next();
            if (!(annotation instanceof ProjectionAnnotation)) continue;
            Position position = model.getPosition(annotation);
            if (current.contains(position)) {
                current.remove(position);
                continue;
            }
            deletions.add(annotation);
        }
        return deletions.toArray(new Annotation[deletions.size()]);
    }

    private Set<Position> createFoldingStructure(Specfile specfile) {
        HashSet<Position> set = new HashSet<Position>();
        ArrayList<SpecfileSection> elements = new ArrayList<SpecfileSection>();
        elements.addAll(specfile.getSections());
        elements.addAll(specfile.getComplexSections());
        Collections.sort(elements, new ElementByLineNbrComparator());
        this.addFoldingRegions(set, elements.toArray());
        return set;
    }

    private void addFoldingRegions(Set<Position> regions, Object[] elements) {
        Position position;
        try {
            SpecfileElement element = (SpecfileElement)elements[0];
            position = new Position(0, element.getLineStartPosition() - 1);
            regions.add(position);
        }
        catch (Exception exception) {}
        int i = 0;
        while (i < elements.length) {
            int lenghtPos;
            SpecfileElement startElement = (SpecfileElement)elements[i];
            int offsetPos = startElement.getLineStartPosition();
            if (i < elements.length - 1) {
                SpecfileElement endElement = (SpecfileElement)elements[i + 1];
                lenghtPos = endElement.getLineStartPosition() - startElement.getLineStartPosition() - 1;
            } else {
                lenghtPos = this.sDocument.getLength() - startElement.getLineStartPosition();
            }
            position = new Position(offsetPos, lenghtPos);
            regions.add(position);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementByLineNbrComparator
    implements Comparator<SpecfileElement> {
        private ElementByLineNbrComparator() {
        }

        @Override
        public int compare(SpecfileElement element1, SpecfileElement element2) {
            Integer lineNbr1 = element1.getLineNumber();
            Integer lineNbr2 = element2.getLineNumber();
            return lineNbr1.compareTo(lineNbr2);
        }
    }
}

