/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.ProblemFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPComputableFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunction;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameterSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTypeList;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPFunctionSpecialization
extends PDOMCPPSpecialization
implements ICPPFunction,
ICPPComputableFunction {
    private static final int NUM_PARAMS = 40;
    private static final int FIRST_PARAM = 44;
    private static final int FUNCTION_TYPE = 48;
    protected static final int EXCEPTION_SPEC = 54;
    protected static final int ANNOTATION = 58;
    private static final int REQUIRED_ARG_COUNT = 60;
    private static final int RETURN_EXPRESSION = 62;
    protected static final int RECORD_SIZE = 68;
    private static final short ANNOT_PARAMETER_PACK = 8;
    private static final short ANNOT_IS_DELETED = 9;
    private static final short ANNOT_IS_CONSTEXPR = 10;
    private ICPPFunctionType fType;
    private short fAnnotation = (short)-1;
    private int fRequiredArgCount = -1;

    public PDOMCPPFunctionSpecialization(PDOMLinkage linkage, PDOMNode parent, ICPPFunction astFunction, PDOMBinding specialized) throws CoreException {
        super(linkage, parent, (ICPPSpecialization)((Object)astFunction), specialized);
        ICPPFunction origAstFunc;
        ICPPParameter[] origAstParams;
        Database db = this.getDB();
        ICPPParameter[] astParams = astFunction.getParameters();
        ICPPFunctionType astFt = astFunction.getType();
        if (astFt != null) {
            ((PDOMLinkage)this.getLinkage()).storeType(this.record + 48L, astFt);
        }
        if ((origAstParams = (origAstFunc = (ICPPFunction)((ICPPSpecialization)((Object)astFunction)).getSpecializedBinding()).getParameters()).length == 0) {
            db.putInt(this.record + 40L, 0);
            db.putRecPtr(this.record + 44L, 0L);
        } else {
            int length = astParams.length;
            db.putInt(this.record + 40L, length);
            db.putRecPtr(this.record + 44L, 0L);
            PDOMCPPParameter origPar = null;
            PDOMNode next = null;
            int i = length;
            while (--i >= 0) {
                if (i < origAstParams.length - 1) {
                    origPar = new PDOMCPPParameter(linkage, specialized, origAstParams[i], null);
                } else if (origPar == null) {
                    origPar = new PDOMCPPParameter(linkage, specialized, origAstParams[origAstParams.length - 1], null);
                }
                next = new PDOMCPPParameterSpecialization(linkage, this, astParams[i], origPar, (PDOMCPPParameterSpecialization)next);
            }
            db.putRecPtr(this.record + 44L, next == null ? 0L : next.getRecord());
        }
        this.fAnnotation = this.getAnnotation(astFunction);
        db.putShort(this.record + 58L, this.fAnnotation);
        db.putShort(this.record + 60L, (short)astFunction.getRequiredArgumentCount());
        ICPPEvaluation returnExpression = CPPFunction.getReturnExpression(astFunction);
        if (returnExpression != null) {
            linkage.storeEvaluation(this.record + 62L, returnExpression);
        }
        long typelist = 0L;
        if (!(astFunction instanceof ICPPMethod) || !((ICPPMethod)astFunction).isImplicit()) {
            typelist = PDOMCPPTypeList.putTypes(this, astFunction.getExceptionSpecification());
        }
        db.putRecPtr(this.record + 54L, typelist);
    }

    private short getAnnotation(ICPPFunction astFunction) {
        int annot = PDOMCPPAnnotation.encodeAnnotation(astFunction) & 0xFF;
        if (astFunction.hasParameterPack()) {
            annot |= 0x100;
        }
        if (astFunction.isDeleted()) {
            annot |= 0x200;
        }
        if (astFunction.isConstexpr()) {
            annot |= 0x400;
        }
        return (short)annot;
    }

    public PDOMCPPFunctionSpecialization(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    @Override
    protected int getRecordSize() {
        return 68;
    }

    @Override
    public int getNodeType() {
        return 34;
    }

    @Override
    public boolean isInline() {
        return PDOMCPPFunctionSpecialization.getBit(this.readAnnotation(), 2);
    }

    private short readAnnotation() {
        if (this.fAnnotation == -1) {
            try {
                this.fAnnotation = this.getDB().getShort(this.record + 58L);
            }
            catch (CoreException coreException) {
                this.fAnnotation = 0;
            }
        }
        return this.fAnnotation;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public IScope getFunctionScope() {
        return null;
    }

    @Override
    public ICPPParameter[] getParameters() {
        try {
            ILinkage linkage = this.getLinkage();
            Database db = this.getDB();
            ICPPFunctionType ft = this.getType();
            IType[] ptypes = ft == null ? IType.EMPTY_TYPE_ARRAY : ft.getParameterTypes();
            int n = db.getInt(this.record + 40L);
            ICPPParameter[] result = new ICPPParameter[n];
            long next = db.getRecPtr(this.record + 44L);
            int i = 0;
            while (i < n && next != 0L) {
                IType type = i < ptypes.length ? ptypes[i] : null;
                PDOMCPPParameterSpecialization par = new PDOMCPPParameterSpecialization((PDOMLinkage)linkage, next, type);
                next = par.getNextPtr();
                result[i] = par;
                ++i;
            }
            return result;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPParameter.EMPTY_CPPPARAMETER_ARRAY;
        }
    }

    @Override
    public ICPPFunctionType getType() {
        if (this.fType == null) {
            try {
                this.fType = (ICPPFunctionType)((PDOMLinkage)this.getLinkage()).loadType(this.record + 48L);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fType = new ProblemFunctionType(10005);
            }
        }
        return this.fType;
    }

    @Override
    public boolean isAuto() {
        return false;
    }

    @Override
    public boolean isConstexpr() {
        return PDOMCPPFunctionSpecialization.getBit(this.readAnnotation(), 10);
    }

    @Override
    public boolean isExtern() {
        return PDOMCPPFunctionSpecialization.getBit(this.readAnnotation(), 1);
    }

    @Override
    public boolean isExternC() {
        return PDOMCPPFunctionSpecialization.getBit(this.readAnnotation(), 6);
    }

    @Override
    public boolean isRegister() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return PDOMCPPFunctionSpecialization.getBit(this.readAnnotation(), 4);
    }

    @Override
    public boolean takesVarArgs() {
        return PDOMCPPFunctionSpecialization.getBit(this.readAnnotation(), 5);
    }

    @Override
    public boolean isNoReturn() {
        return PDOMCPPFunctionSpecialization.getBit(this.readAnnotation(), 6);
    }

    @Override
    public int getRequiredArgumentCount() {
        if (this.fRequiredArgCount == -1) {
            try {
                this.fRequiredArgCount = this.getDB().getShort(this.record + 60L);
            }
            catch (CoreException coreException) {
                this.fRequiredArgCount = 0;
            }
        }
        return this.fRequiredArgCount;
    }

    @Override
    public boolean hasParameterPack() {
        return PDOMCPPFunctionSpecialization.getBit(this.readAnnotation(), 8);
    }

    @Override
    public boolean isDeleted() {
        return PDOMCPPFunctionSpecialization.getBit(this.readAnnotation(), 9);
    }

    public boolean isConst() {
        return false;
    }

    public boolean isVolatile() {
        return false;
    }

    @Override
    public int pdomCompareTo(PDOMBinding other) {
        int cmp = super.pdomCompareTo(other);
        return cmp == 0 ? PDOMCPPFunction.compareSignatures(this, other) : cmp;
    }

    @Override
    public IType[] getExceptionSpecification() {
        try {
            long rec = this.getPDOM().getDB().getRecPtr(this.record + 54L);
            return PDOMCPPTypeList.getTypes(this, rec);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public ICPPEvaluation getReturnExpression() {
        if (!this.isConstexpr()) {
            return null;
        }
        try {
            return (ICPPEvaluation)((PDOMLinkage)this.getLinkage()).loadEvaluation(this.record + 62L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }
}

