/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPBase
implements ICPPBase,
ICPPInternalBase {
    static final int CLASS_DEFINITION = 0;
    private static final int BASECLASS_TYPE = 4;
    private static final int NEXTBASE = 10;
    private static final int FLAGS = 14;
    protected static final int RECORD_SIZE = 15;
    private final PDOMLinkage linkage;
    private final long record;
    private IType fCachedBaseClass;

    public PDOMCPPBase(PDOMLinkage linkage, long record) {
        this.linkage = linkage;
        this.record = record;
    }

    public PDOMCPPBase(PDOMLinkage linkage, ICPPBase base, PDOMName classDefName) throws CoreException {
        Database db = linkage.getDB();
        this.linkage = linkage;
        this.record = db.malloc(15);
        db.putRecPtr(this.record + 0L, classDefName.getRecord());
        linkage.storeType(this.record + 4L, base.getBaseClassType());
        byte flags = (byte)(base.getVisibility() | (base.isVirtual() ? 4 : 0));
        db.putByte(this.record + 14L, flags);
    }

    private Database getDB() {
        return this.linkage.getDB();
    }

    public long getRecord() {
        return this.record;
    }

    public void setNextBase(PDOMCPPBase nextBase) throws CoreException {
        long rec = nextBase != null ? nextBase.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 10L, rec);
    }

    public PDOMCPPBase getNextBase() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 10L);
        return rec != 0L ? new PDOMCPPBase(this.linkage, rec) : null;
    }

    private int getFlags() throws CoreException {
        return this.getDB().getByte(this.record + 14L);
    }

    @Override
    public PDOMName getBaseClassSpecifierName() {
        return null;
    }

    @Override
    public PDOMName getClassDefinitionName() {
        try {
            long rec = this.getDB().getRecPtr(this.record + 0L);
            if (rec != 0L) {
                return new PDOMName(this.linkage, rec);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    @Override
    public IType getBaseClassType() {
        if (this.fCachedBaseClass == null) {
            try {
                this.fCachedBaseClass = this.linkage.loadType(this.record + 4L);
            }
            catch (CoreException coreException) {
                this.fCachedBaseClass = new ProblemType(10005);
            }
        }
        return this.fCachedBaseClass;
    }

    @Override
    public IBinding getBaseClass() {
        IType type = this.getBaseClassType();
        if ((type = SemanticUtil.getNestedType(type, 1)) instanceof IBinding) {
            return (IBinding)((Object)type);
        }
        return null;
    }

    @Override
    public int getVisibility() {
        try {
            return this.getFlags() & 3;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    @Override
    public boolean isVirtual() {
        try {
            return (this.getFlags() & 4) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public void delete() throws CoreException {
        this.getDB().free(this.record);
    }

    @Override
    public void setBaseClass(IBinding binding) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBaseClass(IType binding) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICPPBase clone() {
        return new PDOMCPPBaseClone(this);
    }

    private static class PDOMCPPBaseClone
    implements ICPPBase,
    ICPPInternalBase {
        private final ICPPBase base;
        private IType baseClass = null;

        public PDOMCPPBaseClone(ICPPBase base) {
            this.base = base;
        }

        @Override
        public IBinding getBaseClass() {
            IType type = this.getBaseClassType();
            if ((type = SemanticUtil.getNestedType(type, 1)) instanceof IBinding) {
                return (IBinding)((Object)type);
            }
            return null;
        }

        @Override
        public IType getBaseClassType() {
            if (this.baseClass == null) {
                this.baseClass = this.base.getBaseClassType();
            }
            return this.baseClass;
        }

        @Override
        @Deprecated
        public IName getBaseClassSpecifierName() {
            return this.base.getBaseClassSpecifierName();
        }

        @Override
        public IName getClassDefinitionName() {
            return this.base.getClassDefinitionName();
        }

        @Override
        public int getVisibility() {
            return this.base.getVisibility();
        }

        @Override
        public boolean isVirtual() {
            return this.base.isVirtual();
        }

        @Override
        public void setBaseClass(IBinding binding) {
            if (binding instanceof IType) {
                this.baseClass = (IType)((Object)binding);
            }
        }

        @Override
        public void setBaseClass(IType binding) {
            this.baseClass = binding;
        }

        @Override
        public ICPPBase clone() {
            return new PDOMCPPBaseClone(this);
        }
    }
}

