/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.IToken;

public class PDOMASTAdapter {
    public static IBinding getAdapterForAnonymousASTBinding(IBinding binding) {
        char[] name;
        if (binding != null && !(binding instanceof IIndexBinding) && (name = binding.getNameCharArray()).length == 0) {
            if (binding instanceof IEnumeration) {
                name = ASTTypeUtil.createNameForAnonymous(binding);
                if (name != null) {
                    if (binding instanceof ICPPBinding) {
                        return new AnonymousCPPEnumeration(name, (IEnumeration)binding);
                    }
                    return new AnonymousEnumeration(name, (IEnumeration)binding);
                }
            } else if (binding instanceof ICPPClassType) {
                name = ASTTypeUtil.createNameForAnonymous(binding);
                if (name != null) {
                    return new AnonymousClassType(name, (ICPPClassType)binding);
                }
            } else if (binding instanceof ICompositeType) {
                name = ASTTypeUtil.createNameForAnonymous(binding);
                if (name != null) {
                    return new AnonymousCompositeType(name, (ICompositeType)binding);
                }
            } else {
                if (binding instanceof ICPPTemplateParameter) {
                    return binding;
                }
                if (binding instanceof ICPPConstructor) {
                    return binding;
                }
            }
            return null;
        }
        return binding;
    }

    public static IASTName getAdapterIfAnonymous(IASTName name) {
        if (name.getLookupKey().length == 0 && name.getFileLocation() == null) {
            IASTFileLocation loc;
            IASTNode parent = name.getParent();
            if (parent != null && (loc = parent.getFileLocation()) != null) {
                return new AnonymousASTName(name, loc);
            }
            return null;
        }
        return name;
    }

    private static class AnonymousASTName
    implements IASTName {
        private IASTName fDelegate;
        private IASTFileLocation fLocation;

        public AnonymousASTName(IASTName name, final IASTFileLocation loc) {
            this.fDelegate = name;
            this.fLocation = new IASTFileLocation(){

                @Override
                public int getEndingLineNumber() {
                    return loc.getStartingLineNumber();
                }

                @Override
                public String getFileName() {
                    return loc.getFileName();
                }

                @Override
                public int getStartingLineNumber() {
                    return loc.getStartingLineNumber();
                }

                @Override
                public IASTFileLocation asFileLocation() {
                    return loc.asFileLocation();
                }

                @Override
                public int getNodeLength() {
                    return 0;
                }

                @Override
                public int getNodeOffset() {
                    return loc.getNodeOffset();
                }

                @Override
                public IASTPreprocessorIncludeStatement getContextInclusionStatement() {
                    return loc.getContextInclusionStatement();
                }
            };
        }

        @Override
        public boolean accept(ASTVisitor visitor) {
            return this.fDelegate.accept(visitor);
        }

        @Override
        public boolean contains(IASTNode node) {
            return this.fDelegate.contains(node);
        }

        @Override
        public IBinding getBinding() {
            return this.fDelegate.getBinding();
        }

        @Override
        public IBinding getPreBinding() {
            return this.fDelegate.getPreBinding();
        }

        @Override
        public String getContainingFilename() {
            return this.fLocation.getFileName();
        }

        @Override
        public IASTFileLocation getFileLocation() {
            return this.fLocation;
        }

        @Override
        public ILinkage getLinkage() {
            return this.fDelegate.getLinkage();
        }

        @Override
        public IASTNodeLocation[] getNodeLocations() {
            return this.fDelegate.getNodeLocations();
        }

        @Override
        public IASTNode getParent() {
            return this.fDelegate.getParent();
        }

        @Override
        public IASTNode[] getChildren() {
            return this.fDelegate.getChildren();
        }

        @Override
        public ASTNodeProperty getPropertyInParent() {
            return this.fDelegate.getPropertyInParent();
        }

        @Override
        public String getRawSignature() {
            return this.fDelegate.getRawSignature();
        }

        @Override
        public IASTTranslationUnit getTranslationUnit() {
            return this.fDelegate.getTranslationUnit();
        }

        @Override
        public int getRoleOfName(boolean allowResolution) {
            return this.fDelegate.getRoleOfName(allowResolution);
        }

        @Override
        public boolean isDeclaration() {
            return this.fDelegate.isDeclaration();
        }

        @Override
        public boolean isDefinition() {
            return this.fDelegate.isDefinition();
        }

        @Override
        public boolean isReference() {
            return this.fDelegate.isReference();
        }

        @Override
        public IBinding resolveBinding() {
            return this.fDelegate.resolveBinding();
        }

        @Override
        public IBinding resolvePreBinding() {
            return this.fDelegate.resolvePreBinding();
        }

        @Override
        public IASTCompletionContext getCompletionContext() {
            return this.fDelegate.getCompletionContext();
        }

        @Override
        public void setBinding(IBinding binding) {
            this.fDelegate.setBinding(binding);
        }

        @Override
        public void setParent(IASTNode node) {
            this.fDelegate.setParent(node);
        }

        @Override
        public void setPropertyInParent(ASTNodeProperty property) {
            this.fDelegate.setPropertyInParent(property);
        }

        @Override
        public char[] toCharArray() {
            return this.fDelegate.toCharArray();
        }

        @Override
        public char[] getSimpleID() {
            return this.fDelegate.getSimpleID();
        }

        @Override
        public char[] getLookupKey() {
            return this.fDelegate.getLookupKey();
        }

        @Override
        public IASTImageLocation getImageLocation() {
            return null;
        }

        @Override
        public boolean isPartOfTranslationUnitFile() {
            return this.fLocation.getFileName().equals(this.fDelegate.getTranslationUnit().getFilePath());
        }

        @Override
        public String toString() {
            return this.fDelegate.toString();
        }

        @Override
        public IASTName getLastName() {
            return this;
        }

        @Override
        public IToken getSyntax() throws ExpansionOverlapsBoundaryException, UnsupportedOperationException {
            return this.fDelegate.getSyntax();
        }

        @Override
        public IToken getLeadingSyntax() throws ExpansionOverlapsBoundaryException, UnsupportedOperationException {
            return this.fDelegate.getLeadingSyntax();
        }

        @Override
        public IToken getTrailingSyntax() throws ExpansionOverlapsBoundaryException, UnsupportedOperationException {
            return this.fDelegate.getTrailingSyntax();
        }

        @Override
        public boolean isFrozen() {
            return this.fDelegate.isFrozen();
        }

        @Override
        public boolean isActive() {
            return this.fDelegate.isFrozen();
        }

        @Override
        public IASTName copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IASTName copy(IASTNode.CopyStyle style) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isQualified() {
            return this.fDelegate.isQualified();
        }

        @Override
        public IASTNode getOriginalNode() {
            return this;
        }
    }

    private static class AnonymousCPPBinding
    implements ICPPBinding {
        protected ICPPBinding fDelegate;
        private char[] fName;

        public AnonymousCPPBinding(char[] name, ICPPBinding delegate) {
            this.fName = name;
            this.fDelegate = delegate;
        }

        public Object clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return new String(this.fName);
        }

        @Override
        public char[] getNameCharArray() {
            return this.fName;
        }

        @Override
        public String[] getQualifiedName() throws DOMException {
            String[] qn = this.fDelegate.getQualifiedName();
            if (qn.length < 1) {
                qn = new String[1];
            }
            qn[qn.length - 1] = new String(this.fName);
            return qn;
        }

        @Override
        public char[][] getQualifiedNameCharArray() throws DOMException {
            Object qn = this.fDelegate.getQualifiedNameCharArray();
            if (((char[][])qn).length < 1) {
                qn = new char[1][];
            }
            qn[((char[][])qn).length - 1] = this.fName;
            return qn;
        }

        public Object getAdapter(Class adapter) {
            return this.fDelegate.getAdapter(adapter);
        }

        @Override
        public ILinkage getLinkage() {
            return this.fDelegate.getLinkage();
        }

        @Override
        public IScope getScope() throws DOMException {
            return this.fDelegate.getScope();
        }

        @Override
        public boolean isGloballyQualified() throws DOMException {
            return this.fDelegate.isGloballyQualified();
        }

        @Override
        public IBinding getOwner() {
            return this.fDelegate.getOwner();
        }
    }

    private static class AnonymousCPPEnumeration
    extends AnonymousCPPBinding
    implements ICPPEnumeration {
        public AnonymousCPPEnumeration(char[] name, IEnumeration delegate) {
            super(name, (ICPPBinding)((Object)delegate));
        }

        @Override
        public IEnumerator[] getEnumerators() {
            return ((IEnumeration)((Object)this.fDelegate)).getEnumerators();
        }

        @Override
        public boolean isSameType(IType type) {
            return ((IEnumeration)((Object)this.fDelegate)).isSameType(type);
        }

        @Override
        public long getMinValue() {
            return ((IEnumeration)((Object)this.fDelegate)).getMinValue();
        }

        @Override
        public long getMaxValue() {
            return ((IEnumeration)((Object)this.fDelegate)).getMaxValue();
        }

        @Override
        public boolean isScoped() {
            return ((ICPPEnumeration)this.fDelegate).isScoped();
        }

        @Override
        public IType getFixedType() {
            return ((ICPPEnumeration)this.fDelegate).getFixedType();
        }

        @Override
        public ICPPScope asScope() {
            return ((ICPPEnumeration)this.fDelegate).asScope();
        }
    }

    private static class AnonymousClassType
    extends AnonymousCPPBinding
    implements ICPPClassType {
        public AnonymousClassType(char[] name, ICPPClassType delegate) {
            super(name, delegate);
        }

        @Override
        public IField findField(String name) {
            return ((ICPPClassType)this.fDelegate).findField(name);
        }

        @Override
        public ICPPMethod[] getAllDeclaredMethods() {
            return ((ICPPClassType)this.fDelegate).getAllDeclaredMethods();
        }

        @Override
        public ICPPBase[] getBases() {
            return ((ICPPClassType)this.fDelegate).getBases();
        }

        @Override
        public IScope getCompositeScope() {
            return ((ICPPClassType)this.fDelegate).getCompositeScope();
        }

        @Override
        public ICPPConstructor[] getConstructors() {
            return ((ICPPClassType)this.fDelegate).getConstructors();
        }

        @Override
        public ICPPField[] getDeclaredFields() {
            return ((ICPPClassType)this.fDelegate).getDeclaredFields();
        }

        @Override
        public ICPPMethod[] getDeclaredMethods() {
            return ((ICPPClassType)this.fDelegate).getDeclaredMethods();
        }

        @Override
        public IField[] getFields() {
            return ((ICPPClassType)this.fDelegate).getFields();
        }

        @Override
        public IBinding[] getFriends() {
            return ((ICPPClassType)this.fDelegate).getFriends();
        }

        @Override
        public int getKey() {
            return ((ICPPClassType)this.fDelegate).getKey();
        }

        @Override
        public ICPPMethod[] getMethods() {
            return ((ICPPClassType)this.fDelegate).getMethods();
        }

        @Override
        public ICPPClassType[] getNestedClasses() {
            return ((ICPPClassType)this.fDelegate).getNestedClasses();
        }

        @Override
        public boolean isSameType(IType type) {
            return ((ICPPClassType)this.fDelegate).isSameType(type);
        }

        @Override
        public boolean isAnonymous() {
            return ((ICPPClassType)this.fDelegate).isAnonymous();
        }

        @Override
        public boolean isFinal() {
            return false;
        }
    }

    private static class AnonymousCompositeType
    implements ICompositeType {
        protected ICompositeType fDelegate;
        private char[] fName;

        public AnonymousCompositeType(char[] name, ICompositeType delegate) {
            this.fName = name;
            this.fDelegate = delegate;
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IField findField(String name) {
            return this.fDelegate.findField(name);
        }

        public Object getAdapter(Class adapter) {
            return this.fDelegate.getAdapter(adapter);
        }

        @Override
        public IScope getCompositeScope() {
            return this.fDelegate.getCompositeScope();
        }

        @Override
        public IField[] getFields() {
            return this.fDelegate.getFields();
        }

        @Override
        public int getKey() {
            return this.fDelegate.getKey();
        }

        @Override
        public ILinkage getLinkage() {
            return this.fDelegate.getLinkage();
        }

        @Override
        public String getName() {
            return new String(this.fName);
        }

        @Override
        public char[] getNameCharArray() {
            return this.fName;
        }

        @Override
        public IScope getScope() throws DOMException {
            return this.fDelegate.getScope();
        }

        @Override
        public boolean isSameType(IType type) {
            return this.fDelegate.isSameType(type);
        }

        @Override
        public IBinding getOwner() {
            return this.fDelegate.getOwner();
        }

        @Override
        public boolean isAnonymous() {
            return this.fDelegate.isAnonymous();
        }
    }

    private static class AnonymousEnumeration
    implements IEnumeration {
        private IEnumeration fDelegate;
        private char[] fName;

        public AnonymousEnumeration(char[] name, IEnumeration delegate) {
            this.fName = name;
            this.fDelegate = delegate;
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException();
        }

        public Object getAdapter(Class adapter) {
            return this.fDelegate.getAdapter(adapter);
        }

        @Override
        public IEnumerator[] getEnumerators() {
            return this.fDelegate.getEnumerators();
        }

        @Override
        public ILinkage getLinkage() {
            return this.fDelegate.getLinkage();
        }

        @Override
        public String getName() {
            return new String(this.fName);
        }

        @Override
        public char[] getNameCharArray() {
            return this.fName;
        }

        @Override
        public IScope getScope() throws DOMException {
            return this.fDelegate.getScope();
        }

        @Override
        public boolean isSameType(IType type) {
            return this.fDelegate.isSameType(type);
        }

        @Override
        public IBinding getOwner() {
            return this.fDelegate.getOwner();
        }

        @Override
        public long getMinValue() {
            return this.fDelegate.getMinValue();
        }

        @Override
        public long getMaxValue() {
            return this.fDelegate.getMaxValue();
        }
    }
}

