/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;

public class SetPathEntriesOperation
extends CModelOperation {
    static final String[] NO_PREREQUISITES = new String[0];
    IPathEntry[] oldResolvedEntries;
    IPathEntry[] newRawEntries;
    ICProject cproject;

    public SetPathEntriesOperation(ICProject project, IPathEntry[] oldResolvedEntries, IPathEntry[] newRawEntries) {
        super(project);
        this.oldResolvedEntries = oldResolvedEntries;
        this.newRawEntries = newRawEntries;
        this.cproject = project;
    }

    @Override
    protected void executeOperation() throws CModelException {
        this.updateProjectReferencesIfNecessary();
        PathEntryManager mgr = PathEntryManager.getDefault();
        this.hasModifiedResource = true;
        mgr.saveRawPathEntries(this.cproject, this.newRawEntries);
        this.done();
    }

    protected void updateProjectReferencesIfNecessary() throws CModelException {
        PathEntryManager mgr = PathEntryManager.getDefault();
        String[] oldRequired = mgr.projectPrerequisites(this.oldResolvedEntries);
        String[] newRequired = mgr.projectPrerequisites(this.newRawEntries);
        try {
            int newSize;
            HashSet newReferences;
            IProjectDescription description;
            IProject projectResource;
            block10: {
                Object projectName;
                projectResource = this.cproject.getProject();
                description = projectResource.getDescription();
                IProject[] projectReferences = description.getReferencedProjects();
                HashSet<String[]> oldReferences = new HashSet<String[]>(projectReferences.length);
                IProject[] iProjectArray = projectReferences;
                int n = projectReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject projectReference = iProjectArray[n2];
                    projectName = projectReference.getName();
                    oldReferences.add((String[])projectName);
                    ++n2;
                }
                newReferences = (HashSet)oldReferences.clone();
                projectName = oldRequired;
                int n3 = oldRequired.length;
                n = 0;
                while (n < n3) {
                    String projectName2 = projectName[n];
                    newReferences.remove(projectName2);
                    ++n;
                }
                projectName = newRequired;
                n3 = newRequired.length;
                n = 0;
                while (n < n3) {
                    String projectName3 = projectName[n];
                    newReferences.add(projectName3);
                    ++n;
                }
                newSize = newReferences.size();
                if (oldReferences.size() == newSize) {
                    Iterator iter = newReferences.iterator();
                    while (iter.hasNext()) {
                        if (oldReferences.contains(iter.next())) {
                            continue;
                        }
                        break block10;
                    }
                    return;
                }
            }
            Object[] requiredProjectNames = new String[newSize];
            int index = 0;
            Iterator iter = newReferences.iterator();
            while (iter.hasNext()) {
                requiredProjectNames[index++] = (String)iter.next();
            }
            Arrays.sort(requiredProjectNames);
            IProject[] requiredProjectArray = new IProject[newSize];
            IWorkspaceRoot wksRoot = projectResource.getWorkspace().getRoot();
            int i = 0;
            while (i < newSize) {
                requiredProjectArray[i] = wksRoot.getProject((String)requiredProjectNames[i]);
                ++i;
            }
            description.setReferencedProjects(requiredProjectArray);
            projectResource.setDescription(description, this.fMonitor);
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }
}

