/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalTypeId
extends CPPEvaluation {
    private final IType fInputType;
    private final ICPPEvaluation[] fArguments;
    private IType fOutputType;

    public EvalTypeId(IType type, ICPPEvaluation ... argument) {
        this.fInputType = type;
        this.fArguments = argument;
    }

    public IType getInputType() {
        return this.fInputType;
    }

    public ICPPEvaluation[] getArguments() {
        return this.fArguments;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public IType getTypeOrFunctionSet(IASTNode point) {
        if (this.fOutputType == null) {
            this.fOutputType = this.computeType();
        }
        return this.fOutputType;
    }

    private IType computeType() {
        if (CPPTemplates.isDependentType(this.fInputType)) {
            return new TypeOfDependentExpression(this);
        }
        return ExpressionTypes.typeFromReturnType(this.fInputType);
    }

    @Override
    public IValue getValue(IASTNode point) {
        if (this.isValueDependent()) {
            return Value.create(this);
        }
        if (this.fArguments == null) {
            return Value.UNKNOWN;
        }
        if (this.isTypeDependent()) {
            return Value.create(this);
        }
        if (this.fOutputType instanceof ICPPClassType) {
            return Value.UNKNOWN;
        }
        if (this.fArguments.length == 1) {
            return this.fArguments[0].getValue(point);
        }
        return Value.UNKNOWN;
    }

    @Override
    public boolean isTypeDependent() {
        if (this.fOutputType == null) {
            this.fOutputType = this.computeType();
        }
        return this.fOutputType instanceof TypeOfDependentExpression;
    }

    @Override
    public boolean isValueDependent() {
        if (this.fArguments == null) {
            return false;
        }
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.isValueDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        return ExpressionTypes.valueCategoryFromReturnType(this.fInputType);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        int firstByte = 13;
        if (includeValue) {
            firstByte |= 0x10;
        }
        buffer.putByte((byte)firstByte);
        buffer.marshalType(this.fInputType);
        if (includeValue) {
            buffer.putInt(this.fArguments.length);
            ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
            int n = this.fArguments.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPEvaluation arg = iCPPEvaluationArray[n2];
                buffer.marshalEvaluation(arg, includeValue);
                ++n2;
            }
        }
    }

    public static ISerializableEvaluation unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        IType type = buffer.unmarshalType();
        ICPPEvaluation[] args = null;
        if ((firstByte & 0x10) != 0) {
            int len = buffer.getInt();
            args = new ICPPEvaluation[len];
            int i = 0;
            while (i < args.length) {
                args[i] = (ICPPEvaluation)buffer.unmarshalEvaluation();
                ++i;
            }
        }
        return new EvalTypeId(type, args);
    }

    @Override
    public ICPPEvaluation instantiate(ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, int maxdepth, IASTNode point) {
        ICPPEvaluation[] args = this.fArguments;
        if (this.fArguments != null) {
            int i = 0;
            while (i < this.fArguments.length) {
                ICPPEvaluation arg = this.fArguments[i].instantiate(tpMap, packOffset, within, maxdepth, point);
                if (arg != this.fArguments[i]) {
                    if (args == this.fArguments) {
                        args = new ICPPEvaluation[this.fArguments.length];
                        System.arraycopy(this.fArguments, 0, args, 0, this.fArguments.length);
                    }
                    args[i] = arg;
                }
                ++i;
            }
        }
        IType type = CPPTemplates.instantiateType(this.fInputType, tpMap, packOffset, within, point);
        if (args == this.fArguments && type == this.fInputType) {
            return this;
        }
        return new EvalTypeId(type, args);
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(CPPFunctionParameterMap parameterMap, int maxdepth, IASTNode point) {
        ICPPEvaluation[] args = this.fArguments;
        if (this.fArguments != null) {
            int i = 0;
            while (i < this.fArguments.length) {
                ICPPEvaluation arg = this.fArguments[i].computeForFunctionCall(parameterMap, maxdepth, point);
                if (arg != this.fArguments[i]) {
                    if (args == this.fArguments) {
                        args = new ICPPEvaluation[this.fArguments.length];
                        System.arraycopy(this.fArguments, 0, args, 0, this.fArguments.length);
                    }
                    args[i] = arg;
                }
                ++i;
            }
        }
        if (args == this.fArguments) {
            return this;
        }
        return new EvalTypeId(this.fInputType, args);
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int r = CPPTemplates.determinePackSize(this.fInputType, tpMap);
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            r = CPPTemplates.combinePackSize(r, arg.determinePackSize(tpMap));
            ++n2;
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.referencesTemplateParameter()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

