/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.InitializerListType;
import org.eclipse.core.runtime.CoreException;

public class EvalInitList
extends CPPEvaluation {
    private final ICPPEvaluation[] fClauses;

    public EvalInitList(ICPPEvaluation[] clauses) {
        this.fClauses = clauses;
    }

    public ICPPEvaluation[] getClauses() {
        return this.fClauses;
    }

    @Override
    public boolean isInitializerList() {
        return true;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fClauses;
        int n = this.fClauses.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation clause = iCPPEvaluationArray[n2];
            if (clause.isTypeDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isValueDependent() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fClauses;
        int n = this.fClauses.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation clause = iCPPEvaluationArray[n2];
            if (clause.isValueDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public IType getTypeOrFunctionSet(IASTNode point) {
        return new InitializerListType(this);
    }

    @Override
    public IValue getValue(IASTNode point) {
        if (this.isValueDependent()) {
            return Value.create(this);
        }
        return Value.UNKNOWN;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putByte((byte)11);
        buffer.putInt(this.fClauses.length);
        ICPPEvaluation[] iCPPEvaluationArray = this.fClauses;
        int n = this.fClauses.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            buffer.marshalEvaluation(arg, includeValue);
            ++n2;
        }
    }

    public static ISerializableEvaluation unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        int len = buffer.getInt();
        ICPPEvaluation[] args = new ICPPEvaluation[len];
        int i = 0;
        while (i < args.length) {
            args[i] = (ICPPEvaluation)buffer.unmarshalEvaluation();
            ++i;
        }
        return new EvalInitList(args);
    }

    @Override
    public ICPPEvaluation instantiate(ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, int maxdepth, IASTNode point) {
        ICPPEvaluation[] clauses = this.fClauses;
        int i = 0;
        while (i < this.fClauses.length) {
            ICPPEvaluation clause = this.fClauses[i].instantiate(tpMap, packOffset, within, maxdepth, point);
            if (clause != this.fClauses[i]) {
                if (clauses == this.fClauses) {
                    clauses = new ICPPEvaluation[this.fClauses.length];
                    System.arraycopy(this.fClauses, 0, clauses, 0, this.fClauses.length);
                }
                clauses[i] = clause;
            }
            ++i;
        }
        if (clauses == this.fClauses) {
            return this;
        }
        return new EvalInitList(clauses);
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(CPPFunctionParameterMap parameterMap, int maxdepth, IASTNode point) {
        ICPPEvaluation[] clauses = this.fClauses;
        int i = 0;
        while (i < this.fClauses.length) {
            ICPPEvaluation clause = this.fClauses[i].computeForFunctionCall(parameterMap, maxdepth, point);
            if (clause != this.fClauses[i]) {
                if (clauses == this.fClauses) {
                    clauses = new ICPPEvaluation[this.fClauses.length];
                    System.arraycopy(this.fClauses, 0, clauses, 0, this.fClauses.length);
                }
                clauses[i] = clause;
            }
            ++i;
        }
        if (clauses == this.fClauses) {
            return this;
        }
        return new EvalInitList(clauses);
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int r = Integer.MAX_VALUE;
        ICPPEvaluation[] iCPPEvaluationArray = this.fClauses;
        int n = this.fClauses.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            r = CPPTemplates.combinePackSize(r, arg.determinePackSize(tpMap));
            ++n2;
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fClauses;
        int n = this.fClauses.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation clause = iCPPEvaluationArray[n2];
            if (clause.referencesTemplateParameter()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

