/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.parser.util.ObjectMap;

public class CPPTemplateParameterMap
implements ICPPTemplateParameterMap {
    public static final CPPTemplateParameterMap EMPTY = new CPPTemplateParameterMap(0);
    private final ObjectMap fMap;

    public CPPTemplateParameterMap(int initialSize) {
        this.fMap = new ObjectMap(initialSize);
    }

    public CPPTemplateParameterMap(CPPTemplateParameterMap other) {
        this.fMap = (ObjectMap)other.fMap.clone();
    }

    public boolean contains(ICPPTemplateParameter templateParameter) {
        return this.fMap.containsKey(templateParameter.getParameterID());
    }

    public void put(ICPPTemplateParameter param, ICPPTemplateArgument value) {
        this.fMap.put(param.getParameterID(), value);
    }

    public void put(int parameterID, ICPPTemplateArgument value) {
        this.fMap.put(parameterID, value);
    }

    public void put(ICPPTemplateParameter param, ICPPTemplateArgument[] packExpansion) {
        this.fMap.put(param.getParameterID(), packExpansion);
    }

    public void put(int parameterID, ICPPTemplateArgument[] packExpansion) {
        this.fMap.put(parameterID, packExpansion);
    }

    @Override
    public ICPPTemplateArgument getArgument(ICPPTemplateParameter param) {
        if (param == null) {
            return null;
        }
        return this.getArgument(param.getParameterID());
    }

    @Override
    public ICPPTemplateArgument getArgument(int paramID) {
        Object object = this.fMap.get(paramID);
        if (object instanceof ICPPTemplateArgument) {
            return (ICPPTemplateArgument)object;
        }
        return null;
    }

    @Override
    public ICPPTemplateArgument[] getPackExpansion(ICPPTemplateParameter tpar) {
        return this.getPackExpansion(tpar.getParameterID());
    }

    @Override
    public ICPPTemplateArgument[] getPackExpansion(int paramID) {
        Object object = this.fMap.get(paramID);
        if (object instanceof ICPPTemplateArgument[]) {
            return (ICPPTemplateArgument[])object;
        }
        return null;
    }

    public ICPPTemplateArgument getArgument(ICPPTemplateParameter tpar, int packOffset) {
        return this.getArgument(tpar.getParameterID(), packOffset);
    }

    public ICPPTemplateArgument getArgument(int paramID, int packOffset) {
        ICPPTemplateArgument[] args;
        Object object = this.fMap.get(paramID);
        if (object instanceof ICPPTemplateArgument) {
            return (ICPPTemplateArgument)object;
        }
        if (object instanceof ICPPTemplateArgument[] && packOffset < (args = (ICPPTemplateArgument[])object).length && packOffset >= 0) {
            return args[packOffset];
        }
        return null;
    }

    public boolean putPackElement(Integer paramID, int packOffset, ICPPTemplateArgument arg, int packSize) {
        ICPPTemplateArgument[] args;
        Object object = this.fMap.get(paramID);
        if (object instanceof ICPPTemplateArgument[]) {
            args = (ICPPTemplateArgument[])object;
            if (packSize != args.length) {
                return false;
            }
        } else if (object == null) {
            args = new ICPPTemplateArgument[packSize];
            this.fMap.put(paramID, args);
        } else {
            return false;
        }
        args[packOffset] = arg;
        return true;
    }

    public void putAll(ICPPTemplateParameterMap map) {
        if (map instanceof CPPTemplateParameterMap) {
            ObjectMap omap = ((CPPTemplateParameterMap)map).fMap;
            int i = 0;
            while (i < omap.size()) {
                this.fMap.put(omap.keyAt(i), omap.getAt(i));
                ++i;
            }
        } else assert (false);
    }

    public boolean addDeducedArgs(CPPTemplateParameterMap deducedMap) {
        Integer[] keys;
        Integer[] integerArray = keys = deducedMap.getAllParameterPositions();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Integer key = integerArray[n2];
            Object explicit = this.fMap.get(key);
            Object deduced = deducedMap.fMap.get(key);
            if (explicit == null) {
                if (deduced instanceof ICPPTemplateArgument[]) {
                    ICPPTemplateArgument[] iCPPTemplateArgumentArray = (ICPPTemplateArgument[])deduced;
                    int n3 = iCPPTemplateArgumentArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n4];
                        if (arg == null) {
                            return false;
                        }
                        ++n4;
                    }
                }
                this.fMap.put(key, deduced);
            } else if (explicit instanceof ICPPTemplateArgument[] && deduced instanceof ICPPTemplateArgument[]) {
                ICPPTemplateArgument[] deducedPack = (ICPPTemplateArgument[])deduced;
                ICPPTemplateArgument[] explicitPack = (ICPPTemplateArgument[])explicit;
                if (deducedPack.length < explicitPack.length) {
                    return false;
                }
                System.arraycopy(explicitPack, 0, deducedPack, 0, explicitPack.length);
                ICPPTemplateArgument[] iCPPTemplateArgumentArray = deducedPack;
                int n5 = deducedPack.length;
                int n6 = 0;
                while (n6 < n5) {
                    ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n6];
                    if (arg == null) {
                        return false;
                    }
                    ++n6;
                }
                this.fMap.put(key, deducedPack);
            } else {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Integer[] getAllParameterPositions() {
        return this.fMap.keyArray(Integer.class);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        int i = 0;
        while (i < this.fMap.size()) {
            Integer key = (Integer)this.fMap.keyAt(i);
            if (key != null) {
                Object obj;
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                if ((obj = this.fMap.getAt(i)) instanceof ICPPTemplateArgument) {
                    this.appendArg(sb, key, (ICPPTemplateArgument)obj);
                } else if (obj instanceof ICPPTemplateArgument[]) {
                    ICPPTemplateArgument[] iCPPTemplateArgumentArray = (ICPPTemplateArgument[])obj;
                    int n = iCPPTemplateArgumentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
                        this.appendArg(sb, key, arg);
                        ++n2;
                    }
                }
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    private void appendArg(StringBuilder sb, Integer key, ICPPTemplateArgument value) {
        sb.append('#');
        sb.append(key >> 16);
        sb.append(',');
        sb.append((int)(key & 0xFFFF));
        sb.append(": ");
        sb.append(ASTTypeUtil.getArgumentString(value, true));
    }
}

