/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateScope;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;

public class CPPASTTemplateSpecialization
extends ASTNode
implements ICPPASTTemplateSpecialization,
ICPPASTInternalTemplateDeclaration,
IASTAmbiguityParent {
    private IASTDeclaration declaration;
    private ICPPTemplateScope templateScope;
    private short nestingLevel = (short)-1;
    private byte isAssociatedWithLastName = (byte)-1;

    public CPPASTTemplateSpecialization() {
    }

    public CPPASTTemplateSpecialization(IASTDeclaration declaration) {
        this.setDeclaration(declaration);
    }

    @Override
    public CPPASTTemplateSpecialization copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTTemplateSpecialization copy(IASTNode.CopyStyle style) {
        CPPASTTemplateSpecialization copy = new CPPASTTemplateSpecialization();
        copy.setDeclaration(this.declaration == null ? null : this.declaration.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public IASTDeclaration getDeclaration() {
        return this.declaration;
    }

    @Override
    public void setDeclaration(IASTDeclaration declaration) {
        this.assertNotFrozen();
        this.declaration = declaration;
        if (declaration != null) {
            declaration.setParent(this);
            declaration.setPropertyInParent(ICPPASTTemplateSpecialization.OWNED_DECLARATION);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.declaration != null && !this.declaration.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isExported() {
        return false;
    }

    @Override
    public void setExported(boolean value) {
        this.assertNotFrozen();
    }

    @Override
    public ICPPASTTemplateParameter[] getTemplateParameters() {
        return ICPPASTTemplateParameter.EMPTY_TEMPLATEPARAMETER_ARRAY;
    }

    @Override
    public void addTemplateParameter(ICPPASTTemplateParameter param) {
        this.assertNotFrozen();
    }

    @Override
    @Deprecated
    public void addTemplateParamter(ICPPASTTemplateParameter param) {
        this.addTemplateParameter(param);
    }

    @Override
    public ICPPTemplateScope getScope() {
        if (this.templateScope == null) {
            this.templateScope = new CPPTemplateScope(this);
        }
        return this.templateScope;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.declaration == child) {
            other.setParent(child.getParent());
            other.setPropertyInParent(child.getPropertyInParent());
            this.declaration = (IASTDeclaration)other;
        }
    }

    @Override
    public short getNestingLevel() {
        if (this.nestingLevel == -1) {
            CPPTemplates.associateTemplateDeclarations(this);
        }
        assert (this.nestingLevel != -1);
        return this.nestingLevel;
    }

    @Override
    public boolean isAssociatedWithLastName() {
        if (this.isAssociatedWithLastName == -1) {
            CPPTemplates.associateTemplateDeclarations(this);
        }
        assert (this.isAssociatedWithLastName != -1);
        return this.isAssociatedWithLastName != 0;
    }

    @Override
    public void setAssociatedWithLastName(boolean value) {
        this.isAssociatedWithLastName = value ? (byte)1 : 0;
    }

    @Override
    public void setNestingLevel(short level) {
        assert (level >= 0);
        this.nestingLevel = level;
    }
}

