/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTEqualsInitializer;

public class CASTDesignatedInitializer
extends ASTNode
implements ICASTDesignatedInitializer,
IASTAmbiguityParent {
    private IASTInitializerClause rhs;
    private ICASTDesignator[] designators = null;
    private int designatorsPos = -1;

    public CASTDesignatedInitializer() {
    }

    public CASTDesignatedInitializer(IASTInitializerClause init) {
        this.setOperand(init);
    }

    @Override
    public CASTDesignatedInitializer copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTDesignatedInitializer copy(IASTNode.CopyStyle style) {
        CASTDesignatedInitializer copy = new CASTDesignatedInitializer(this.rhs == null ? null : this.rhs.copy(style));
        ICASTDesignator[] iCASTDesignatorArray = this.getDesignators();
        int n = iCASTDesignatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICASTDesignator designator = iCASTDesignatorArray[n2];
            copy.addDesignator(designator == null ? null : designator.copy(style));
            ++n2;
        }
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public void addDesignator(ICASTDesignator designator) {
        this.assertNotFrozen();
        if (designator != null) {
            designator.setParent(this);
            designator.setPropertyInParent(DESIGNATOR);
            this.designators = ArrayUtil.appendAt(ICASTDesignator.class, this.designators, ++this.designatorsPos, designator);
        }
    }

    @Override
    public ICASTDesignator[] getDesignators() {
        if (this.designators == null) {
            return ICASTDesignatedInitializer.EMPTY_DESIGNATOR_ARRAY;
        }
        this.designators = ArrayUtil.trimAt(ICASTDesignator.class, this.designators, this.designatorsPos);
        return this.designators;
    }

    @Override
    public IASTInitializerClause getOperand() {
        return this.rhs;
    }

    @Override
    public void setOperand(IASTInitializerClause operand) {
        this.assertNotFrozen();
        this.rhs = operand;
        if (this.rhs != null) {
            this.rhs.setParent(this);
            this.rhs.setPropertyInParent(OPERAND);
        }
    }

    @Override
    @Deprecated
    public IASTInitializer getOperandInitializer() {
        if (this.rhs instanceof IASTInitializer) {
            return (IASTInitializer)((Object)this.rhs);
        }
        if (this.rhs instanceof IASTExpression) {
            CASTEqualsInitializer init = new CASTEqualsInitializer(((IASTExpression)this.rhs).copy());
            init.setParent(this);
            init.setPropertyInParent(OPERAND);
            return init;
        }
        return null;
    }

    @Override
    @Deprecated
    public void setOperandInitializer(IASTInitializer rhs) {
        if (rhs instanceof IASTEqualsInitializer) {
            this.setOperand(((IASTEqualsInitializer)rhs).getInitializerClause());
        } else if (rhs instanceof IASTInitializerClause) {
            this.setOperand((IASTInitializerClause)((Object)rhs));
        } else {
            this.setOperand(null);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitInitializers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        ICASTDesignator[] ds = this.getDesignators();
        int i = 0;
        while (i < ds.length) {
            if (!ds[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (this.rhs != null && !this.rhs.accept(action)) {
            return false;
        }
        if (action.shouldVisitInitializers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.rhs) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.rhs = (IASTInitializerClause)other;
        }
    }
}

