/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayDesignator;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CASTArrayDesignator
extends ASTNode
implements ICASTArrayDesignator,
IASTAmbiguityParent {
    private IASTExpression exp;

    public CASTArrayDesignator() {
    }

    public CASTArrayDesignator(IASTExpression exp) {
        this.setSubscriptExpression(exp);
    }

    @Override
    public CASTArrayDesignator copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTArrayDesignator copy(IASTNode.CopyStyle style) {
        CASTArrayDesignator copy = new CASTArrayDesignator(this.exp == null ? null : this.exp.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public IASTExpression getSubscriptExpression() {
        return this.exp;
    }

    @Override
    public void setSubscriptExpression(IASTExpression value) {
        this.assertNotFrozen();
        this.exp = value;
        if (value != null) {
            value.setParent(this);
            value.setPropertyInParent(SUBSCRIPT_EXPRESSION);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDesignators) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.exp != null && !this.exp.accept(action)) {
            return false;
        }
        return !action.shouldVisitDesignators || action.leave(this) != 2;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.exp) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.exp = (IASTExpression)other;
        }
    }
}

