/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.parser.IBuiltinBindingsProvider;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.c.CBasicType;
import org.eclipse.cdt.internal.core.dom.parser.c.CBuiltinParameter;
import org.eclipse.cdt.internal.core.dom.parser.c.CBuiltinVariable;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.c.CImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.c.CImplicitTypedef;
import org.eclipse.cdt.internal.core.dom.parser.c.CPointerType;
import org.eclipse.cdt.internal.core.dom.parser.c.CQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitTypedef;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.core.runtime.PlatformObject;

public class GCCBuiltinSymbolProvider
implements IBuiltinBindingsProvider {
    public static final ASTNodeProperty BUILTIN_GCC_SYMBOL = new ASTNodeProperty("GCCBuiltinSymbolProvider.BUILTIN_GCC_SYMBOL - built-in GCC symbol");
    private static final Map<String, char[]> CHAR_ARRAYS = new HashMap<String, char[]>();
    private IBinding[] fBindings;
    private IScope fScope;
    private final boolean fCpp;
    private final boolean fGnu;
    private Map<String, IType> fTypeMap;
    private List<IBinding> fBindingList;

    public GCCBuiltinSymbolProvider(ParserLanguage lang, boolean supportGnuSymbols) {
        this.fCpp = lang == ParserLanguage.CPP;
        this.fGnu = supportGnuSymbols;
    }

    @Override
    public IBinding[] getBuiltinBindings(IScope scope) {
        this.fScope = scope;
        this.initialize();
        return this.fBindings;
    }

    private void initialize() {
        this.fTypeMap = new HashMap<String, IType>();
        this.fBindingList = new ArrayList<IBinding>();
        this.addStdBuiltins();
        if (this.fGnu) {
            this.addGnuBuiltins();
        }
        this.fBindings = this.fBindingList.toArray(new IBinding[this.fBindingList.size()]);
        this.fTypeMap = null;
        this.fBindingList = null;
    }

    private void addStdBuiltins() {
        this.variable("const char*", "__func__");
        this.variable("const char*", "__FUNCTION__");
        this.variable("const char*", "__PRETTY_FUNCTION__");
    }

    private void addGnuBuiltins() {
        String[] types;
        this.typedef("va_list", "__builtin_va_list");
        this.function("void*", "__builtin_va_start", "va_list", "...");
        this.function("void", "__builtin_va_end", "va_list");
        this.function("void", "__builtin_va_copy", "va_list", "va_list");
        this.function("void*", "__builtin_return_address", "unsigned int");
        this.function("void*", "__builtin_extract_return_address", "void*");
        this.function("void*", "__builtin_frob_return_address", "void*");
        this.function("void*", "__builtin_frame_address", "unsigned int");
        String[] stringArray = types = new String[]{"int", "long", "long long", "unsigned int", "unsigned long", "unsigned long long"};
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            String typePtr = "volatile " + type + "*";
            this.function(type, "__sync_fetch_and_add", typePtr, type, "...");
            this.function(type, "__sync_fetch_and_sub", typePtr, type, "...");
            this.function(type, "__sync_fetch_and_or", typePtr, type, "...");
            this.function(type, "__sync_fetch_and_and", typePtr, type, "...");
            this.function(type, "__sync_fetch_and_xor", typePtr, type, "...");
            this.function(type, "__sync_fetch_and_nand", typePtr, type, "...");
            this.function(type, "__sync_add_and_fetch", typePtr, type, "...");
            this.function(type, "__sync_sub_and_fetch", typePtr, type, "...");
            this.function(type, "__sync_or_and_fetch", typePtr, type, "...");
            this.function(type, "__sync_and_and_fetch", typePtr, type, "...");
            this.function(type, "__sync_xor_and_fetch", typePtr, type, "...");
            this.function(type, "__sync_nand_and_fetch", typePtr, type, "...");
            this.function(type, "__sync_lock_test_and_set", typePtr, type, "...");
            this.function(type, "__sync_lock_release", typePtr, "...");
            ++n2;
        }
        this.function("void", "__sync_synchronize", new String[0]);
        this.function("void", "__builtin_abort", "void");
        this.function("int", "__builtin_abs", "int");
        this.function("double", "__builtin_acos", "double");
        this.function("float", "__builtin_acosf", "float");
        this.function("long double", "__builtin_acosl", "long double");
        this.function("double", "__builtin_asin", "double");
        this.function("float", "__builtin_asinf", "float");
        this.function("long double", "__builtin_asinl", "long double");
        this.function("double", "__builtin_atan", "double");
        this.function("long double", "__builtin_atanl", "long double");
        this.function("float", "__builtin_atanf", "float");
        this.function("double", "__builtin_atan2", "double", "double");
        this.function("float", "__builtin_atan2f", "float", "float");
        this.function("long double", "__builtin_atan2l", "long double", "long double");
        this.function("void*", "__builtin_alloca", "size_t");
        this.cfunction("", "__builtin_choose_expr", "", "", "");
        this.function("double", "__builtin_ceil", "double");
        this.function("float", "__builtin_ceilf", "float");
        this.function("long double", "__builtin_ceill", "long double");
        this.function("double", "__builtin_cimag", "complex double");
        this.function("float", "__builtin_cimagf", "complex float");
        this.function("long double", "__builtin_cimagl", "complex long double");
        this.function("int", "__builtin_clz", "unsigned int");
        this.function("int", "__builtin_clzl", "unsigned long");
        this.function("int", "__builtin_clzll", "unsigned long long");
        this.function("complex double", "__builtin_conj", "complex double");
        this.function("complex float", "__builtin_conjf", "complex float");
        this.function("complex long double", "__builtin_conjl", "complex long double");
        this.function("double", "__builtin_cos", "double");
        this.function("float", "__builtin_cosf", "float");
        this.function("double", "__builtin_cosh", "double");
        this.function("float", "__builtin_coshf", "float");
        this.function("long double", "__builtin_coshl", "long double");
        this.function("long double", "__builtin_cosl", "long double");
        this.function("double", "__builtin_creal", "complex double");
        this.function("float", "__builtin_crealf", "complex float");
        this.function("long double", "__builtin_creall", "complex long double");
        this.function("int", "__builtin_ctz", "unsigned int");
        this.function("int", "__builtin_ctzl", "unsigned long");
        this.function("int", "__builtin_ctzll", "unsigned long long");
        this.function("void", "__builtin__Exit", "int");
        this.function("void", "__builtin__exit", "int");
        this.function("void", "__builtin_exit", "int");
        this.function("double", "__builtin_exp", "double");
        this.function("float", "__builtin_expf", "float");
        this.function("long double", "__builtin_expl", "long double");
        this.function("long", "__builtin_expect", "long", "long");
        this.function("double", "__builtin_fabs", "double");
        this.function("float", "__builtin_fabsf", "float");
        this.function("long double", "__builtin_fabsl", "long double");
        this.function("int", "__builtin_ffs", "unsigned int");
        this.function("int", "__builtin_ffsl", "unsigned long");
        this.function("int", "__builtin_ffsll", "unsigned long long");
        this.function("double", "__builtin_floor", "double");
        this.function("float", "__builtin_floorf", "float");
        this.function("long double", "__builtin_floorl", "long double");
        this.function("double", "__builtin_fmod", "double", "double");
        this.function("float", "__builtin_fmodf", "float", "float");
        this.function("long double", "__builtin_fmodl", "long double", "long double");
        this.function("int", "__builtin_fprintf", "FILE*", "const char*");
        this.function("int", "__builtin_fputs", "const char*", "FILE*");
        this.function("double", "__builtin_frexp", "double", "int*");
        this.function("float", "__builtin_frexpf", "float", "int*");
        this.function("long double", "__builtin_frexpl", "long double", "int*");
        this.function("double", "__builtin_huge_val", "void");
        this.function("float", "__builtin_huge_valf", "void");
        this.function("long double", "__builtin_huge_vall", "void");
        this.function("long long", "__builtin_imaxabs", "long long");
        this.function("double", "__builtin_inf", "void");
        this.function("float", "__builtin_inff", "void");
        this.function("long double", "__builtin_infl", "void");
        this.function("int", "__builtin_isgreater", "float", "float");
        this.function("int", "__builtin_isgreaterequal", "float", "float");
        this.function("int", "__builtin_isless", "float", "float");
        this.function("int", "__builtin_islessequal", "float", "float");
        this.function("int", "__builtin_islessgreater", "float", "float");
        this.function("int", "__builtin_isunordered", "float", "float");
        this.function("long", "__builtin_labs", "long");
        this.function("double", "__builtin_ldexp", "double", "int");
        this.function("float", "__builtin_ldexpf", "float", "int");
        this.function("long double", "__builtin_ldexpl", "long double", "int");
        this.function("long long", "__builtin_llabs", "long long");
        this.function("double", "__builtin_log", "double");
        this.function("float", "__builtin_logf", "float");
        this.function("long double", "__builtin_logl", "long double");
        this.function("double", "__builtin_log10", "double");
        this.function("float", "__builtin_log10f", "float");
        this.function("long double", "__builtin_log10l", "long double");
        this.function("float", "__builtin_modff", "float", "float*");
        this.function("long double", "__builtin_modfl", "long double", "long double*");
        this.function("void*", "__builtin_memchr", "const void*", "int", "size_t");
        this.function("int", "__builtin_memcmp", "const void*", "const void*", "size_t");
        this.function("void*", "__builtin_memcpy", "void*", "const void*", "size_t");
        this.function("void*", "__builtin_memmove", "void*", "const void*", "size_t");
        this.function("void*", "__builtin_memset", "void*", "int", "size_t");
        this.function("double", "__builtin_nan", "const char*");
        this.function("float", "__builtin_nanf", "const char*");
        this.function("long double", "__builtin_nanl", "const char*");
        this.function("double", "__builtin_nans", "const char*");
        this.function("float", "__builtin_nansf", "const char*");
        this.function("long double", "__builtin_nansl", "const char*");
        this.function("int", "__builtin_parity", "unsigned int");
        this.function("int", "__builtin_parityl", "unsigned long");
        this.function("int", "__builtin_parityll", "unsigned long long");
        this.function("int", "__builtin_popcount", "unsigned int");
        this.function("int", "__builtin_popcountl", "unsigned long");
        this.function("int", "__builtin_popcountll", "unsigned long long");
        this.function("float", "__builtin_powf", "float");
        this.function("long", "__builtin_pow", "long", "long");
        this.function("long double", "__builtin_powl", "long double", "long double");
        this.function("double", "__builtin_powi", "double", "int");
        this.function("float", "__builtin_powif", "float", "int");
        this.function("long double", "__builtin_powil", "long double", "int");
        this.function("void", "__builtin_prefetch", "const void*", "...");
        this.function("int", "__builtin_printf", "const char*", "...");
        this.function("int", "__builtin_putchar", "int");
        this.function("int", "__builtin_puts", "const char*");
        this.function("int", "__builtin_scanf", "const char*", "...");
        this.function("double", "__builtin_sin", "double");
        this.function("float", "__builtin_sinf", "float");
        this.function("double", "__builtin_sinh", "double");
        this.function("float", "__builtin_sinhf", "float");
        this.function("long double", "__builtin_sinhl", "long double");
        this.function("long double", "__builtin_sinl", "long double");
        this.function("int", "__builtin_snprintf", "char*", "size_t", "const char*", "...");
        this.function("int", "__builtin_sprintf", "char*", "const char*", "...");
        this.function("double", "__builtin_sqrt", "double");
        this.function("float", "__builtin_sqrtf", "float");
        this.function("long double", "__builtin_sqrtl", "long double");
        this.function("int", "__builtin_sscanf", "const char*", "const char*", "...");
        this.function("char*", "__builtin_strcat", "char*", "const char*");
        this.function("char*", "__builtin_strchr", "const char*", "int");
        this.function("int", "__builtin_strcmp", "const char*", "const char*");
        this.function("char*", "__builtin_strcpy", "char*", "const char*");
        this.function("size_t", "__builtin_strcspn", "const char*", "const char*");
        this.function("size_t", "__builtin_strlen", "const char*");
        this.function("char*", "__builtin_strncat", "char*", "const char*", "size_t");
        this.function("int", "__builtin_strncmp", "const char*", "const char*", "size_t");
        this.function("char*", "__builtin_strncpy", "char*", "const char*", "size_t");
        this.function("char*", "__builtin_strpbrk", "const char*", "const char*");
        this.function("char*", "__builtin_strrchr", "const char*", "int");
        this.function("size_t", "__builtin_strspn", "const char*", "const char*");
        this.function("char*", "__builtin_strstr", "const char*", "const char*");
        this.function("double", "__builtin_tan", "double");
        this.function("float", "__builtin_tanf", "float");
        this.function("double", "__builtin_tanh", "double");
        this.function("float", "__builtin_tanhf", "float");
        this.function("long double", "__builtin_tanhl", "long double");
        this.function("long double", "__builtin_tanl", "long double");
        this.function("int", "__builtin_types_compatible_p", "", "");
        this.function("int", "__builtin_vprintf", "const char*", "va_list");
        this.function("int", "__builtin_vscanf", "const char*", "va_list");
        this.function("int", "__builtin_vsnprintf", "char*", "size_t", "const char*", "va_list");
        this.function("int", "__builtin_vsprintf", "char*", "const char*", "va_list");
        this.function("int", "__builtin_vsscanf", "const char*", "const char*", "va_list");
    }

    private void variable(String type, String name) {
        PlatformObject b = this.fCpp ? new CPPBuiltinVariable(this.toType(type), this.toCharArray(name), this.fScope) : new CBuiltinVariable(this.toType(type), this.toCharArray(name), this.fScope);
        this.fBindingList.add((IBinding)b);
    }

    private void typedef(String type, String name) {
        PlatformObject b = this.fCpp ? new CPPImplicitTypedef(this.toType(type), this.toCharArray(name), this.fScope) : new CImplicitTypedef(this.toType(type), this.toCharArray(name), this.fScope);
        this.fBindingList.add((IBinding)b);
    }

    private void cfunction(String returnType, String name, String ... parameterTypes) {
        if (!this.fCpp) {
            this.function(returnType, name, parameterTypes);
        }
    }

    private void function(String returnType, String name, String ... parameterTypes) {
        boolean varargs;
        int len = parameterTypes.length;
        boolean bl = varargs = len > 0 && parameterTypes[len - 1].equals("...");
        if (varargs) {
            --len;
        }
        IType[] pTypes = new IType[len];
        IParameter[] theParms = this.fCpp ? new ICPPParameter[len] : new IParameter[len];
        int i = 0;
        while (i < len) {
            IType pType;
            pTypes[i] = pType = this.toType(parameterTypes[i]);
            theParms[i] = this.fCpp ? new CPPBuiltinParameter(pType) : new CBuiltinParameter(pType);
            ++i;
        }
        IType rt = this.toType(returnType);
        ISerializableType ft = this.fCpp ? new CPPFunctionType(rt, pTypes) : new CFunctionType(rt, pTypes);
        PlatformObject b = this.fCpp ? new CPPImplicitFunction(this.toCharArray(name), this.fScope, (ICPPFunctionType)((Object)ft), (ICPPParameter[])theParms, varargs) : new CImplicitFunction(this.toCharArray(name), this.fScope, (IFunctionType)((Object)ft), theParms, varargs);
        this.fBindingList.add((IBinding)b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] toCharArray(String name) {
        Map<String, char[]> map = CHAR_ARRAYS;
        synchronized (map) {
            char[] result = CHAR_ARRAYS.get(name);
            if (result == null) {
                result = name.toCharArray();
                CHAR_ARRAYS.put(name, result);
            }
            return result;
        }
    }

    private IType toType(String type) {
        IType t = this.fTypeMap.get(type);
        if (t == null) {
            t = this.createType(type);
            this.fTypeMap.put(type, t);
        }
        return t;
    }

    private IType createType(String type) {
        IType t;
        String tstr = type;
        if (this.fCpp && tstr.endsWith("&")) {
            String nested = tstr.substring(0, tstr.length() - 1).trim();
            return new CPPReferenceType(this.toType(nested), false);
        }
        if (tstr.equals("FILE*")) {
            return this.toType("void*");
        }
        if (tstr.endsWith("*")) {
            String nested = tstr.substring(0, tstr.length() - 1).trim();
            IType nt = this.toType(nested);
            return this.fCpp ? new CPPPointerType(nt) : new CPointerType(nt, 0);
        }
        boolean isConst = false;
        boolean isVolatile = false;
        if (tstr.startsWith("const ")) {
            isConst = true;
            tstr = tstr.substring(6);
        }
        if (tstr.startsWith("volatile ")) {
            isVolatile = true;
            tstr = tstr.substring(9);
        }
        int q = 0;
        if (tstr.startsWith("signed ")) {
            q |= 4;
            tstr = tstr.substring(7);
        }
        if (tstr.startsWith("unsigned ")) {
            q |= 8;
            tstr = tstr.substring(9);
        }
        if (tstr.startsWith("complex ")) {
            q |= 0x10;
            tstr = tstr.substring(8);
        }
        if (tstr.startsWith("long long")) {
            q |= 0x40;
            tstr = tstr.substring(9).trim();
        }
        if (tstr.startsWith("long")) {
            q |= 1;
            tstr = tstr.substring(4).trim();
        }
        if (tstr.equals("void")) {
            IBasicType.Kind kind = IBasicType.Kind.eVoid;
            t = this.fCpp ? new CPPBasicType(kind, q) : new CBasicType(kind, q);
        } else if (tstr.equals("")) {
            IBasicType.Kind kind = IBasicType.Kind.eUnspecified;
            t = this.fCpp ? new CPPBasicType(kind, q) : new CBasicType(kind, q);
        } else if (tstr.equals("char")) {
            IBasicType.Kind kind = IBasicType.Kind.eChar;
            t = this.fCpp ? new CPPBasicType(kind, q) : new CBasicType(kind, q);
        } else if (tstr.equals("int")) {
            IBasicType.Kind kind = IBasicType.Kind.eInt;
            t = this.fCpp ? new CPPBasicType(kind, q) : new CBasicType(kind, q);
        } else if (tstr.equals("float")) {
            IBasicType.Kind kind = IBasicType.Kind.eFloat;
            t = this.fCpp ? new CPPBasicType(kind, q) : new CBasicType(kind, q);
        } else if (tstr.equals("double")) {
            IBasicType.Kind kind = IBasicType.Kind.eDouble;
            t = this.fCpp ? new CPPBasicType(kind, q) : new CBasicType(kind, q);
        } else if (tstr.equals("va_list")) {
            IType rt = this.toType("char*");
            t = this.fCpp ? new CPPPointerType(new CPPFunctionType(rt, IType.EMPTY_TYPE_ARRAY)) : new CPointerType(new CFunctionType(rt, IType.EMPTY_TYPE_ARRAY), 0);
        } else if (tstr.equals("size_t")) {
            t = this.toType("unsigned long");
        } else {
            throw new IllegalArgumentException(type);
        }
        if (isConst || isVolatile) {
            return this.fCpp ? new CPPQualifierType(t, isConst, isVolatile) : new CQualifierType(t, isConst, isVolatile, false);
        }
        return t;
    }
}

