/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class Cygwin {
    private static IPath findCygpathLocation(String envPath) {
        return PathUtil.findProgramLocation("cygpath", envPath);
    }

    public static boolean isAvailable(String envPath) {
        return Platform.getOS().equals("win32") && Cygwin.findCygpathLocation(envPath) != null;
    }

    public static boolean isAvailable() {
        return Platform.getOS().equals("win32") && Cygwin.findCygpathLocation(null) != null;
    }

    public static String cygwinToWindowsPath(String cygwinPath, String envPath) throws IOException, UnsupportedOperationException {
        if (cygwinPath == null || cygwinPath.trim().length() == 0) {
            return cygwinPath;
        }
        if (!Platform.getOS().equals("win32")) {
            throw new UnsupportedOperationException("Not a Windows system, Cygwin is unavailable.");
        }
        IPath cygpathLocation = Cygwin.findCygpathLocation(envPath);
        if (cygpathLocation == null) {
            throw new UnsupportedOperationException("Cygwin utility cygpath is not in the system search path.");
        }
        String[] args = new String[]{cygpathLocation.toOSString(), "-w", cygwinPath};
        Process cygpathProcess = Runtime.getRuntime().exec(args);
        BufferedReader stdout = new BufferedReader(new InputStreamReader(cygpathProcess.getInputStream()));
        String windowsPath = stdout.readLine();
        if (windowsPath == null) {
            throw new IOException("Unexpected output from Cygwin utility cygpath.");
        }
        return windowsPath.trim();
    }

    public static String cygwinToWindowsPath(String cygwinPath) throws IOException, UnsupportedOperationException {
        return Cygwin.cygwinToWindowsPath(cygwinPath, null);
    }

    public static String windowsToCygwinPath(String windowsPath, String envPath) throws IOException, UnsupportedOperationException {
        if (windowsPath == null || windowsPath.trim().length() == 0) {
            return windowsPath;
        }
        if (!Platform.getOS().equals("win32")) {
            throw new UnsupportedOperationException("Not a Windows system, Cygwin is unavailable.");
        }
        IPath cygpathLocation = Cygwin.findCygpathLocation(envPath);
        if (cygpathLocation == null) {
            throw new UnsupportedOperationException("Cygwin utility cygpath is not in the system search path.");
        }
        String[] args = new String[]{cygpathLocation.toOSString(), "-u", windowsPath};
        Process cygpath = Runtime.getRuntime().exec(args);
        BufferedReader stdout = new BufferedReader(new InputStreamReader(cygpath.getInputStream()));
        String cygwinPath = stdout.readLine();
        if (cygwinPath == null) {
            throw new IOException("Unexpected output from Cygwin utility cygpath.");
        }
        return cygwinPath.trim();
    }

    public static String windowsToCygwinPath(String windowsPath) throws IOException, UnsupportedOperationException {
        return Cygwin.windowsToCygwinPath(windowsPath, null);
    }
}

