/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.errorparsers;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.internal.core.Cygwin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class RegexErrorPattern
implements Cloneable {
    public static final int SEVERITY_SKIP = -1;
    private static final String EMPTY_STR = "";
    private Pattern pattern;
    private String fileExpression;
    private String lineExpression;
    private String descriptionExpression;
    private String varNameExpression;
    private int severity;
    private boolean eatProcessedLine;
    private static boolean isCygwin = true;

    public RegexErrorPattern(String pattern, String fileExpression, String lineExpression, String descriptionExpression, String varNameExpression, int severity, boolean eat) {
        this.pattern = Pattern.compile(pattern != null ? pattern : EMPTY_STR);
        this.fileExpression = fileExpression != null ? fileExpression : EMPTY_STR;
        this.lineExpression = lineExpression != null ? lineExpression : EMPTY_STR;
        this.descriptionExpression = descriptionExpression != null ? descriptionExpression : EMPTY_STR;
        this.varNameExpression = varNameExpression != null ? varNameExpression : EMPTY_STR;
        this.severity = severity;
        this.eatProcessedLine = eat;
    }

    public String getPattern() {
        return this.pattern.toString();
    }

    public String getFileExpression() {
        return this.fileExpression;
    }

    public String getLineExpression() {
        return this.lineExpression;
    }

    public String getDescriptionExpression() {
        return this.descriptionExpression;
    }

    public String getVarNameExpression() {
        return this.varNameExpression;
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean isEatProcessedLine() {
        return this.eatProcessedLine;
    }

    public void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    public void setFileExpression(String fileExpression) {
        this.fileExpression = fileExpression;
    }

    public void setLineExpression(String lineExpression) {
        this.lineExpression = lineExpression;
    }

    public void setDescriptionExpression(String descriptionExpression) {
        this.descriptionExpression = descriptionExpression;
    }

    public void setVarNameExpression(String varNameExpression) {
        this.varNameExpression = varNameExpression;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public void setEatProcessedLine(boolean eatProcessedLine) {
        this.eatProcessedLine = eatProcessedLine;
    }

    private Matcher getMatcher(CharSequence input) {
        return this.pattern.matcher(input);
    }

    private String parseStr(Matcher matcher, String str) {
        if (str != null) {
            return matcher.replaceAll(str);
        }
        return null;
    }

    protected String getFileName(Matcher matcher) {
        return this.parseStr(matcher, this.fileExpression);
    }

    protected int getLineNum(Matcher matcher) {
        if (this.lineExpression != null) {
            try {
                return Integer.valueOf(matcher.replaceAll(this.lineExpression));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    protected String getDesc(Matcher matcher) {
        return this.parseStr(matcher, this.descriptionExpression);
    }

    protected String getVarName(Matcher matcher) {
        return this.parseStr(matcher, this.varNameExpression);
    }

    protected int getSeverity(Matcher matcher) {
        return this.severity;
    }

    public boolean processLine(String line, ErrorParserManager eoParser) {
        Matcher matcher = this.getMatcher(line);
        if (!matcher.find() || matcher.group(0).length() != line.length()) {
            return false;
        }
        this.recordError(matcher, eoParser);
        return this.eatProcessedLine;
    }

    protected boolean recordError(Matcher matcher, ErrorParserManager eoParser) {
        int severity = this.getSeverity(matcher);
        if (severity == -1) {
            return true;
        }
        String fileName = this.getFileName(matcher);
        int lineNum = this.getLineNum(matcher);
        String desc = this.getDesc(matcher);
        String varName = this.getVarName(matcher);
        IPath externalPath = null;
        IFile file = null;
        if (fileName != null && (file = eoParser.findFileName(fileName)) == null) {
            file = eoParser.getProject();
            externalPath = this.getLocation(fileName);
        }
        eoParser.generateExternalMarker((IResource)file, lineNum, desc, severity, varName, externalPath);
        return true;
    }

    private IPath getLocation(String filename) {
        Path path = new Path(filename);
        File file = path.toFile();
        if (!file.exists() && isCygwin && path.isAbsolute()) {
            try {
                String cygfilename = Cygwin.cygwinToWindowsPath(filename);
                Path convertedPath = new Path(cygfilename);
                file = convertedPath.toFile();
                if (file.exists()) {
                    path = convertedPath;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                isCygwin = false;
            }
            catch (IOException iOException) {}
        }
        return path;
    }

    public boolean equals(Object o) {
        if (o instanceof RegexErrorPattern) {
            RegexErrorPattern that = (RegexErrorPattern)o;
            return this.pattern.toString().equals(that.pattern.toString()) && this.fileExpression.equals(that.fileExpression) && this.lineExpression.equals(that.lineExpression) && this.descriptionExpression.equals(that.descriptionExpression) && this.varNameExpression.equals(that.varNameExpression) && this.severity == that.severity && this.eatProcessedLine == that.eatProcessedLine;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return new RegexErrorPattern(this.pattern.toString(), this.fileExpression, this.lineExpression, this.descriptionExpression, this.varNameExpression, this.severity, this.eatProcessedLine);
    }
}

