/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.resources.ScannerProvider;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeScannerInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.w3c.dom.Element;

@Deprecated
public class MakeScannerProvider
extends ScannerProvider {
    public static final String INTERFACE_IDENTITY = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".MakeScannerProvider";
    private static final QualifiedName scannerInfoProperty = new QualifiedName(MakeCorePlugin.getUniqueIdentifier(), "makeBuildInfo");
    static final String CDESCRIPTOR_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".makeScannerInfo";
    public static final String INCLUDE_PATH = "includePath";
    public static final String PATH = "path";
    public static final String DEFINED_SYMBOL = "definedSymbol";
    public static final String SYMBOL = "symbol";
    private static MakeScannerProvider defaultProvider;

    public static MakeScannerProvider getDefault() {
        if (defaultProvider == null) {
            defaultProvider = new MakeScannerProvider();
        }
        return defaultProvider;
    }

    public MakeScannerInfo getMakeScannerInfo(IProject project, boolean cacheInfo) throws CoreException {
        MakeScannerInfo scannerInfo = null;
        scannerInfo = (MakeScannerInfo)project.getSessionProperty(scannerInfoProperty);
        if (scannerInfo != null) {
            return scannerInfo;
        }
        scannerInfo = this.loadScannerInfo(project);
        if (scannerInfo != null && cacheInfo) {
            project.setSessionProperty(scannerInfoProperty, (Object)scannerInfo);
        }
        if (scannerInfo != null) {
            MakeScannerProvider.updateScannerInfo(scannerInfo);
        }
        ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(project);
        descriptor.remove("org.eclipse.cdt.core.ScannerInfoProvider");
        return scannerInfo;
    }

    public IScannerInfo getScannerInformation(IResource resource) {
        try {
            this.getMakeScannerInfo(resource.getProject(), true);
        }
        catch (CoreException coreException) {}
        return super.getScannerInformation(resource);
    }

    private MakeScannerInfo loadScannerInfo(IProject project) throws CoreException {
        ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(project);
        ICStorageElement storage = descriptor.getProjectStorageElement(CDESCRIPTOR_ID);
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> symbols = new ArrayList<String>();
        ICStorageElement[] iCStorageElementArray = storage.getChildren();
        int n = iCStorageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if (child.getName().equals(INCLUDE_PATH)) {
                includes.add(((Element)child).getAttribute(PATH));
            } else if (child.getName().equals(DEFINED_SYMBOL)) {
                symbols.add(((Element)child).getAttribute(SYMBOL));
            }
            ++n2;
        }
        MakeScannerInfo info = new MakeScannerInfo(project);
        info.setIncludePaths(includes.toArray(new String[includes.size()]));
        info.setPreprocessorSymbols(symbols.toArray(new String[symbols.size()]));
        return info;
    }

    static void migrateToCPathEntries(MakeScannerInfo info) throws CoreException {
        Map<String, String> symbols = info.getDefinedSymbols();
        String[] includes = info.getIncludePaths();
        ICProject cProject = CoreModel.getDefault().create(info.getProject());
        IPathEntry[] entries = cProject.getRawPathEntries();
        ArrayList<IPathEntry> cPaths = new ArrayList<IPathEntry>(Arrays.asList(entries));
        Iterator cpIter = cPaths.iterator();
        while (cpIter.hasNext()) {
            int kind = ((IPathEntry)cpIter.next()).getEntryKind();
            if (kind != 16 && kind != 64) continue;
            cpIter.remove();
        }
        int i = 0;
        while (i < includes.length) {
            IIncludeEntry include = CoreModel.newIncludeEntry((IPath)info.getProject().getFullPath(), null, (IPath)new Path(includes[i]), (boolean)true);
            if (!cPaths.contains(include)) {
                cPaths.add((IPathEntry)include);
            }
            ++i;
        }
        for (Map.Entry<String, String> entry : symbols.entrySet()) {
            IMacroEntry sym = CoreModel.newMacroEntry((IPath)info.getProject().getFullPath(), (String)entry.getKey(), (String)entry.getValue());
            if (cPaths.contains(sym)) continue;
            cPaths.add((IPathEntry)sym);
        }
        cProject.setRawPathEntries(cPaths.toArray(new IPathEntry[cPaths.size()]), null);
    }

    public static void removeScannerInfo(IResource resource) {
        try {
            resource.getProject().setSessionProperty(scannerInfoProperty, null);
        }
        catch (CoreException coreException) {}
    }

    public static void updateScannerInfo(final MakeScannerInfo scannerInfo) throws CoreException {
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject project = scannerInfo.getProject();
                ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(project);
                ICStorageElement rootElement = descriptor.getProjectStorageElement(CDESCRIPTOR_ID);
                rootElement.clear();
                descriptor.saveProjectData();
                MakeScannerProvider.migrateToCPathEntries(scannerInfo);
            }
        }, null);
    }
}

