/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui.notifications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationAction;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationCategory;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationEvent;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationHandler;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationSinkDescriptor;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationsExtensionReader;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class NotificationModel {
    private boolean dirty;
    private Map<String, NotificationHandler> handlerByEventId;

    public NotificationModel(IMemento memento) {
        this.initialize(memento);
    }

    void initialize(IMemento memento) {
        this.handlerByEventId = new HashMap<String, NotificationHandler>();
        for (NotificationCategory category : this.getCategories()) {
            for (NotificationEvent event : category.getEvents()) {
                this.getOrCreateNotificationHandler(event);
            }
        }
        if (memento != null) {
            this.load(memento);
        }
    }

    public Collection<NotificationCategory> getCategories() {
        return NotificationsExtensionReader.getCategories();
    }

    public NotificationHandler getNotificationHandler(String eventId) {
        return this.handlerByEventId.get(eventId);
    }

    public NotificationHandler getOrCreateNotificationHandler(NotificationEvent event) {
        NotificationHandler handler = this.getNotificationHandler(event.getId());
        if (handler == null) {
            handler = new NotificationHandler(event, this.getActions(event));
            this.handlerByEventId.put(event.getId(), handler);
        }
        return handler;
    }

    private List<NotificationAction> getActions(NotificationEvent event) {
        List<NotificationSinkDescriptor> descriptors = NotificationsExtensionReader.getSinks();
        ArrayList<NotificationAction> actions = new ArrayList<NotificationAction>(descriptors.size());
        for (NotificationSinkDescriptor descriptor : descriptors) {
            NotificationAction action = new NotificationAction(descriptor);
            if (event.defaultHandledBySink(descriptor.getId())) {
                action.setSelected(true);
            }
            actions.add(action);
        }
        return actions;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSelected(NotificationEvent event) {
        NotificationHandler handler = this.getOrCreateNotificationHandler(event);
        for (NotificationAction action : handler.getActions()) {
            if (!action.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void save(IMemento memento) {
        for (Map.Entry<String, NotificationHandler> entry : this.handlerByEventId.entrySet()) {
            IMemento event = memento.createChild("event");
            event.putString("id", entry.getKey());
            List<NotificationAction> actions = entry.getValue().getActions();
            for (NotificationAction notificationAction : actions) {
                IMemento action = event.createChild("action");
                action.putBoolean("selected", notificationAction.isSelected());
                action.putString("sink", notificationAction.getSinkDescriptor().getId());
            }
        }
        this.setDirty(false);
    }

    private void load(IMemento memento) {
        Assert.isNotNull((Object)memento);
        IMemento[] iMementoArray = memento.getChildren("event");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento mEvent = iMementoArray[n2];
            for (NotificationCategory category : this.getCategories()) {
                for (NotificationEvent event : category.getEvents()) {
                    if (!event.getId().equals(mEvent.getString("id"))) continue;
                    NotificationHandler handler = this.getOrCreateNotificationHandler(event);
                    List<NotificationAction> actions = handler.getActions();
                    for (NotificationAction notificationAction : actions) {
                        IMemento[] mActions;
                        IMemento[] iMementoArray2 = mActions = mEvent.getChildren("action");
                        int n3 = mActions.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemento mAction = iMementoArray2[n4];
                            if (notificationAction.getSinkDescriptor().getId().equals(mAction.getString("sink"))) {
                                notificationAction.setSelected(mAction.getBoolean("selected"));
                            }
                            ++n4;
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Deprecated
    public void updateStates() {
        Collection<NotificationHandler> handlers = this.handlerByEventId.values();
        for (NotificationHandler notificationHandler : handlers) {
            List<NotificationAction> actions = notificationHandler.getActions();
            boolean selected = false;
            for (NotificationAction notificationAction : actions) {
                if (!notificationAction.isSelected()) continue;
                selected = true;
                break;
            }
            notificationHandler.getEvent().setSelected(selected);
        }
    }

    public void setNotificationHandler(String eventId, NotificationHandler handler) {
        this.handlerByEventId.put(eventId, handler);
        this.setDirty(true);
    }
}

