/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.tmf.core.trace.TmfExperimentContext;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfCheckpoint;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTraceIndexer;
import org.eclipse.linuxtools.tmf.core.trace.TmfCheckpoint;
import org.eclipse.linuxtools.tmf.core.trace.TmfContext;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;

public class TmfCheckpointIndexer<T extends ITmfTrace<ITmfEvent>>
implements ITmfTraceIndexer<T> {
    protected final ITmfTrace<ITmfEvent> fTrace;
    private final int fCheckpointInterval;
    private boolean fIsIndexing;
    protected final List<ITmfCheckpoint> fTraceIndex;
    private ITmfEventRequest<ITmfEvent> fIndexingRequest = null;

    public TmfCheckpointIndexer(ITmfTrace<ITmfEvent> trace) {
        this(trace, 50000);
    }

    public TmfCheckpointIndexer(ITmfTrace<ITmfEvent> trace, int interval) {
        this.fTrace = trace;
        this.fCheckpointInterval = interval;
        this.fTraceIndex = new ArrayList<ITmfCheckpoint>();
        this.fIsIndexing = false;
    }

    @Override
    public void dispose() {
        if (this.fIndexingRequest != null && !this.fIndexingRequest.isCompleted()) {
            this.fIndexingRequest.cancel();
            this.fTraceIndex.clear();
        }
    }

    @Override
    public boolean isIndexing() {
        return this.fIsIndexing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildIndex(long offset, TmfTimeRange range, boolean waitForCompletion) {
        List<ITmfCheckpoint> list = this.fTraceIndex;
        synchronized (list) {
            if (this.fIsIndexing) {
                return;
            }
            this.fIsIndexing = true;
        }
        final Job job = new Job("Indexing " + this.fTrace.getName() + "..."){

            protected IStatus run(IProgressMonitor monitor) {
                while (!monitor.isCanceled()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        this.fIndexingRequest = new TmfEventRequest<ITmfEvent>(ITmfEvent.class, range, offset, Integer.MAX_VALUE, this.fCheckpointInterval, ITmfDataRequest.ExecutionType.BACKGROUND){

            @Override
            public void handleData(ITmfEvent event) {
                super.handleData(event);
                if (event != null && this.getNbRead() % TmfCheckpointIndexer.this.fCheckpointInterval == 0) {
                    this.updateTraceStatus();
                }
            }

            @Override
            public void handleSuccess() {
                this.updateTraceStatus();
            }

            @Override
            public void handleCompleted() {
                job.cancel();
                super.handleCompleted();
                TmfCheckpointIndexer.this.fIsIndexing = false;
            }

            private void updateTraceStatus() {
                if (TmfCheckpointIndexer.this.fTrace.getNbEvents() > 0L) {
                    TmfCheckpointIndexer.this.signalNewTimeRange(TmfCheckpointIndexer.this.fTrace.getStartTime(), TmfCheckpointIndexer.this.fTrace.getEndTime());
                }
            }
        };
        this.fTrace.sendRequest(this.fIndexingRequest);
        if (waitForCompletion) {
            try {
                this.fIndexingRequest.waitForCompletion();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void signalNewTimeRange(ITmfTimestamp startTime, ITmfTimestamp endTime) {
        this.fTrace.broadcast(new TmfTraceUpdatedSignal(this.fTrace, this.fTrace, new TmfTimeRange(startTime, endTime)));
    }

    @Override
    public synchronized void updateIndex(ITmfContext context, ITmfTimestamp timestamp) {
        long rank = context.getRank();
        if (rank % (long)this.fCheckpointInterval == 0L) {
            long position = rank / (long)this.fCheckpointInterval;
            if ((long)this.fTraceIndex.size() == position) {
                this.fTraceIndex.add(new TmfCheckpoint(timestamp.clone(), TmfCheckpointIndexer.saveContext(context)));
            }
        }
    }

    @Override
    public synchronized ITmfContext seekIndex(ITmfTimestamp timestamp) {
        if (timestamp == null) {
            return this.fTrace.seekEvent(0L);
        }
        int index = Collections.binarySearch(this.fTraceIndex, new TmfCheckpoint(timestamp, null));
        if (index < 0) {
            index = Math.max(0, -(index + 2));
        }
        return this.restoreCheckpoint(index);
    }

    @Override
    public ITmfContext seekIndex(long rank) {
        if (rank < 0L) {
            return this.fTrace.seekEvent(0L);
        }
        int index = (int)rank / this.fCheckpointInterval;
        return this.restoreCheckpoint(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITmfContext restoreCheckpoint(int checkpoint) {
        ITmfLocation<?> location = null;
        int index = 0;
        List<ITmfCheckpoint> list = this.fTraceIndex;
        synchronized (list) {
            if (!this.fTraceIndex.isEmpty()) {
                index = checkpoint;
                if (index >= this.fTraceIndex.size()) {
                    index = this.fTraceIndex.size() - 1;
                }
                return this.restoreContext(this.fTraceIndex.get(index).getContext());
            }
        }
        ITmfContext context = this.fTrace.seekEvent(location);
        context.setRank((long)index * (long)this.fCheckpointInterval);
        return context;
    }

    protected List<ITmfCheckpoint> getTraceIndex() {
        return this.fTraceIndex;
    }

    private static ITmfContext saveContext(ITmfContext context) {
        if (context instanceof TmfExperimentContext) {
            return TmfCheckpointIndexer.saveExpContext(context);
        }
        TmfContext ctx = new TmfContext(context.getLocation().clone(), context.getRank());
        return ctx;
    }

    private static ITmfContext saveExpContext(ITmfContext context) {
        TmfExperimentContext expContext = (TmfExperimentContext)context;
        int size = expContext.getContexts().length;
        ITmfContext[] trcCtxts = new TmfContext[size];
        int i = 0;
        while (i < size) {
            ITmfContext ctx = expContext.getContexts()[i];
            trcCtxts[i] = ctx != null ? new TmfContext(ctx.getLocation().clone(), ctx.getRank()) : null;
            ++i;
        }
        TmfExperimentContext expCtx = new TmfExperimentContext(trcCtxts);
        expCtx.setLocation(context.getLocation().clone());
        expCtx.setRank(context.getRank());
        ITmfEvent[] trcEvts = expCtx.getEvents();
        int i2 = 0;
        while (i2 < size) {
            ITmfEvent event = expContext.getEvents()[i2];
            trcEvts[i2] = event != null ? event.clone() : null;
            ++i2;
        }
        return expCtx;
    }

    private ITmfContext restoreContext(ITmfContext context) {
        if (context instanceof TmfExperimentContext) {
            return this.restoreExpContext(context);
        }
        ITmfContext ctx = this.fTrace.seekEvent(context.getLocation());
        ctx.setRank(context.getRank());
        return ctx;
    }

    private ITmfContext restoreExpContext(ITmfContext context) {
        TmfExperimentContext expContext = (TmfExperimentContext)context;
        int size = expContext.getContexts().length;
        ITmfContext[] trcCtxts = new ITmfContext[size];
        int i = 0;
        while (i < size) {
            ITmfTrace trace = ((TmfExperiment)this.fTrace).getTraces()[i];
            ITmfContext ctx = expContext.getContexts()[i];
            trcCtxts[i] = trace.seekEvent(ctx.getLocation().clone());
            trcCtxts[i].setRank(ctx.getRank());
            ++i;
        }
        TmfExperimentContext ctx = new TmfExperimentContext(trcCtxts);
        ctx.setLocation(context.getLocation().clone());
        ctx.setRank(context.getRank());
        ITmfEvent[] trcEvts = expContext.getEvents();
        int i2 = 0;
        while (i2 < size) {
            ITmfEvent event = trcEvts[i2];
            ctx.getEvents()[i2] = event != null ? event.clone() : null;
            ++i2;
        }
        return ctx;
    }
}

