/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statesystem;

import java.io.File;
import java.io.IOException;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.HistoryBuilder;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.historytree.HistoryTreeBackend;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.historytree.ThreadedHistoryTreeBackend;
import org.eclipse.linuxtools.tmf.core.component.TmfComponent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateChangeInput;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemBuilder;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemQuerier;

public abstract class StateSystemManager
extends TmfComponent {
    private static final int QUEUE_SIZE = 10000;

    public static IStateSystemQuerier loadStateHistory(File htFile, IStateChangeInput htInput, boolean buildManually) throws TmfTraceException {
        HistoryBuilder builder;
        if (htFile.exists()) {
            try {
                HistoryTreeBackend htBackend = new HistoryTreeBackend(htFile);
                IStateSystemBuilder ss = HistoryBuilder.openExistingHistory(htBackend);
                return ss;
            }
            catch (IOException iOException) {}
        }
        if (htInput == null) {
            return null;
        }
        try {
            ThreadedHistoryTreeBackend htBackend = new ThreadedHistoryTreeBackend(htFile, htInput.getStartTime(), 10000);
            builder = new HistoryBuilder(htInput, htBackend, buildManually);
        }
        catch (IOException e) {
            throw new TmfTraceException(e.toString(), e);
        }
        return builder.getStateSystemQuerier();
    }
}

