/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.event;

import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventType;
import org.eclipse.linuxtools.tmf.core.event.ITmfLostEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class TmfLostEvent
extends TmfEvent
implements ITmfLostEvent {
    private TmfTimeRange fTimeRange;
    private long fNbLostEvents;

    public TmfLostEvent() {
        this(null, -1L, null, null, null, null, TmfTimeRange.NULL_RANGE, 0L);
    }

    public TmfLostEvent(ITmfTrace<? extends ITmfEvent> trace, long rank, ITmfTimestamp timestamp, String source, ITmfEventType type, String reference, TmfTimeRange timeRange, long nbLostEvents) {
        super(trace, rank, timestamp, source, type, null, reference);
        this.fTimeRange = timeRange;
        this.fNbLostEvents = nbLostEvents;
    }

    public TmfLostEvent(ITmfLostEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        this.setTrace(event.getTrace());
        this.setRank(event.getRank());
        this.setTimestamp(event.getTimestamp());
        this.setSource(event.getSource());
        this.setType(event.getType());
        this.setContent(event.getContent());
        this.setReference(event.getReference());
        this.fTimeRange = event.getTimeRange();
        this.fNbLostEvents = event.getNbLostEvents();
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return this.fTimeRange;
    }

    @Override
    public long getNbLostEvents() {
        return this.fNbLostEvents;
    }

    protected void setTimeRange(TmfTimeRange timeRange) {
        this.fTimeRange = timeRange;
    }

    protected void setNbLostEvents(long nbLostEvents) {
        this.fNbLostEvents = nbLostEvents;
    }

    @Override
    public TmfLostEvent clone() {
        TmfLostEvent clone = null;
        try {
            clone = (TmfLostEvent)super.clone();
            clone.fTimeRange = this.fTimeRange.clone();
            clone.fNbLostEvents = this.fNbLostEvents;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.fNbLostEvents ^ this.fNbLostEvents >>> 32);
        result = 31 * result + (this.fTimeRange == null ? 0 : this.fTimeRange.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TmfLostEvent)) {
            return false;
        }
        TmfLostEvent other = (TmfLostEvent)obj;
        if (this.fNbLostEvents != other.fNbLostEvents) {
            return false;
        }
        return !(this.fTimeRange == null ? other.fTimeRange != null : !this.fTimeRange.equals(other.fTimeRange));
    }

    @Override
    public String toString() {
        return "TmfLostEvent [Event=" + super.toString() + ", fTimeRange=" + this.fTimeRange + ", fNbLostEvents=" + this.fNbLostEvents + "]";
    }
}

