/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfIterator;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfIteratorManager;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfLocation;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;

public class CtfTmfLightweightContext
implements ITmfContext {
    private CtfLocation curLocation;
    private long curRank;
    private final CtfTmfTrace fTrace;

    @Deprecated
    public CtfTmfLightweightContext(ArrayList<CtfIterator> iters, ListIterator<CtfIterator> pos) {
        this.fTrace = iters.get(0).getCtfTmfTrace();
        this.curLocation = new CtfLocation(null);
    }

    public CtfTmfLightweightContext(CtfTmfTrace ctfTmfTrace) {
        this.fTrace = ctfTmfTrace;
        this.curLocation = new CtfLocation(null);
    }

    @Override
    public long getRank() {
        return this.curRank;
    }

    @Override
    public ITmfLocation<? extends Comparable<?>> getLocation() {
        return this.curLocation;
    }

    @Override
    public boolean hasValidRank() {
        return this.curRank != CtfLocation.INVALID_LOCATION;
    }

    @Override
    public void setLocation(ITmfLocation<? extends Comparable<?>> location) {
        this.curLocation = (CtfLocation)location;
        this.getIterator().seek(this.curLocation.getLocation());
    }

    @Override
    public void setRank(long rank) {
        this.curRank = rank;
    }

    @Override
    public void increaseRank() {
        if (this.hasValidRank()) {
            ++this.curRank;
        }
    }

    public synchronized CtfTmfEvent getCurrentEvent() {
        return this.getIterator().getCurrentEvent();
    }

    public synchronized boolean advance() {
        boolean retVal = this.getIterator().advance();
        CtfTmfEvent currentEvent = this.getIterator().getCurrentEvent();
        if (currentEvent != null) {
            this.curLocation.setLocation(currentEvent.getTimestampValue());
        } else {
            this.curLocation.setLocation(CtfLocation.INVALID_LOCATION);
        }
        return retVal;
    }

    @Override
    public void dispose() {
    }

    public synchronized boolean seek(long timestamp) {
        this.curLocation.setLocation(timestamp);
        return this.getIterator().seek(timestamp);
    }

    @Override
    public CtfTmfLightweightContext clone() {
        CtfTmfLightweightContext ret = new CtfTmfLightweightContext(this.fTrace);
        ret.curLocation = this.curLocation.clone();
        ret.curRank = this.curRank;
        return ret;
    }

    private CtfIterator getIterator() {
        return CtfIteratorManager.getIterator(this.fTrace, this);
    }
}

