/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import org.eclipse.linuxtools.ctf.core.event.types.ArrayDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.FloatDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.SequenceDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.SequenceDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StringDefinition;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CTFFloatField;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CTFIntegerArrayField;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CTFIntegerField;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CTFStringField;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;

public abstract class CtfTmfEventField
implements ITmfEventField {
    protected static final int FIELDTYPE_INTEGER = 0;
    protected static final int FIELDTYPE_STRING = 1;
    protected static final int FIELDTYPE_INTEGER_ARRAY = 2;
    protected static final int FIELDTYPE_FLOAT = 3;
    protected final String name;

    protected CtfTmfEventField(String name) {
        this.name = name.startsWith("_") ? name.substring(1) : name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static CtfTmfEventField parseField(Definition fieldDef, String fieldName) {
        CtfTmfEventField field = null;
        if (fieldDef instanceof IntegerDefinition) {
            IntegerDefinition intDef = (IntegerDefinition)fieldDef;
            int base = intDef.getDeclaration().getBase();
            field = new CTFIntegerField(intDef.getValue(), fieldName, base);
        } else if (fieldDef instanceof EnumDefinition) {
            EnumDefinition enumDef = (EnumDefinition)fieldDef;
            field = new CTFStringField(enumDef.getValue(), fieldName);
        } else if (fieldDef instanceof StringDefinition) {
            field = new CTFStringField(((StringDefinition)fieldDef).getValue(), fieldName);
        } else if (fieldDef instanceof ArrayDefinition) {
            ArrayDefinition arrayDef = (ArrayDefinition)fieldDef;
            ArrayDeclaration arrayDecl = arrayDef.getDeclaration();
            if (arrayDef.isString()) {
                field = new CTFStringField(fieldDef.toString(), fieldName);
            } else if (arrayDecl.getElementType() instanceof IntegerDeclaration) {
                long[] values = new long[arrayDecl.getLength()];
                int i = 0;
                while (i < arrayDecl.getLength()) {
                    values[i] = ((IntegerDefinition)arrayDef.getElem(i)).getValue();
                    ++i;
                }
                field = new CTFIntegerArrayField(values, fieldName);
            }
        } else if (fieldDef instanceof SequenceDefinition) {
            SequenceDefinition seqDef = (SequenceDefinition)fieldDef;
            SequenceDeclaration seqDecl = seqDef.getDeclaration();
            if (seqDef.getLength() == 0) {
                field = new CTFStringField("", fieldName);
            } else if (seqDef.isString()) {
                field = new CTFStringField(seqDef.toString(), fieldName);
            } else if (seqDecl.getElementType() instanceof IntegerDeclaration) {
                long[] values = new long[seqDef.getLength()];
                int i = 0;
                while (i < seqDef.getLength()) {
                    values[i] = ((IntegerDefinition)seqDef.getElem(i)).getValue();
                    ++i;
                }
                field = new CTFIntegerArrayField(values, fieldName);
            }
        } else if (fieldDef instanceof FloatDefinition) {
            FloatDefinition floatDef = (FloatDefinition)fieldDef;
            field = new CTFFloatField(floatDef.getValue(), fieldName);
        }
        return field;
    }

    public static CtfTmfEventField copyFrom(CtfTmfEventField other) {
        switch (other.getFieldType()) {
            case 0: {
                CTFIntegerField intOther = (CTFIntegerField)other;
                return new CTFIntegerField(intOther.getValue(), intOther.name, intOther.getBase());
            }
            case 1: {
                return new CTFStringField(((CTFStringField)other).getValue(), other.name);
            }
            case 2: {
                return new CTFIntegerArrayField(((CTFIntegerArrayField)other).getValue(), other.name);
            }
            case 3: {
                return new CTFFloatField(((CTFFloatField)other).getValue(), other.name);
            }
        }
        return null;
    }

    @Override
    public CtfTmfEventField clone() {
        return CtfTmfEventField.copyFrom(this);
    }

    public abstract int getFieldType();

    @Override
    public abstract Object getValue();

    @Override
    public String[] getFieldNames() {
        return null;
    }

    @Override
    public String getFieldName(int index) {
        return null;
    }

    @Override
    public ITmfEventField[] getFields() {
        return null;
    }

    @Override
    public ITmfEventField getField(String fieldName) {
        return null;
    }

    @Override
    public ITmfEventField getField(int index) {
        return null;
    }
}

