/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.component;

import org.eclipse.linuxtools.internal.tmf.core.Tracer;
import org.eclipse.linuxtools.internal.tmf.core.request.TmfCoalescedEventRequest;
import org.eclipse.linuxtools.tmf.core.component.TmfDataProvider;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;

public abstract class TmfEventProvider<T extends ITmfEvent>
extends TmfDataProvider<T> {
    public TmfEventProvider() {
    }

    @Override
    public void init(String name, Class<T> type) {
        super.init(name, type);
    }

    public TmfEventProvider(String name, Class<T> type) {
        super(name, type);
    }

    public TmfEventProvider(String name, Class<T> type, int queueSize) {
        super(name, type, queueSize);
    }

    public TmfEventProvider(TmfEventProvider<T> other) {
        super(other);
    }

    @Override
    public boolean isCompleted(ITmfDataRequest<T> request, T data, int nbRead) {
        boolean requestCompleted = super.isCompleted(request, data, nbRead);
        if (!requestCompleted && request instanceof ITmfEventRequest) {
            ITmfTimestamp endTime = ((ITmfEventRequest)request).getRange().getEndTime();
            return data.getTimestamp().compareTo(endTime, false) > 0;
        }
        return requestCompleted;
    }

    @Override
    protected synchronized void newCoalescedDataRequest(ITmfDataRequest<T> request) {
        if (request instanceof ITmfEventRequest) {
            ITmfEventRequest eventRequest = (ITmfEventRequest)request;
            TmfCoalescedEventRequest coalescedRequest = new TmfCoalescedEventRequest(eventRequest.getDataType(), eventRequest.getRange(), eventRequest.getIndex(), eventRequest.getNbRequested(), eventRequest.getBlockSize(), eventRequest.getExecType());
            coalescedRequest.addRequest(eventRequest);
            if (Tracer.isRequestTraced()) {
                Tracer.traceRequest(request, "COALESCED with " + coalescedRequest.getRequestId());
                Tracer.traceRequest(coalescedRequest, "now contains " + coalescedRequest.getSubRequestIds());
            }
            this.fPendingCoalescedRequests.add(coalescedRequest);
        } else {
            super.newCoalescedDataRequest(request);
        }
    }

    @Override
    protected void queueBackgroundRequest(final ITmfDataRequest<T> request, final int blockSize, final boolean indexing) {
        if (!(request instanceof ITmfEventRequest)) {
            super.queueBackgroundRequest(request, blockSize, indexing);
            return;
        }
        final TmfEventProvider provider = this;
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (Tracer.isRequestTraced()) {
                    Tracer.traceRequest(request, "is being serviced by " + provider.getName());
                }
                request.start();
                final Integer[] CHUNK_SIZE = new Integer[]{Math.min(request.getNbRequested(), blockSize + (indexing ? 1 : 0))};
                final Integer[] nbRead = new Integer[]{0};
                final Boolean[] isFinished = new Boolean[]{Boolean.FALSE};
                long startIndex = request.getIndex();
                while (!isFinished[0].booleanValue()) {
                    TmfEventRequest subRequest = new TmfEventRequest<T>(request.getDataType(), ((ITmfEventRequest)request).getRange(), startIndex + (long)nbRead[0].intValue(), CHUNK_SIZE[0], blockSize, ITmfDataRequest.ExecutionType.BACKGROUND){

                        @Override
                        public synchronized boolean isCompleted() {
                            return super.isCompleted() || request.isCompleted();
                        }

                        @Override
                        public void handleData(T data) {
                            super.handleData(data);
                            if (request.getDataType().isInstance(data)) {
                                request.handleData(data);
                            }
                            if (this.getNbRead() > CHUNK_SIZE[0]) {
                                System.out.println("ERROR - Read too many events");
                            }
                        }

                        @Override
                        public void handleCompleted() {
                            nbRead[0] = nbRead[0] + this.getNbRead();
                            if (nbRead[0] >= request.getNbRequested() || this.getNbRead() < CHUNK_SIZE[0]) {
                                if (this.isCancelled()) {
                                    request.cancel();
                                } else if (this.isFailed()) {
                                    request.fail();
                                } else {
                                    request.done();
                                }
                                isFinished[0] = Boolean.TRUE;
                            }
                            super.handleCompleted();
                        }
                    };
                    if (isFinished[0].booleanValue()) continue;
                    TmfEventProvider.this.queueRequest(subRequest);
                    try {
                        subRequest.waitForCompletion();
                        if (request.isCompleted()) {
                            isFinished[0] = Boolean.TRUE;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (startIndex == 0L && nbRead[0].equals(CHUNK_SIZE[0])) {
                        startIndex = subRequest.getIndex();
                    }
                    CHUNK_SIZE[0] = Math.min(request.getNbRequested() - nbRead[0], blockSize);
                }
            }
        };
        thread.start();
    }
}

