/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem.historytree;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.IStateHistoryBackend;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.historytree.CoreNode;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.historytree.HTInterval;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.historytree.HTNode;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.historytree.HT_IO;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.historytree.HistoryTree;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.TmfStateValue;

public class HistoryTreeBackend
implements IStateHistoryBackend {
    protected final HistoryTree sht;
    private final HT_IO treeIO;

    public HistoryTreeBackend(File newStateFile, int blockSize, int maxChildren, long startTime) throws IOException {
        this.sht = new HistoryTree(newStateFile, blockSize, maxChildren, startTime);
        this.treeIO = this.sht.getTreeIO();
    }

    public HistoryTreeBackend(File newStateFile, long startTime) throws IOException {
        this(newStateFile, 65536, 50, startTime);
    }

    public HistoryTreeBackend(File existingStateFile) throws IOException {
        this.sht = new HistoryTree(existingStateFile);
        this.treeIO = this.sht.getTreeIO();
    }

    @Override
    public long getStartTime() {
        return this.sht.getTreeStart();
    }

    @Override
    public long getEndTime() {
        return this.sht.getTreeEnd();
    }

    @Override
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, ITmfStateValue value) throws TimeRangeException {
        HTInterval interval = new HTInterval(stateStartTime, stateEndTime, quark, (TmfStateValue)value);
        this.sht.insertInterval(interval);
    }

    @Override
    public void finishedBuilding(long endTime) {
        this.sht.closeTree(endTime);
    }

    @Override
    public FileInputStream supplyAttributeTreeReader() {
        return this.treeIO.supplyATReader();
    }

    @Override
    public File supplyAttributeTreeWriterFile() {
        return this.treeIO.supplyATWriterFile();
    }

    @Override
    public long supplyAttributeTreeWriterFilePosition() {
        return this.treeIO.supplyATWriterFilePos();
    }

    @Override
    public void removeFiles() {
        this.treeIO.deleteFile();
    }

    @Override
    public void doQuery(List<ITmfStateInterval> stateInfo, long t) throws TimeRangeException {
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException();
        }
        CoreNode currentNode = this.sht.latestBranch.firstElement();
        currentNode.writeInfoFromNode(stateInfo, t);
        while (currentNode.getNbChildren() > 0) {
            currentNode = (CoreNode)this.sht.selectNextChild(currentNode, t);
            currentNode.writeInfoFromNode(stateInfo, t);
        }
    }

    @Override
    public ITmfStateInterval doSingularQuery(long t, int attributeQuark) throws TimeRangeException {
        return this.getRelevantInterval(t, attributeQuark);
    }

    @Override
    public boolean checkValidTime(long t) {
        return t >= this.sht.getTreeStart() && t <= this.sht.getTreeEnd();
    }

    private HTInterval getRelevantInterval(long t, int key) throws TimeRangeException {
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException();
        }
        CoreNode currentNode = this.sht.latestBranch.firstElement();
        HTInterval interval = currentNode.getRelevantInterval(key, t);
        while (interval == null && currentNode.getNbChildren() > 0) {
            currentNode = (CoreNode)this.sht.selectNextChild(currentNode, t);
            interval = currentNode.getRelevantInterval(key, t);
        }
        assert (interval != null);
        return interval;
    }

    public long getFileSize() {
        return this.sht.getFileSize();
    }

    public int getTreeDepth() {
        return this.sht.latestBranch.size();
    }

    public int getAverageNodeUsage() {
        long total = 0L;
        int seq = 0;
        while (seq < this.sht.getNodeCount()) {
            HTNode node = this.treeIO.readNode(seq);
            total += node.getNodeUsagePRC();
            ++seq;
        }
        long ret = total / (long)this.sht.getNodeCount();
        assert (ret >= 0L && ret <= 100L);
        return (int)ret;
    }

    @Override
    public void debugPrint(PrintWriter writer) {
        this.debugPrint(writer, false);
    }

    public void debugPrint(PrintWriter writer, boolean printIntervals) {
        writer.println("------------------------------");
        writer.println("State History Tree:\n");
        writer.println(this.sht.toString());
        writer.println("Average node utilization: " + this.getAverageNodeUsage());
        writer.println("");
        this.sht.debugPrintFullTree(writer, printIntervals);
    }
}

