/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.internal.tmf.core.Tracer;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.AttributeTree;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.IStateHistoryBackend;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.TransientState;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.interval.TmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemBuilder;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemQuerier2;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.TmfStateValue;

public class StateSystem
implements IStateSystemBuilder,
IStateSystemQuerier2 {
    private final AttributeTree attributeTree;
    private final TransientState transState;
    private final IStateHistoryBackend backend;

    public StateSystem(IStateHistoryBackend backend, boolean newFile) throws IOException {
        this.backend = backend;
        this.transState = new TransientState(backend);
        if (newFile) {
            this.attributeTree = new AttributeTree(this);
        } else {
            this.attributeTree = new AttributeTree(this, backend.supplyAttributeTreeReader());
            this.transState.setInactive();
        }
    }

    void addEmptyAttribute() {
        this.transState.addEmptyEntry();
    }

    @Override
    public int getNbAttributes() {
        return this.attributeTree.getNbAttributes();
    }

    @Override
    public String getAttributeName(int attributeQuark) {
        return this.attributeTree.getAttributeName(attributeQuark);
    }

    @Override
    public String getFullAttributePath(int attributeQuark) {
        return this.attributeTree.getFullAttributeName(attributeQuark);
    }

    @Override
    public long getStartTime() {
        return this.backend.getStartTime();
    }

    @Override
    public long getCurrentEndTime() {
        return this.backend.getEndTime();
    }

    @Override
    public void closeHistory(long endTime) throws TimeRangeException {
        long realEndTime = endTime;
        if (realEndTime < this.backend.getEndTime()) {
            realEndTime = this.backend.getEndTime();
        }
        this.transState.closeTransientState(realEndTime);
        this.backend.finishedBuilding(realEndTime);
        File attributeTreeFile = this.backend.supplyAttributeTreeWriterFile();
        long attributeTreeFilePos = this.backend.supplyAttributeTreeWriterFilePosition();
        if (attributeTreeFile != null) {
            this.attributeTree.writeSelf(attributeTreeFile, attributeTreeFilePos);
        }
    }

    @Override
    public int getQuarkAbsolute(String ... attribute) throws AttributeNotFoundException {
        return this.attributeTree.getQuarkDontAdd(-1, attribute);
    }

    @Override
    public int getQuarkAbsoluteAndAdd(String ... attribute) {
        return this.attributeTree.getQuarkAndAdd(-1, attribute);
    }

    @Override
    public int getQuarkRelative(int startingNodeQuark, String ... subPath) throws AttributeNotFoundException {
        return this.attributeTree.getQuarkDontAdd(startingNodeQuark, subPath);
    }

    @Override
    public int getQuarkRelativeAndAdd(int startingNodeQuark, String ... subPath) {
        return this.attributeTree.getQuarkAndAdd(startingNodeQuark, subPath);
    }

    @Override
    public List<Integer> getSubAttributes(int quark, boolean recursive) throws AttributeNotFoundException {
        return this.attributeTree.getSubAttributes(quark, recursive);
    }

    @Override
    public List<Integer> getQuarks(String ... pattern) {
        List<Integer> directChildren;
        LinkedList<Integer> quarks = new LinkedList<Integer>();
        LinkedList<String> prefix = new LinkedList<String>();
        LinkedList<String> suffix = new LinkedList<String>();
        boolean split = false;
        String[] stringArray = pattern;
        int n = pattern.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (entry.equals("*")) {
                if (split) {
                    return quarks;
                }
                split = true;
            } else if (split) {
                suffix.add(entry);
            } else {
                prefix.add(entry);
            }
            ++n2;
        }
        String[] prefixStr = prefix.toArray(new String[prefix.size()]);
        String[] suffixStr = suffix.toArray(new String[suffix.size()]);
        if (!split) {
            int quark;
            try {
                quark = this.getQuarkAbsolute(prefixStr);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                return quarks;
            }
            quarks.add(quark);
            return quarks;
        }
        try {
            int startingAttribute = prefix.size() == 0 ? -1 : this.getQuarkAbsolute(prefixStr);
            directChildren = this.attributeTree.getSubAttributes(startingAttribute, false);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return quarks;
        }
        for (int childQuark : directChildren) {
            int matchingQuark;
            try {
                matchingQuark = this.getQuarkRelative(childQuark, suffixStr);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                continue;
            }
            quarks.add(matchingQuark);
        }
        return quarks;
    }

    @Override
    public void modifyAttribute(long t, ITmfStateValue value, int attributeQuark) throws TimeRangeException, AttributeNotFoundException, StateValueTypeException {
        this.transState.processStateChange(t, value, attributeQuark);
    }

    @Override
    public void incrementAttribute(long t, int attributeQuark) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
        int prevValue = this.queryOngoingState(attributeQuark).unboxInt();
        if (prevValue == -1) {
            prevValue = 0;
        }
        this.modifyAttribute(t, TmfStateValue.newValueInt(prevValue + 1), attributeQuark);
    }

    @Override
    public void pushAttribute(long t, ITmfStateValue value, int attributeQuark) throws TimeRangeException, AttributeNotFoundException, StateValueTypeException {
        Integer stackDepth = 0;
        ITmfStateValue previousSV = this.transState.getOngoingStateValue(attributeQuark);
        if (!previousSV.isNull()) {
            if (previousSV.getType() == 0) {
                stackDepth = previousSV.unboxInt();
            } else {
                throw new StateValueTypeException();
            }
        }
        if (stackDepth >= 10) {
            String message = "Stack limit reached, not pushing";
            throw new AttributeNotFoundException(message);
        }
        stackDepth = stackDepth + 1;
        int subAttributeQuark = this.getQuarkRelativeAndAdd(attributeQuark, stackDepth.toString());
        this.modifyAttribute(t, TmfStateValue.newValueInt(stackDepth), attributeQuark);
        this.modifyAttribute(t, value, subAttributeQuark);
    }

    @Override
    public void popAttribute(long t, int attributeQuark) throws AttributeNotFoundException, TimeRangeException, StateValueTypeException {
        ITmfStateValue previousSV = this.transState.getOngoingStateValue(attributeQuark);
        if (previousSV.isNull()) {
            return;
        }
        if (previousSV.getType() != 0) {
            throw new StateValueTypeException();
        }
        Integer stackDepth = previousSV.unboxInt();
        if (stackDepth == 0) {
            return;
        }
        if (stackDepth < 0) {
            String message = "A top-level stack attribute cannot have a negative integer value.";
            throw new StateValueTypeException(message);
        }
        int subAttributeQuark = this.getQuarkRelative(attributeQuark, stackDepth.toString());
        stackDepth = stackDepth - 1;
        this.modifyAttribute(t, TmfStateValue.newValueInt(stackDepth), attributeQuark);
        this.removeAttribute(t, subAttributeQuark);
    }

    @Override
    public void removeAttribute(long t, int attributeQuark) throws TimeRangeException, AttributeNotFoundException {
        assert (attributeQuark >= 0);
        List<Integer> childAttributes = this.attributeTree.getSubAttributes(attributeQuark, false);
        for (Integer childNodeQuark : childAttributes) {
            assert (attributeQuark != childNodeQuark);
            this.removeAttribute(t, childNodeQuark);
        }
        try {
            this.transState.processStateChange(t, TmfStateValue.nullValue(), attributeQuark);
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ITmfStateValue queryOngoingState(int attributeQuark) throws AttributeNotFoundException {
        return this.transState.getOngoingStateValue(attributeQuark);
    }

    @Override
    public void updateOngoingState(ITmfStateValue newValue, int attributeQuark) throws AttributeNotFoundException {
        this.transState.changeOngoingStateValue(attributeQuark, newValue);
    }

    @Override
    public synchronized List<ITmfStateInterval> queryFullState(long t) throws TimeRangeException {
        ArrayList<ITmfStateInterval> stateInfo = new ArrayList<ITmfStateInterval>(this.attributeTree.getNbAttributes());
        int i = 0;
        while (i < this.attributeTree.getNbAttributes()) {
            stateInfo.add(null);
            ++i;
        }
        this.backend.doQuery(stateInfo, t);
        if (this.transState.isActive()) {
            this.transState.doQuery(stateInfo, t);
        }
        i = 0;
        while (i < stateInfo.size()) {
            if (stateInfo.get(i) == null) {
                stateInfo.set(i, new TmfStateInterval(t, t, i, TmfStateValue.nullValue()));
            }
            ++i;
        }
        return stateInfo;
    }

    @Override
    public ITmfStateInterval querySingleState(long t, int attributeQuark) throws AttributeNotFoundException, TimeRangeException {
        ITmfStateInterval ret = this.transState.hasInfoAboutStateOf(t, attributeQuark) ? this.transState.getOngoingInterval(attributeQuark) : this.backend.doSingularQuery(t, attributeQuark);
        if (ret == null) {
            return new TmfStateInterval(t, this.getCurrentEndTime(), attributeQuark, TmfStateValue.nullValue());
        }
        return ret;
    }

    @Override
    public List<ITmfStateInterval> queryHistoryRange(int attributeQuark, long t1, long t2) throws TimeRangeException, AttributeNotFoundException {
        if (t2 <= t1) {
            throw new TimeRangeException();
        }
        long tEnd = t2 > this.getCurrentEndTime() ? this.getCurrentEndTime() : t2;
        ArrayList<ITmfStateInterval> intervals = new ArrayList<ITmfStateInterval>();
        ITmfStateInterval currentInterval = this.querySingleState(t1, attributeQuark);
        intervals.add(currentInterval);
        long ts = currentInterval.getEndTime();
        while (ts != -1L && ts < tEnd) {
            currentInterval = this.querySingleState(++ts, attributeQuark);
            intervals.add(currentInterval);
            ts = currentInterval.getEndTime();
        }
        return intervals;
    }

    @Override
    public List<ITmfStateInterval> queryHistoryRange(int attributeQuark, long t1, long t2, long resolution) throws TimeRangeException, AttributeNotFoundException {
        return this.queryHistoryRange(attributeQuark, t1, t2, resolution, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public List<ITmfStateInterval> queryHistoryRange(int attributeQuark, long t1, long t2, long resolution, IProgressMonitor monitor) throws TimeRangeException, AttributeNotFoundException {
        if (t2 < t1 || resolution <= 0L) {
            throw new TimeRangeException();
        }
        long tEnd = t2 > this.getCurrentEndTime() ? this.getCurrentEndTime() : t2;
        ArrayList<ITmfStateInterval> intervals = new ArrayList<ITmfStateInterval>();
        ITmfStateInterval currentInterval = this.querySingleState(t1, attributeQuark);
        intervals.add(currentInterval);
        long ts = t1;
        while (currentInterval.getEndTime() != -1L && ts < tEnd) {
            if (monitor.isCanceled()) {
                return intervals;
            }
            if (ts > currentInterval.getEndTime()) {
                currentInterval = this.querySingleState(ts, attributeQuark);
                intervals.add(currentInterval);
            }
            ts += resolution;
        }
        if (currentInterval.getEndTime() < tEnd) {
            currentInterval = this.querySingleState(tEnd, attributeQuark);
            intervals.add(currentInterval);
        }
        return intervals;
    }

    static void logMissingInterval(int attribute, long timestamp) {
        Tracer.traceInfo("No data found in history for attribute " + attribute + " at time " + timestamp + ", returning dummy interval");
    }

    public void debugPrint(PrintWriter writer) {
        this.attributeTree.debugPrint(writer);
        this.transState.debugPrint(writer);
        this.backend.debugPrint(writer);
    }
}

