/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.actions.AbstractTaskRepositoryAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.Messages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.PlatformUI;

public class UpdateRepositoryConfigurationAction
extends AbstractTaskRepositoryAction {
    private static final String ID = "org.eclipse.mylyn.tasklist.repositories.reset";

    public UpdateRepositoryConfigurationAction() {
        super(Messages.UpdateRepositoryConfigurationAction_Update_Repository_Configuration);
        this.setId(ID);
        this.setEnabled(false);
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            AbstractRepositoryConnector connector;
            final TaskRepository repository = this.getTaskRepository(iter.next());
            if (repository == null || (connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind())) == null) continue;
            final String jobName = MessageFormat.format(Messages.UpdateRepositoryConfigurationAction_Updating_repository_configuration_for_X, repository.getRepositoryUrl());
            Job updateJob = new Job(jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(jobName, -1);
                    try {
                        UpdateRepositoryConfigurationAction.this.performUpdate(repository, connector, monitor);
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            updateJob.setProperty(WorkbenchUtil.SHOW_IN_TASKBAR_ICON_PROPERTY, (Object)Boolean.TRUE);
            updateJob.setUser(true);
            updateJob.schedule();
        }
    }

    public void performUpdate(TaskRepository repository, AbstractRepositoryConnector connector, IProgressMonitor monitor) {
        try {
            connector.updateRepositoryConfiguration(repository, monitor);
        }
        catch (CoreException e) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TasksUiInternal.displayStatus(Messages.UpdateRepositoryConfigurationAction_Error_updating_repository_configuration, e.getStatus());
                }
            });
        }
    }
}

