/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.mylyn.tasks.ui.IHighlightingHyperlink;
import org.eclipse.swt.custom.StyleRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHyperlinkTextPresentationManager {
    private static final RegionComparator REGION_COMPARATOR = new RegionComparator();
    private IHyperlinkDetector[] hyperlinkDetectors;
    private final ITextPresentationListener textPresentationListener = new Support();
    private ITextViewer viewer;

    private void addRange(List<StyleRange> ranges, int start, int end) {
        StyleRange styleRange = new StyleRange(start, end - start, null, null);
        this.decorate(styleRange);
        ranges.add(styleRange);
    }

    protected StyleRange[] computeStyleRanges(IRegion extent) {
        if (this.viewer == null || this.hyperlinkDetectors == null || this.viewer.getDocument() == null || extent == null) {
            return null;
        }
        List<IRegion> regions = this.getRegions(extent);
        if (regions != null) {
            ArrayList<StyleRange> ranges = new ArrayList<StyleRange>(regions.size());
            Collections.sort(regions, REGION_COMPARATOR);
            int start = -1;
            int end = -1;
            int x = 0;
            while (x < regions.size()) {
                IRegion region = regions.get(x);
                if (start == -1) {
                    start = region.getOffset();
                    end = region.getOffset() + region.getLength();
                } else if (region.getOffset() >= end) {
                    this.addRange(ranges, start, end);
                    start = region.getOffset();
                    end = region.getOffset() + region.getLength();
                } else {
                    end = region.getOffset() + region.getLength();
                }
                ++x;
            }
            if (start != -1) {
                this.addRange(ranges, start, end);
            }
            return ranges.toArray(new StyleRange[ranges.size()]);
        }
        return null;
    }

    protected abstract void decorate(StyleRange var1);

    public IHyperlinkDetector[] getHyperlinkDetector() {
        return this.hyperlinkDetectors;
    }

    protected List<IRegion> getRegions(IRegion extent) {
        ArrayList<IRegion> regions = null;
        IHyperlinkDetector[] iHyperlinkDetectorArray = this.hyperlinkDetectors;
        int n = this.hyperlinkDetectors.length;
        int n2 = 0;
        while (n2 < n) {
            IHyperlinkDetector hyperlinkDetector = iHyperlinkDetectorArray[n2];
            IHyperlink[] hyperlinks = hyperlinkDetector.detectHyperlinks(this.viewer, extent, true);
            if (hyperlinks != null && hyperlinks.length > 0) {
                IHyperlink[] iHyperlinkArray = hyperlinks;
                int n3 = hyperlinks.length;
                int n4 = 0;
                while (n4 < n3) {
                    IHyperlink hyperlink = iHyperlinkArray[n4];
                    if (this.select(hyperlink)) {
                        if (regions == null) {
                            regions = new ArrayList<IRegion>();
                        }
                        regions.add(hyperlink instanceof IHighlightingHyperlink ? ((IHighlightingHyperlink)hyperlink).getHighlightingRegion() : hyperlink.getHyperlinkRegion());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return regions;
    }

    public void install(ITextViewer viewer) {
        this.viewer = viewer;
        if (viewer instanceof ITextViewerExtension4) {
            ((ITextViewerExtension4)viewer).addTextPresentationListener(this.textPresentationListener);
        }
    }

    public boolean select(IHyperlink hyperlink) {
        return true;
    }

    public void setHyperlinkDetectors(IHyperlinkDetector[] hyperlinkDetectors) {
        this.hyperlinkDetectors = hyperlinkDetectors;
    }

    public void uninstall() {
        ((ITextViewerExtension4)this.viewer).removeTextPresentationListener(this.textPresentationListener);
        this.viewer = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RegionComparator
    implements Comparator<IRegion> {
        @Override
        public int compare(IRegion o1, IRegion o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1.getOffset() < o2.getOffset()) {
                return -1;
            }
            if (o1.getOffset() > o2.getOffset()) {
                return 1;
            }
            if (o1.getLength() < o2.getLength()) {
                return -1;
            }
            if (o1.getLength() > o2.getLength()) {
                return 1;
            }
            return 0;
        }
    }

    private class Support
    implements ITextPresentationListener {
        private Support() {
        }

        public void applyTextPresentation(TextPresentation textPresentation) {
            StyleRange[] styleRanges = AbstractHyperlinkTextPresentationManager.this.computeStyleRanges(textPresentation.getCoverage());
            if (styleRanges != null && styleRanges.length > 0) {
                textPresentation.mergeStyleRanges(styleRanges);
            }
        }
    }
}

