/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.patch.ApplyPatchOperation;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.core.ICoreRunnable;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.AttachmentFileStorage;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.internal.team.ui.actions.Messages;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.statushandlers.StatusManager;

public class ApplyPatchAction
extends BaseSelectionListenerAction
implements IViewActionDelegate {
    private IViewPart viewPart;
    private ISelection currentSelection;

    public ApplyPatchAction() {
        super(Messages.ApplyPatchAction_Apply_Patch);
    }

    protected ApplyPatchAction(String text) {
        super(text);
    }

    public void init(IViewPart view) {
        this.viewPart = view;
    }

    public void run(IAction action) {
        Object object;
        if (this.currentSelection instanceof StructuredSelection && (object = ((StructuredSelection)this.currentSelection).getFirstElement()) instanceof ITaskAttachment) {
            ITaskAttachment attachment = (ITaskAttachment)object;
            IViewPart vp = this.viewPart;
            if (vp == null) {
                vp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            }
            DownloadAndApplyPatch job = new DownloadAndApplyPatch(Messages.ApplyPatchAction_downloadingPatch, attachment, (IWorkbenchPart)vp);
            try {
                WorkbenchUtil.busyCursorWhile((ICoreRunnable)job);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e.getStatus());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
    }

    private static class DownloadAndApplyPatch
    implements ICoreRunnable {
        private final ITaskAttachment attachment;
        private final IWorkbenchPart wbPart;
        private final String jobName;

        public DownloadAndApplyPatch(String jobName, ITaskAttachment attachment, IWorkbenchPart wbPart) {
            this.jobName = jobName;
            this.attachment = attachment;
            this.wbPart = wbPart;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            monitor.beginTask(this.jobName, -1);
            try {
                IStatus result = this.execute((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                if (result != null && !result.isOK()) {
                    throw new CoreException(result);
                }
            }
            finally {
                monitor.done();
            }
        }

        protected IStatus execute(IProgressMonitor monitor) {
            String attachmentFilename = AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment);
            File file = null;
            try {
                file = File.createTempFile("patch-", ".txt");
            }
            catch (IOException e) {
                return new Status(4, "org.eclipse.mylyn.team.ui", Messages.ApplyPatchAction_failedToDownloadPatch, (Throwable)e);
            }
            file.deleteOnExit();
            boolean ok = false;
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(file);
                    AttachmentUtil.downloadAttachment((ITaskAttachment)this.attachment, (OutputStream)fos, (IProgressMonitor)monitor);
                    ok = true;
                }
                catch (IOException e) {
                    Status status;
                    block26: {
                        status = new Status(4, "org.eclipse.mylyn.team.ui", Messages.ApplyPatchAction_failedToDownloadPatch, (Throwable)e);
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException e2) {
                                if (!ok) break block26;
                                file.delete();
                                return new Status(4, "org.eclipse.mylyn.team.ui", Messages.ApplyPatchAction_failedToDownloadPatch, (Throwable)e2);
                            }
                        }
                    }
                    if (!ok) {
                        file.delete();
                    }
                    return status;
                }
                catch (CoreException e) {
                    Status status;
                    block27: {
                        int s = 4;
                        if (e.getStatus() != null && e.getStatus().getCode() == 8) {
                            throw new OperationCanceledException();
                        }
                        status = new Status(s, "org.eclipse.mylyn.team.ui", Messages.ApplyPatchAction_failedToDownloadPatch, (Throwable)e);
                        if (fos == null) break block27;
                        try {
                            fos.close();
                        }
                        catch (IOException e3) {
                            if (!ok) break block27;
                            file.delete();
                            return new Status(4, "org.eclipse.mylyn.team.ui", Messages.ApplyPatchAction_failedToDownloadPatch, (Throwable)e3);
                        }
                    }
                    if (!ok) {
                        file.delete();
                    }
                    return status;
                }
            }
            finally {
                block28: {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            if (!ok) break block28;
                            file.delete();
                            return new Status(4, "org.eclipse.mylyn.team.ui", Messages.ApplyPatchAction_failedToDownloadPatch, (Throwable)e);
                        }
                    }
                }
                if (!ok) {
                    file.delete();
                }
            }
            IWorkbenchPartSite site = this.wbPart.getSite();
            if (site == null) {
                return new Status(2, "org.eclipse.mylyn.team.ui", Messages.ApplyPatchAction_cannotApplyPatch);
            }
            final Display disp = site.getWorkbenchWindow().getWorkbench().getDisplay();
            if (disp.isDisposed()) {
                return new Status(2, "org.eclipse.mylyn.team.ui", Messages.ApplyPatchAction_cannotApplyPatch);
            }
            final AttachmentFileStorage fileStorage = new AttachmentFileStorage(file, attachmentFilename);
            disp.asyncExec(new Runnable(){

                public void run() {
                    ApplyPatchOperation op = new ApplyPatchOperation(DownloadAndApplyPatch.this.wbPart, (IStorage)fileStorage, null, new CompareConfiguration());
                    BusyIndicator.showWhile((Display)disp, (Runnable)op);
                }
            });
            return Status.OK_STATUS;
        }
    }
}

