/*
 * Decompiled with CFR 0.152.
 */
package org.chibios.tools.eclipse.debug.views;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.chibios.tools.eclipse.debug.utils.DebugProxy;
import org.chibios.tools.eclipse.debug.utils.DebugProxyException;
import org.chibios.tools.eclipse.debug.utils.HexUtils;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class ChibiView
extends ViewPart
implements IDebugEventSetListener {
    public static final String ID = "org.chibios.tools.eclipse.debug.views.ChibiView";
    private CTabFolder tabFolder;
    private CTabItem tbtmGlobal;
    private CTabItem tbtmThreads;
    private CTabItem tbtmTimers;
    private CTabItem tbtmTraceBuffer;
    private Action refreshAction;
    private Table threadsTable;
    private Table timersTable;
    private DebugProxy debugger;
    private Table tbTable;
    private Table globalTable;
    private ITheme theme;
    private FocusAdapter focus = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            ChibiView.this.setInactive();
        }

        public void focusGained(FocusEvent e) {
            ChibiView.this.setActive();
        }
    };

    public ChibiView() {
        this.theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
    }

    private void setActive() {
        this.tabFolder.setSelectionBackground(new Color[]{this.theme.getColorRegistry().get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START"), this.theme.getColorRegistry().get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END")}, new int[]{100}, true);
        this.tabFolder.setSelectionForeground(this.theme.getColorRegistry().get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"));
    }

    private void setInactive() {
        this.tabFolder.setSelectionBackground(new Color[]{this.theme.getColorRegistry().get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START"), this.theme.getColorRegistry().get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END")}, new int[]{this.theme.getInt("org.eclipse.ui.workbench.ACTIVE_TAB_PERCENT")}, true);
        this.tabFolder.setSelectionForeground(this.theme.getColorRegistry().get("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR"));
    }

    public void createPartControl(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 3072);
        this.tabFolder.setFont(this.theme.getFontRegistry().get("org.eclipse.ui.workbench.TAB_TEXT_FONT"));
        this.tabFolder.setBackground(this.theme.getColorRegistry().get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END"));
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChibiView.this.setActive();
                ChibiView.this.tabFolder.getSelection().getControl().setFocus();
            }
        });
        this.tabFolder.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ChibiView.this.tabFolder.getSelection().getControl().setFocus();
            }
        });
        this.setInactive();
        this.tabFolder.setSimple(false);
        this.tbtmGlobal = new CTabItem(this.tabFolder, 0);
        this.tbtmGlobal.setText("Global");
        this.globalTable = new Table((Composite)this.tabFolder, 65536);
        this.globalTable.addFocusListener((FocusListener)this.focus);
        this.globalTable.setFont(SWTResourceManager.getFont("Courier New", 8, 0));
        this.tbtmGlobal.setControl((Control)this.globalTable);
        this.globalTable.setHeaderVisible(true);
        TableColumn tblclmnGlobalHidden = new TableColumn(this.globalTable, 131072);
        tblclmnGlobalHidden.setWidth(0);
        tblclmnGlobalHidden.setText("");
        TableColumn tblclmnGlobalVariableName = new TableColumn(this.globalTable, 16384);
        tblclmnGlobalVariableName.setWidth(150);
        tblclmnGlobalVariableName.setText("Variable");
        TableColumn tblclmnGlobalVariableValue = new TableColumn(this.globalTable, 16384);
        tblclmnGlobalVariableValue.setWidth(300);
        tblclmnGlobalVariableValue.setText("Value");
        this.tbtmThreads = new CTabItem(this.tabFolder, 0);
        this.tbtmThreads.setText("Threads");
        this.threadsTable = new Table((Composite)this.tabFolder, 65536);
        this.threadsTable.addFocusListener((FocusListener)this.focus);
        this.tbtmThreads.setControl((Control)this.threadsTable);
        this.threadsTable.setFont(SWTResourceManager.getFont("Courier New", 8, 0));
        this.threadsTable.setHeaderVisible(true);
        TableColumn tblclmnThreadAddress = new TableColumn(this.threadsTable, 131072);
        tblclmnThreadAddress.setWidth(72);
        tblclmnThreadAddress.setText("Address");
        TableColumn tblclmnThreadLimit = new TableColumn(this.threadsTable, 131072);
        tblclmnThreadLimit.setWidth(72);
        tblclmnThreadLimit.setText("StkLimit");
        TableColumn tblclmnThreadStack = new TableColumn(this.threadsTable, 131072);
        tblclmnThreadStack.setWidth(72);
        tblclmnThreadStack.setText("Stack");
        TableColumn tblclmnThreadUsed = new TableColumn(this.threadsTable, 131072);
        tblclmnThreadUsed.setWidth(72);
        tblclmnThreadUsed.setText("StkUnused");
        TableColumn tblclmnThreadName = new TableColumn(this.threadsTable, 16384);
        tblclmnThreadName.setWidth(144);
        tblclmnThreadName.setText("Name");
        TableColumn tblclmnThreadState = new TableColumn(this.threadsTable, 131072);
        tblclmnThreadState.setWidth(72);
        tblclmnThreadState.setText("State");
        TableColumn tblclmnThreadFlags = new TableColumn(this.threadsTable, 131072);
        tblclmnThreadFlags.setWidth(40);
        tblclmnThreadFlags.setText("Flgs");
        TableColumn tblclmnThreadPriority = new TableColumn(this.threadsTable, 131072);
        tblclmnThreadPriority.setWidth(40);
        tblclmnThreadPriority.setText("Prio");
        TableColumn tblclmnThreadRefs = new TableColumn(this.threadsTable, 131072);
        tblclmnThreadRefs.setWidth(40);
        tblclmnThreadRefs.setText("Refs");
        TableColumn tblclmnThreadTime = new TableColumn(this.threadsTable, 131072);
        tblclmnThreadTime.setWidth(64);
        tblclmnThreadTime.setText("Time");
        TableColumn tblclmnThreadShared = new TableColumn(this.threadsTable, 16384);
        tblclmnThreadShared.setWidth(72);
        tblclmnThreadShared.setText("Obj/Msg");
        this.tbtmTimers = new CTabItem(this.tabFolder, 0);
        this.tbtmTimers.setText("Timers");
        this.timersTable = new Table((Composite)this.tabFolder, 65536);
        this.timersTable.addFocusListener((FocusListener)this.focus);
        this.tbtmTimers.setControl((Control)this.timersTable);
        this.timersTable.setFont(SWTResourceManager.getFont("Courier New", 8, 0));
        this.timersTable.setHeaderVisible(true);
        TableColumn tblclmnTimerAddress = new TableColumn(this.timersTable, 131072);
        tblclmnTimerAddress.setWidth(72);
        tblclmnTimerAddress.setText("Address");
        TableColumn tblclmnTimerTime = new TableColumn(this.timersTable, 131072);
        tblclmnTimerTime.setWidth(72);
        tblclmnTimerTime.setText("Time");
        TableColumn tblclmnTimerDelta = new TableColumn(this.timersTable, 131072);
        tblclmnTimerDelta.setWidth(72);
        tblclmnTimerDelta.setText("Delta");
        TableColumn tblclmnTimerCallback = new TableColumn(this.timersTable, 131072);
        tblclmnTimerCallback.setWidth(72);
        tblclmnTimerCallback.setText("Callback");
        TableColumn tblclmnTimerParameter = new TableColumn(this.timersTable, 16384);
        tblclmnTimerParameter.setWidth(72);
        tblclmnTimerParameter.setText("Param");
        this.tbtmTraceBuffer = new CTabItem(this.tabFolder, 0);
        this.tbtmTraceBuffer.setText("TraceBuffer");
        this.tbTable = new Table((Composite)this.tabFolder, 65536);
        this.tbTable.addFocusListener((FocusListener)this.focus);
        this.tbTable.setFont(SWTResourceManager.getFont("Courier New", 8, 0));
        this.tbtmTraceBuffer.setControl((Control)this.tbTable);
        this.tbTable.setHeaderVisible(true);
        TableColumn tblclmnTraceBufferHidden = new TableColumn(this.tbTable, 131072);
        tblclmnTraceBufferHidden.setWidth(0);
        tblclmnTraceBufferHidden.setText("");
        TableColumn tblclmnTraceBufferIndex = new TableColumn(this.tbTable, 131072);
        tblclmnTraceBufferIndex.setWidth(48);
        tblclmnTraceBufferIndex.setText("Event");
        TableColumn tblclmnTraceBufferTime = new TableColumn(this.tbTable, 131072);
        tblclmnTraceBufferTime.setWidth(64);
        tblclmnTraceBufferTime.setText("Time");
        TableColumn tblclmnTraceBufferPrevAddress = new TableColumn(this.tbTable, 131072);
        tblclmnTraceBufferPrevAddress.setWidth(72);
        tblclmnTraceBufferPrevAddress.setText("Previous");
        TableColumn tblclmnTraceBufferPrevName = new TableColumn(this.tbTable, 16384);
        tblclmnTraceBufferPrevName.setWidth(144);
        tblclmnTraceBufferPrevName.setText("Previous Name");
        TableColumn tblclmnTraceBufferState = new TableColumn(this.tbTable, 131072);
        tblclmnTraceBufferState.setWidth(72);
        tblclmnTraceBufferState.setText("State");
        TableColumn tblclmnTraceBufferShared = new TableColumn(this.tbTable, 131072);
        tblclmnTraceBufferShared.setWidth(72);
        tblclmnTraceBufferShared.setText("Obj/Msg");
        TableColumn tblclmnTraceBufferCurrentAddress = new TableColumn(this.tbTable, 131072);
        tblclmnTraceBufferCurrentAddress.setWidth(72);
        tblclmnTraceBufferCurrentAddress.setText("Current");
        TableColumn tblclmnTraceBufferCurrentName = new TableColumn(this.tbTable, 16384);
        tblclmnTraceBufferCurrentName.setWidth(144);
        tblclmnTraceBufferCurrentName.setText("Current Name");
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.tabFolder.setSelection(this.tbtmGlobal);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        try {
            this.debugger = new DebugProxy();
        }
        catch (DebugProxyException debugProxyException) {}
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            switch (event.getKind()) {
                case 4: {
                    Object source = event.getSource();
                    if (!(source instanceof CDebugTarget)) break;
                    try {
                        this.debugger = new DebugProxy((CDebugTarget)source);
                        break;
                    }
                    catch (DebugProxyException debugProxyException) {}
                }
            }
            ++n2;
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ChibiView.this.fillContextMenu(manager);
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refreshAction);
    }

    private void fillGlobalTable() {
        LinkedHashMap<String, String> lhm;
        if (this.debugger == null) {
            return;
        }
        try {
            lhm = this.debugger.readGlobalVariables();
            if (lhm == null) {
                return;
            }
        }
        catch (DebugProxyException e) {
            this.showMessage("Error: " + e.getMessage() + ".");
            return;
        }
        this.globalTable.removeAll();
        Set<Map.Entry<String, String>> set = lhm.entrySet();
        for (Map.Entry<String, String> entry : set) {
            TableItem tableItem = new TableItem(this.globalTable, 0);
            tableItem.setText(new String[]{"", entry.getKey(), entry.getValue()});
        }
    }

    private String makeHex(String s) {
        try {
            s = HexUtils.dword2HexString((int)HexUtils.parseNumber(s));
        }
        catch (Exception exception) {}
        return s;
    }

    private void fillThreadsTable() {
        LinkedHashMap<String, HashMap<String, String>> lhm;
        if (this.debugger == null) {
            return;
        }
        try {
            lhm = this.debugger.readThreads();
            if (lhm == null) {
                return;
            }
        }
        catch (DebugProxyException e) {
            this.showMessage("Error: " + e.getMessage() + ".");
            return;
        }
        this.threadsTable.removeAll();
        Set<Map.Entry<String, HashMap<String, String>>> set = lhm.entrySet();
        for (Map.Entry<String, HashMap<String, String>> entry : set) {
            HashMap<String, String> map = entry.getValue();
            TableItem tableItem = new TableItem(this.threadsTable, 0);
            tableItem.setText(new String[]{this.makeHex(entry.getKey()), this.makeHex(map.get("stklimit")), this.makeHex(map.get("stack")), map.get("stkunused"), map.get("name"), map.get("state_s"), HexUtils.byte2HexString((int)HexUtils.parseNumber(map.get("flags"))), map.get("prio"), map.get("refs"), map.get("time"), this.makeHex(map.get("wtobjp"))});
        }
    }

    private void fillTimersTable() {
        LinkedHashMap<String, HashMap<String, String>> lhm;
        if (this.debugger == null) {
            return;
        }
        try {
            lhm = this.debugger.readTimers();
            if (lhm == null) {
                return;
            }
        }
        catch (DebugProxyException e) {
            this.showMessage("Error: " + e.getMessage() + ".");
            return;
        }
        this.timersTable.removeAll();
        Set<Map.Entry<String, HashMap<String, String>>> set = lhm.entrySet();
        long time = 0L;
        for (Map.Entry<String, HashMap<String, String>> entry : set) {
            HashMap<String, String> map = entry.getValue();
            TableItem tableItem = new TableItem(this.timersTable, 0);
            tableItem.setText(new String[]{this.makeHex(entry.getKey()), Long.toString(time += HexUtils.parseNumber(map.get("delta"))), "+" + HexUtils.parseNumber(map.get("delta")), this.makeHex(map.get("func")), this.makeHex(map.get("par"))});
        }
    }

    private void fillTraceBufferTable() {
        LinkedHashMap<String, HashMap<String, String>> lhm;
        LinkedHashMap<String, HashMap<String, String>> lhmthreads;
        if (this.debugger == null) {
            return;
        }
        try {
            lhmthreads = this.debugger.readThreads();
            if (lhmthreads == null) {
                return;
            }
        }
        catch (DebugProxyException debugProxyException) {
            lhmthreads = new LinkedHashMap(0);
        }
        try {
            lhm = this.debugger.readTraceBuffer();
            if (lhm == null) {
                return;
            }
        }
        catch (DebugProxyException e) {
            this.showMessage("Error: " + e.getMessage() + ".");
            return;
        }
        this.tbTable.removeAll();
        Set<Map.Entry<String, HashMap<String, String>>> set = lhm.entrySet();
        String prev = "";
        String prevname = "";
        for (Map.Entry<String, HashMap<String, String>> entry : set) {
            HashMap<String, String> map = entry.getValue();
            TableItem tableItem = new TableItem(this.tbTable, 0);
            String currentaddr = map.get("tp");
            HashMap<String, String> thread = lhmthreads.get(currentaddr);
            String currentname = thread != null ? thread.get("name") : "";
            String current = this.makeHex(currentaddr);
            tableItem.setText(new String[]{"", entry.getKey(), map.get("time"), prev, prevname, map.get("state_s"), this.makeHex(map.get("wtobjp")), current, currentname});
            prev = current;
            prevname = currentname;
        }
    }

    private void makeActions() {
        this.refreshAction = new Action(){

            public void run() {
                CTabItem tabitem = ChibiView.this.tabFolder.getSelection();
                if (tabitem == null) {
                    return;
                }
                if (tabitem == ChibiView.this.tbtmGlobal) {
                    ChibiView.this.fillGlobalTable();
                } else if (tabitem == ChibiView.this.tbtmThreads) {
                    ChibiView.this.fillThreadsTable();
                } else if (tabitem == ChibiView.this.tbtmTimers) {
                    ChibiView.this.fillTimersTable();
                } else if (tabitem == ChibiView.this.tbtmTraceBuffer) {
                    ChibiView.this.fillTraceBufferTable();
                }
            }
        };
        this.refreshAction.setDisabledImageDescriptor(ResourceManager.getPluginImageDescriptor("org.eclipse.cdt.ui", "/icons/dlcl16/refresh_nav.gif"));
        this.refreshAction.setImageDescriptor(ResourceManager.getPluginImageDescriptor("org.eclipse.cdt.ui", "/icons/elcl16/refresh_nav.gif"));
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh timers list");
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.tabFolder.getShell(), (String)"ChibiOS/RT Views", (String)message);
    }

    public void setFocus() {
        this.tabFolder.setFocus();
    }
}

