/*
 * Decompiled with CFR 0.152.
 */
package org.chibios.tools.eclipse.debug.utils;

public class HexUtils {
    protected static final String[] hexChars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public static boolean isHexChar(char c) {
        return Character.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static boolean isHexString(String hstring) {
        int l = hstring.length();
        if ((l & 1) == 1) {
            return false;
        }
        int i = 0;
        while (i < l) {
            if (!HexUtils.isHexChar(hstring.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] hexStringToByteArray(String hstring) {
        if (!HexUtils.isHexString(hstring)) {
            throw new NumberFormatException("not a hex string");
        }
        byte[] result = new byte[hstring.length() / 2];
        int i = 0;
        while (i < hstring.length()) {
            String toParse = hstring.substring(i, i + 2);
            result[i / 2] = (byte)Integer.parseInt(toParse, 16);
            i += 2;
        }
        return result;
    }

    public static byte hexStringToByte(String hstring) {
        if (hstring.length() != 2) {
            throw new NumberFormatException("not a byte hex string");
        }
        return (byte)Integer.parseInt(hstring, 16);
    }

    public static String byteArrayToHexString(byte[] data) {
        StringBuffer out = new StringBuffer(data.length * 2);
        int i = 0;
        while (i < data.length) {
            out.append(hexChars[data[i] >> 4 & 0xF]);
            out.append(hexChars[data[i] & 0xF]);
            ++i;
        }
        return out.toString();
    }

    public static String byte2HexString(int b) {
        return String.valueOf(hexChars[b >> 4 & 0xF]) + hexChars[b & 0xF];
    }

    public static String word2HexString(int w) {
        return String.valueOf(hexChars[w >> 12 & 0xF]) + hexChars[w >> 8 & 0xF] + hexChars[w >> 4 & 0xF] + hexChars[w & 0xF];
    }

    public static String dword2HexString(int w) {
        return String.valueOf(hexChars[w >> 28 & 0xF]) + hexChars[w >> 24 & 0xF] + hexChars[w >> 20 & 0xF] + hexChars[w >> 16 & 0xF] + hexChars[w >> 12 & 0xF] + hexChars[w >> 8 & 0xF] + hexChars[w >> 4 & 0xF] + hexChars[w & 0xF];
    }

    public static long parseNumber(String s) {
        if (s.toLowerCase().startsWith("0x")) {
            return Long.parseLong(s.substring(2), 16);
        }
        return Long.parseLong(s);
    }
}

