/*
 * Decompiled with CFR 0.152.
 */
package org.chibios.tools.eclipse.debug.utils;

import java.util.HashMap;
import java.util.LinkedHashMap;
import org.chibios.tools.eclipse.debug.utils.DebugProxyException;
import org.chibios.tools.eclipse.debug.utils.HexUtils;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataEvaluateExpression;
import org.eclipse.cdt.debug.mi.core.command.MIDataReadMemory;
import org.eclipse.cdt.debug.mi.core.output.MIDataEvaluateExpressionInfo;
import org.eclipse.cdt.debug.mi.core.output.MIDataReadMemoryInfo;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;

public class DebugProxy {
    private CommandFactory cmd_factory;
    private MISession mi_session;
    protected static final String[] threadStates = new String[]{"READY", "CURRENT", "SUSPENDED", "WTSEM", "WTMTX", "WTCOND", "SLEEPING", "WTEXIT", "WTOREVT", "WTANDEVT", "SNDMSGQ", "SNDMSG", "WTMSG", "WTQUEUE", "FINAL"};

    private void getSession(CDebugTarget target) throws DebugProxyException {
        ICDITarget[] targets = target.getCDISession().getTargets();
        ICDITarget cdi_target = null;
        int i = 0;
        while (i < targets.length) {
            if (targets[i] instanceof Target) {
                cdi_target = targets[i];
                break;
            }
            ++i;
        }
        if (cdi_target == null) {
            throw new DebugProxyException("no CDI session found");
        }
        this.mi_session = ((Target)cdi_target).getMISession();
        this.cmd_factory = this.mi_session.getCommandFactory();
    }

    public DebugProxy() throws DebugProxyException {
        IDebugTarget[] targets;
        IDebugTarget[] iDebugTargetArray = targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget target = iDebugTargetArray[n2];
            if (target instanceof CDebugTarget) {
                this.getSession((CDebugTarget)target);
                return;
            }
            ++n2;
        }
    }

    public DebugProxy(CDebugTarget target) throws DebugProxyException {
        this.getSession(target);
    }

    public String evaluateExpression(String expression) throws DebugProxyException {
        if (this.mi_session.getMIInferior().isRunning()) {
            return null;
        }
        MIDataEvaluateExpression expr = this.cmd_factory.createMIDataEvaluateExpression(expression);
        try {
            this.mi_session.postCommand((Command)expr);
            MIDataEvaluateExpressionInfo info = expr.getMIDataEvaluateExpressionInfo();
            if (info != null) {
                return info.getExpression();
            }
        }
        catch (MIException mIException) {}
        throw new DebugProxyException("error evaluating the expression: '" + expression + "'");
    }

    public long scanStack(long base, long end, long pattern) throws DebugProxyException {
        if (this.mi_session.getMIInferior().isRunning()) {
            return -1L;
        }
        if (end > base) {
            MIDataReadMemory mem = this.cmd_factory.createMIDataReadMemory(0L, Long.toString(base), 0, 4, 1, (int)(end - base), Character.valueOf('.'));
            try {
                this.mi_session.postCommand((Command)mem);
                MIDataReadMemoryInfo info = mem.getMIDataReadMemoryInfo();
                if (info != null) {
                    long[] data = info.getMemories()[0].getData();
                    int i = 0;
                    while (i < data.length && data[i] == pattern) {
                        ++i;
                    }
                    return i * 4;
                }
            }
            catch (MIException mIException) {}
            throw new DebugProxyException("error reading memory at " + base);
        }
        return 0L;
    }

    public String readCString(long address, int max) throws DebugProxyException {
        if (this.mi_session.getMIInferior().isRunning()) {
            return null;
        }
        MIDataReadMemory mem = this.cmd_factory.createMIDataReadMemory(0L, Long.toString(address), 0, 1, 1, max, Character.valueOf('.'));
        try {
            this.mi_session.postCommand((Command)mem);
            MIDataReadMemoryInfo info = mem.getMIDataReadMemoryInfo();
            if (info != null) {
                String s = info.getMemories()[0].getAscii();
                int i = s.indexOf(46);
                if (i >= 0) {
                    return s.substring(0, s.indexOf(46));
                }
                return s;
            }
        }
        catch (MIException mIException) {}
        throw new DebugProxyException("error reading memory at " + address);
    }

    public LinkedHashMap<String, HashMap<String, String>> readThreads() throws DebugProxyException {
        String rlist;
        try {
            rlist = this.evaluateExpression("(uint32_t)&rlist");
            if (rlist == null) {
                return null;
            }
        }
        catch (DebugProxyException debugProxyException) {
            throw new DebugProxyException("ChibiOS/RT not found on target");
        }
        catch (Exception exception) {
            return null;
        }
        LinkedHashMap<String, HashMap<String, String>> lhm = new LinkedHashMap<String, HashMap<String, String>>(10);
        String current = rlist;
        String previous = rlist;
        while (true) {
            long n;
            long stack;
            long stklimit;
            try {
                current = this.evaluateExpression("(uint32_t)((Thread *)" + current + ")->p_newer");
            }
            catch (DebugProxyException debugProxyException) {
                throw new DebugProxyException("ChibiOS/RT registry not enabled in kernel");
            }
            if (current.compareTo("0") == 0) {
                throw new DebugProxyException("ChibiOS/RT registry integrity check failed, NULL pointer");
            }
            String older = this.evaluateExpression("(uint32_t)((Thread *)" + current + ")->p_older");
            if (older.compareTo("0") == 0) {
                throw new DebugProxyException("ChibiOS/RT registry integrity check failed, NULL pointer");
            }
            if (previous.compareTo(older) != 0) {
                throw new DebugProxyException("ChibiOS/RT registry integrity check failed, double linked list violation");
            }
            if (current.compareTo(rlist) == 0) break;
            HashMap<String, String> map = new HashMap<String, String>(16);
            try {
                stklimit = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)((Thread *)" + current + ")->p_stklimit"));
                map.put("stklimit", Long.toString(stklimit));
            }
            catch (DebugProxyException debugProxyException) {
                map.put("stklimit", "-");
                stklimit = -1L;
            }
            try {
                stack = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)((Thread *)" + current + ")->p_ctx.r13"));
                map.put("stack", Long.toString(stack));
            }
            catch (DebugProxyException debugProxyException) {
                try {
                    stack = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)((Thread *)" + current + ")->p_ctx.sp"));
                    map.put("stack", Long.toString(stack));
                }
                catch (DebugProxyException debugProxyException2) {
                    map.put("stack", "-");
                    stack = -1L;
                }
            }
            if (stklimit < 0L || stack < 0L) {
                map.put("stkunused", "-");
            } else if (stack < 0L || stack < stklimit) {
                map.put("stkunused", "overflow");
            } else {
                long stkunused = this.scanStack(stklimit, stack, 0x55555555L);
                map.put("stkunused", Long.toString(stkunused));
            }
            try {
                n = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)((Thread *)" + current + ")->p_name"));
                if (n == 0L) {
                    map.put("name", "<no name>");
                } else {
                    map.put("name", this.readCString(n, 16));
                }
            }
            catch (DebugProxyException debugProxyException) {
                map.put("name", "-");
            }
            n = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)((Thread *)" + current + ")->p_state"));
            map.put("state", Long.toString(n));
            if (n >= 0L && n < (long)threadStates.length) {
                map.put("state_s", threadStates[(int)n]);
            } else {
                map.put("state_s", "unknown");
            }
            n = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)((Thread *)" + current + ")->p_flags"));
            map.put("flags", Long.toString(n));
            n = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)((Thread *)" + current + ")->p_prio"));
            map.put("prio", Long.toString(n));
            try {
                n = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)((Thread *)" + current + ")->p_refs"));
                map.put("refs", Long.toString(n));
            }
            catch (DebugProxyException debugProxyException) {
                map.put("refs", "-");
            }
            try {
                n = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)((Thread *)" + current + ")->p_time"));
                map.put("time", Long.toString(n));
            }
            catch (DebugProxyException debugProxyException) {
                map.put("time", "-");
            }
            try {
                n = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)((Thread *)" + current + ")->p_u.wtobjp"));
                map.put("wtobjp", Long.toString(n));
            }
            catch (DebugProxyException debugProxyException) {
                map.put("wtobjp", "-");
            }
            lhm.put(current, map);
            previous = current;
        }
        return lhm;
    }

    public LinkedHashMap<String, HashMap<String, String>> readTimers() throws DebugProxyException {
        String vtlist;
        try {
            vtlist = this.evaluateExpression("(uint32_t)&vtlist");
            if (vtlist == null) {
                return null;
            }
        }
        catch (DebugProxyException debugProxyException) {
            throw new DebugProxyException("ChibiOS/RT not found on target");
        }
        catch (Exception exception) {
            return null;
        }
        LinkedHashMap<String, HashMap<String, String>> lhm = new LinkedHashMap<String, HashMap<String, String>>(10);
        String current = vtlist;
        String previous = vtlist;
        while (true) {
            if ((current = this.evaluateExpression("(uint32_t)((VirtualTimer *)" + current + ")->vt_next")).compareTo("0") == 0) {
                throw new DebugProxyException("ChibiOS/RT delta list integrity check failed, NULL pointer");
            }
            String prev = this.evaluateExpression("(uint32_t)((VirtualTimer *)" + current + ")->vt_prev");
            if (prev.compareTo("0") == 0) {
                throw new DebugProxyException("ChibiOS/RT delta list integrity check failed, NULL pointer");
            }
            if (previous.compareTo(prev) != 0) {
                throw new DebugProxyException("ChibiOS/RT delta list integrity check failed, double linked list violation");
            }
            if (current.compareTo(vtlist) == 0) break;
            HashMap<String, String> map = new HashMap<String, String>(16);
            long n = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)((VirtualTimer *)" + current + ")->vt_time"));
            map.put("delta", Long.toString(n));
            n = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)((VirtualTimer *)" + current + ")->vt_func"));
            map.put("func", Long.toString(n));
            n = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)((VirtualTimer *)" + current + ")->vt_par"));
            map.put("par", Long.toString(n));
            lhm.put(current, map);
            previous = current;
        }
        return lhm;
    }

    public LinkedHashMap<String, HashMap<String, String>> readTraceBuffer() throws DebugProxyException {
        String s;
        try {
            s = this.evaluateExpression("(uint32_t)dbg_trace_buffer.tb_size");
            if (s == null) {
                return null;
            }
        }
        catch (DebugProxyException debugProxyException) {
            throw new DebugProxyException("trace buffer not found on target");
        }
        catch (Exception exception) {
            return null;
        }
        int tbsize = (int)HexUtils.parseNumber(s);
        int tbrecsize = (int)HexUtils.parseNumber(this.evaluateExpression("(uint32_t)sizeof (ch_swc_event_t)"));
        long tbstart = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)dbg_trace_buffer.tb_buffer"));
        long tbend = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)&dbg_trace_buffer.tb_buffer[" + tbsize + "]"));
        long tbptr = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)dbg_trace_buffer.tb_ptr"));
        LinkedHashMap<String, HashMap<String, String>> lhm = new LinkedHashMap<String, HashMap<String, String>>(64);
        int n = tbsize;
        int i = -tbsize + 1;
        while (n > 0) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            String time = this.evaluateExpression("(uint32_t)(((ch_swc_event_t *)" + tbptr + ")->se_time)");
            map.put("time", time);
            String tp = this.evaluateExpression("(uint32_t)(((ch_swc_event_t *)" + tbptr + ")->se_tp)");
            map.put("tp", tp);
            String wtobjp = this.evaluateExpression("(uint32_t)(((ch_swc_event_t *)" + tbptr + ")->se_wtobjp)");
            map.put("wtobjp", wtobjp);
            long state = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)(((ch_swc_event_t *)" + tbptr + ")->se_state)"));
            map.put("state", Long.toString(state));
            if (state >= 0L && state < (long)threadStates.length) {
                map.put("state_s", threadStates[(int)state]);
            } else {
                map.put("state_s", "unknown");
            }
            if (tp.compareTo("0") != 0) {
                lhm.put(Integer.toString(i), map);
            }
            if ((tbptr += (long)tbrecsize) >= tbend) {
                tbptr = tbstart;
            }
            --n;
            ++i;
        }
        return lhm;
    }

    public LinkedHashMap<String, String> readGlobalVariables() throws DebugProxyException {
        LinkedHashMap<String, String> map;
        block24: {
            String vt_systime;
            block23: {
                map = new LinkedHashMap<String, String>(16);
                vt_systime = this.evaluateExpression("(uint32_t)vtlist.vt_systime");
                if (vt_systime != null) break block23;
                return null;
            }
            try {
                map.put("vt_systime", vt_systime);
            }
            catch (DebugProxyException debugProxyException) {
                throw new DebugProxyException("ChibiOS/RT not found on target");
            }
            catch (Exception exception) {
                return null;
            }
            try {
                long r_current = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)rlist.r_current"));
                if (r_current != 0L) {
                    String name;
                    try {
                        long n = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)((Thread *)" + r_current + ")->p_name"));
                        name = n == 0L ? "<no name>" : this.readCString(n, 16);
                    }
                    catch (DebugProxyException debugProxyException) {
                        name = "-";
                    }
                    map.put("r_current", String.valueOf(HexUtils.dword2HexString((int)r_current)) + " \"" + name + "\"");
                    break block24;
                }
                map.put("r_current", "0");
            }
            catch (DebugProxyException debugProxyException) {}
        }
        try {
            String r_preempt = this.evaluateExpression("(uint32_t)rlist.r_preempt");
            map.put("r_preempt", r_preempt);
        }
        catch (DebugProxyException debugProxyException) {}
        try {
            Long addr = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)dbg_panic_msg"));
            if (addr == 0L) {
                map.put("dbg_panic_msg", "<NULL>");
            } else {
                map.put("dbg_panic_msg", this.readCString(addr, 32));
            }
        }
        catch (DebugProxyException debugProxyException) {
            map.put("dbg_panic_msg", "<not enabled>");
        }
        try {
            Long isr_cnt = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)dbg_isr_cnt"));
            if (isr_cnt == 0L) {
                map.put("dbg_isr_cnt", "not within ISR");
            } else {
                map.put("dbg_isr_cnt", "within ISR");
            }
        }
        catch (DebugProxyException debugProxyException) {
            map.put("dbg_isr_cnt", "<not enabled>");
        }
        try {
            Long lock_cnt = HexUtils.parseNumber(this.evaluateExpression("(uint32_t)dbg_lock_cnt"));
            if (lock_cnt == 0L) {
                map.put("dbg_lock_cnt", "not within lock");
            } else {
                map.put("dbg_lock_cnt", "within lock");
            }
        }
        catch (DebugProxyException debugProxyException) {
            map.put("dbg_lock_cnt", "<not enabled>");
        }
        return map;
    }
}

