/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.net.Proxy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class TaskRepositoryLocation
extends AbstractWebLocation {
    protected final TaskRepository taskRepository;

    public TaskRepositoryLocation(TaskRepository taskRepository) {
        super(taskRepository.getRepositoryUrl());
        this.taskRepository = taskRepository;
    }

    public Proxy getProxyForHost(String host, String proxyType) {
        if (!this.taskRepository.isDefaultProxyEnabled()) {
            String proxyHost = this.taskRepository.getProperty("org.eclipse.mylyn.tasklist.repositories.proxy.hostname");
            String proxyPort = this.taskRepository.getProperty("org.eclipse.mylyn.tasklist.repositories.proxy.port");
            if (proxyHost != null && proxyHost.length() > 0 && proxyPort != null) {
                try {
                    int proxyPortNum = Integer.parseInt(proxyPort);
                    AuthenticationCredentials credentials = this.taskRepository.getCredentials(AuthenticationType.PROXY);
                    return WebUtil.createProxy((String)proxyHost, (int)proxyPortNum, (AuthenticationCredentials)credentials);
                }
                catch (NumberFormatException e) {
                    StatusHandler.log((IStatus)new RepositoryStatus(this.taskRepository, 4, "org.eclipse.mylyn.tasks.core", 0, "Error occured while configuring proxy. Invalid port \"" + proxyPort + "\" specified.", (Throwable)e));
                }
            }
        }
        return WebUtil.getProxy((String)host, (String)proxyType);
    }

    public AuthenticationCredentials getCredentials(AuthenticationType type) {
        return this.taskRepository.getCredentials(type);
    }
}

