/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.math.BigInteger;
import org.eclipse.cdt.dsf.debug.service.AbstractInstruction;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MIInstruction
extends AbstractInstruction {
    BigInteger address;
    String function = "";
    long offset;
    String opcode = "";
    String args = "";

    public MIInstruction(MITuple tuple) {
        this.parse(tuple);
    }

    public BigInteger getAdress() {
        return this.address;
    }

    public String getFuntionName() {
        return this.function;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getInstruction() {
        return String.valueOf(this.opcode) + " " + this.args;
    }

    public String getOpcode() {
        return this.opcode;
    }

    public String getArgs() {
        return this.args;
    }

    private void parse(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getCString();
            }
            if (var.equals("address")) {
                try {
                    this.address = MIInstruction.decodeAddress(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("func-name")) {
                this.function = str;
            } else if (var.equals("offset")) {
                try {
                    this.offset = Long.decode(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("inst")) {
                str = ((MIConst)value).getString();
                str = str.replace("\\t", "\t");
                char[] chars = str.toCharArray();
                int index = 0;
                while (index < chars.length && chars[index] > ' ') {
                    ++index;
                }
                this.opcode = str.substring(0, index);
                while (index < chars.length && chars[index] >= '\u0000' && chars[index] <= ' ') {
                    ++index;
                }
                if (index < chars.length) {
                    this.args = str.substring(index);
                }
            }
            ++i;
        }
    }

    private static BigInteger decodeAddress(String string) {
        if (string.startsWith("0x")) {
            return new BigInteger(string.substring(2), 16);
        }
        return new BigInteger(string);
    }
}

