/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.remote.launching;

import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.GDBServerCDIDebugger2;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.internal.launch.remote.Messages;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.cdt.launch.remote.RSEHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.services.shells.HostShellProcessAdapter;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.services.shells.IHostShellOutputListener;

public class RemoteRunLaunchDelegate
extends AbstractCLaunchDelegate {
    private ICDISession dsession;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IBinaryParser.IBinaryObject exeFile = null;
        IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
        ICProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
        if (exePath == null) return;
        exeFile = this.verifyBinary(project, exePath);
        String arguments = this.getProgramArguments(config);
        String remoteExePath = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, "");
        String prelaunchCmd = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_PRERUN_COMMANDS, "");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!RSECorePlugin.isInitComplete((int)1)) {
            monitor.subTask(Messages.RemoteRunLaunchDelegate_10);
            try {
                RSECorePlugin.waitForInitCompletion((int)1);
            }
            catch (InterruptedException e) {
                throw new CoreException((IStatus)new Status(4, this.getPluginID(), 0, e.getLocalizedMessage(), (Throwable)e));
            }
        }
        if (mode.equals("debug")) {
            monitor.beginTask(Messages.RemoteRunLaunchDelegate_0, 100);
            this.setDefaultSourceLocator(launch, config);
            String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            if (!debugMode.equals("run")) return;
            Process remoteShellProcess = null;
            this.dsession = null;
            try {
                try {
                    monitor.setTaskName(Messages.RemoteRunLaunchDelegate_2);
                    RSEHelper.remoteFileDownload(config, launch, exePath.toString(), remoteExePath, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                    String gdbserver_port_number = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_PORT, "2345");
                    String gdbserver_command = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_COMMAND, "gdbserver");
                    String command_arguments = ":" + gdbserver_port_number + " " + RSEHelper.spaceEscapify(remoteExePath);
                    if (arguments != null && !arguments.equals("")) {
                        command_arguments = String.valueOf(command_arguments) + " " + arguments;
                    }
                    monitor.setTaskName(Messages.RemoteRunLaunchDelegate_9);
                    IHostShell remoteShell = null;
                    try {
                        remoteShell = RSEHelper.execCmdInRemoteShell(config, prelaunchCmd, gdbserver_command, command_arguments, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                    }
                    catch (Exception e1) {
                        RSEHelper.abort(e1.getMessage(), e1, 150);
                    }
                    final boolean[] gdbServerReady = new boolean[]{false};
                    final Object lock = new Object();
                    if (remoteShell == null) return;
                    remoteShell.addOutputListener(new IHostShellOutputListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void shellOutputChanged(IHostShellChangeEvent event) {
                            IHostOutput[] iHostOutputArray = event.getLines();
                            int n = iHostOutputArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IHostOutput line = iHostOutputArray[n2];
                                if (line.getString().contains("Listening on port")) {
                                    Object object = lock;
                                    synchronized (object) {
                                        gdbServerReady[0] = true;
                                        lock.notifyAll();
                                        break;
                                    }
                                }
                                ++n2;
                            }
                        }
                    });
                    try {
                        remoteShellProcess = new HostShellProcessAdapter(remoteShell){

                            public synchronized void destroy() {
                                ICDISession session = RemoteRunLaunchDelegate.this.getSession();
                                if (session != null) {
                                    try {
                                        session.terminate();
                                    }
                                    catch (CDIException cDIException) {}
                                }
                                super.destroy();
                            }
                        };
                    }
                    catch (Exception e) {
                        if (remoteShellProcess != null) {
                            remoteShellProcess.destroy();
                        }
                        RSEHelper.abort(Messages.RemoteRunLaunchDelegate_7, e, 150);
                    }
                    IProcess rsProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)remoteShellProcess, (String)Messages.RemoteRunLaunchDelegate_RemoteShell);
                    Object object = lock;
                    synchronized (object) {
                        while (!gdbServerReady[0]) {
                            if (monitor.isCanceled() || rsProcess.isTerminated()) {
                                RSEHelper.abort(Messages.RemoteGdbLaunchDelegate_gdbserverFailedToStartErrorMessage, null, 106);
                            }
                            try {
                                lock.wait(300L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                    wc.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, true);
                    wc.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, RSEHelper.getRemoteHostname(config));
                    wc.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, gdbserver_port_number);
                    wc.doSave();
                    GDBServerCDIDebugger2 debugger = new GDBServerCDIDebugger2();
                    this.dsession = debugger.createSession(launch, exePath.toFile(), (IProgressMonitor)new SubProgressMonitor(monitor, 15));
                    boolean stopInMain = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
                    String stopSymbol = null;
                    if (stopInMain) {
                        stopSymbol = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
                    }
                    ICDITarget[] targets = this.dsession.getTargets();
                    int i = 0;
                    while (true) {
                        if (i >= targets.length) {
                            return;
                        }
                        Process process = targets[i].getProcess();
                        IProcess iprocess = null;
                        if (process != null) {
                            iprocess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()), (Map)this.getDefaultProcessMap());
                        }
                        CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)project.getProject(), (ICDITarget)targets[i], (String)this.renderProcessLabel("gdbserver debugger"), (IProcess)iprocess, (IBinaryParser.IBinaryObject)exeFile, (boolean)true, (boolean)false, (String)stopSymbol, (boolean)true);
                        ++i;
                    }
                }
                catch (CoreException e) {
                    try {
                        if (this.dsession != null) {
                            this.dsession.terminate();
                        }
                        if (remoteShellProcess == null) throw e;
                        remoteShellProcess.destroy();
                        throw e;
                    }
                    catch (CDIException cDIException) {}
                    throw e;
                }
            }
            finally {
                monitor.done();
            }
        }
        if (!mode.equals("run")) {
            Status status = new Status(4, this.getPluginID(), 0, NLS.bind((String)Messages.RemoteRunLaunchDelegate_1, (Object)mode), null);
            throw new CoreException((IStatus)status);
        }
        monitor.beginTask(Messages.RemoteRunLaunchDelegate_0, 100);
        Process remoteProcess = null;
        try {
            monitor.setTaskName(Messages.RemoteRunLaunchDelegate_2);
            RSEHelper.remoteFileDownload(config, launch, exePath.toString(), remoteExePath, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
            monitor.setTaskName(Messages.RemoteRunLaunchDelegate_12);
            remoteProcess = RSEHelper.remoteShellExec(config, prelaunchCmd, remoteExePath, arguments, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            DebugPlugin.newProcess((ILaunch)launch, (Process)remoteProcess, (String)this.renderProcessLabel(exePath.toOSString()));
            return;
        }
        finally {
            monitor.done();
        }
    }

    protected String getPluginID() {
        return "org.eclipse.cdt.launch.remote";
    }

    ICDISession getSession() {
        return this.dsession;
    }
}

