/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.synchronize.GitResourceVariantTreeSubscriber;
import org.eclipse.egit.core.synchronize.GitSubscriberMergeContext;
import org.eclipse.egit.core.synchronize.GitSubscriberResourceMappingContext;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.synchronize.GitActionContributor;
import org.eclipse.egit.ui.internal.synchronize.GitChangeSetModelProvider;
import org.eclipse.egit.ui.internal.synchronize.GitTreeCompareNavigator;
import org.eclipse.egit.ui.internal.synchronize.SynchronizeFetchJob;
import org.eclipse.egit.ui.internal.synchronize.compare.ComparisonDataSource;
import org.eclipse.egit.ui.internal.synchronize.compare.GitCompareInput;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitModelSynchronizeParticipant
extends ModelSynchronizeParticipant {
    public static final String SYNCHRONIZATION_DATA = "GIT_SYNCHRONIZE_DATA_SET";
    public static final String ID = "org.eclipse.egit.ui.modelCompareParticipant";
    public static final String VIEWER_ID = "org.eclipse.egit.ui.compareSynchronization";
    private static final String P_NAVIGATOR = "org.eclipse.team.ui.P_NAVIGATOR";
    private static final String WORKSPACE_MODEL_PROVIDER_ID = "org.eclipse.core.resources.modelProvider";
    private static final String DATA_NODE_KEY = "gitSynchronizeData";
    private static final String INCLUDED_PATHS_NODE_KEY = "includedPaths";
    private static final String INCLUDED_PATH_KEY = "path";
    private static final String CONTAINER_PATH_KEY = "container";
    private static final String SRC_REV_KEY = "srcRev";
    private static final String DST_REV_KEY = "dstRev";
    private static final String INCLUDE_LOCAL_KEY = "inludeLocal";
    private static final String FORCE_FETCH_KEY = "forceFetch";
    private GitSynchronizeDataSet gsds;

    public GitModelSynchronizeParticipant() {
    }

    public GitModelSynchronizeParticipant(GitSubscriberMergeContext context) {
        super((SynchronizationContext)context);
        this.gsds = context.getSyncData();
        try {
            this.setInitializationData(TeamUI.getSynchronizeManager().getParticipantDescriptor(ID));
        }
        catch (CoreException e) {
            Activator.logError(e.getMessage(), e);
        }
        this.setSecondaryId(Long.toString(System.currentTimeMillis()));
    }

    protected void initializeConfiguration(final ISynchronizePageConfiguration configuration) {
        configuration.setProperty("org.eclipse.team.ui.P_VIEWER_ID", (Object)VIEWER_ID);
        String modelProvider = WORKSPACE_MODEL_PROVIDER_ID;
        final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        if (!this.gsds.containsFolderLevelSynchronizationRequest()) {
            if (preferenceStore.getBoolean("sync_view_show_changeset_model")) {
                modelProvider = "org.eclipse.egit.ui.changeSetModel";
            } else {
                String lastSelectedModel = preferenceStore.getString("sync_view_last_selected_model");
                if (!"".equals(lastSelectedModel)) {
                    modelProvider = lastSelectedModel;
                }
            }
        }
        configuration.setProperty("org.eclipse.team.ui.activeModelProvider", (Object)modelProvider);
        configuration.setProperty(SYNCHRONIZATION_DATA, (Object)this.gsds);
        super.initializeConfiguration(configuration);
        configuration.addActionContribution((SynchronizePageActionGroup)new GitActionContributor());
        configuration.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Object oldNavigator;
                String property = event.getProperty();
                if (property.equals("org.eclipse.team.ui.activeModelProvider")) {
                    String newValue = (String)event.getNewValue();
                    preferenceStore.setValue("sync_view_last_selected_model", newValue);
                } else if (property.equals(GitModelSynchronizeParticipant.P_NAVIGATOR) && !((oldNavigator = configuration.getProperty(GitModelSynchronizeParticipant.P_NAVIGATOR)) instanceof GitTreeCompareNavigator)) {
                    configuration.setProperty(GitModelSynchronizeParticipant.P_NAVIGATOR, (Object)new GitTreeCompareNavigator((CompareNavigator)oldNavigator));
                }
            }
        });
    }

    public ModelProvider[] getEnabledModelProviders() {
        ModelProvider[] avaliableProviders;
        ModelProvider[] modelProviderArray = avaliableProviders = super.getEnabledModelProviders();
        int n = avaliableProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ModelProvider provider = modelProviderArray[n2];
            if (provider.getId().equals("org.eclipse.egit.ui.changeSetModel")) {
                return avaliableProviders;
            }
            ++n2;
        }
        int capacity = avaliableProviders.length + 1;
        ArrayList<GitChangeSetModelProvider> providers = new ArrayList<GitChangeSetModelProvider>(capacity);
        providers.add(GitChangeSetModelProvider.getProvider());
        return providers.toArray(new ModelProvider[providers.size()]);
    }

    public boolean hasCompareInputFor(Object object) {
        IResource res;
        if (object instanceof GitModelBlob || object instanceof IFile) {
            return true;
        }
        if (object instanceof IAdaptable && (res = (IResource)((IAdaptable)object).getAdapter(IResource.class)) != null && res.getType() == 1) {
            return true;
        }
        return super.hasCompareInputFor(object);
    }

    public ICompareInput asCompareInput(Object object) {
        IFile file;
        GitSynchronizeData gsd;
        if (object instanceof IFile && (gsd = this.gsds.getData((file = (IFile)object).getProject())) != null && !gsd.shouldIncludeLocal()) {
            return this.getFileFromGit(gsd, file.getLocation());
        }
        return super.asCompareInput(object);
    }

    public void run(final IWorkbenchPart part) {
        boolean launchFetch = Activator.getDefault().getPreferenceStore().getBoolean("sync_view_fetch_before_launch");
        if (launchFetch || this.gsds.forceFetch()) {
            SynchronizeFetchJob fetchJob = new SynchronizeFetchJob(this.gsds);
            fetchJob.setUser(true);
            fetchJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    GitModelSynchronizeParticipant.super.run(part);
                }
            });
            fetchJob.schedule();
        } else {
            super.run(part);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        for (GitSynchronizeData gsd : this.gsds) {
            Repository repo = gsd.getRepository();
            RepositoryMapping mapping = RepositoryMapping.findRepositoryMapping((Repository)repo);
            if (mapping == null) continue;
            IMemento child = memento.createChild(DATA_NODE_KEY);
            child.putString(CONTAINER_PATH_KEY, this.getPathForContainer(mapping.getContainer()));
            child.putString(SRC_REV_KEY, gsd.getSrcRev());
            child.putString(DST_REV_KEY, gsd.getDstRev());
            child.putBoolean(INCLUDE_LOCAL_KEY, gsd.shouldIncludeLocal());
            Set includedPaths = gsd.getIncludedPaths();
            if (includedPaths == null || includedPaths.isEmpty()) continue;
            IMemento paths = child.createChild(INCLUDED_PATHS_NODE_KEY);
            for (IContainer container : includedPaths) {
                String path = this.getPathForContainer(container);
                paths.createChild(INCLUDED_PATH_KEY).putString(INCLUDED_PATH_KEY, path);
            }
        }
        memento.putBoolean(FORCE_FETCH_KEY, this.gsds.forceFetch());
    }

    public void init(String secondaryId, IMemento memento) throws PartInitException {
        try {
            boolean forceFetchPref = Activator.getDefault().getPreferenceStore().getBoolean("sync_view_fetch_before_launch");
            boolean forceFetch = this.getBoolean(memento.getBoolean(FORCE_FETCH_KEY), forceFetchPref);
            this.gsds = new GitSynchronizeDataSet(forceFetch);
            IMemento[] children = memento.getChildren(DATA_NODE_KEY);
            if (children != null) {
                this.restoreSynchronizationData(children);
            }
        }
        finally {
            super.init(secondaryId, memento);
        }
    }

    protected MergeContext restoreContext(ISynchronizationScopeManager manager) throws CoreException {
        GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(this.gsds);
        subscriber.init((IProgressMonitor)new NullProgressMonitor());
        return new GitSubscriberMergeContext(subscriber, manager, this.gsds);
    }

    protected ISynchronizationScopeManager createScopeManager(ResourceMapping[] mappings) {
        GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(this.gsds);
        subscriber.init((IProgressMonitor)new NullProgressMonitor());
        GitSubscriberResourceMappingContext context = new GitSubscriberResourceMappingContext(subscriber, this.gsds);
        return new SynchronizationScopeManager(UIText.GitModelSynchronizeParticipant_initialScopeName, mappings, (ResourceMappingContext)context, true);
    }

    private ICompareInput getFileFromGit(GitSynchronizeData gsd, IPath location) {
        Repository repo = gsd.getRepository();
        File workTree = repo.getWorkTree();
        String repoRelativeLocation = Repository.stripWorkDir((File)workTree, (File)location.toFile());
        TreeWalk tw = new TreeWalk(repo);
        tw.setRecursive(true);
        tw.setFilter((TreeFilter)PathFilter.create((String)repoRelativeLocation.toString()));
        RevCommit baseCommit = gsd.getSrcRevCommit();
        RevCommit remoteCommit = gsd.getDstRevCommit();
        try {
            int baseNth = tw.addTree((AnyObjectId)baseCommit.getTree());
            int remoteNth = tw.addTree((AnyObjectId)remoteCommit.getTree());
            if (tw.next()) {
                ComparisonDataSource baseData = new ComparisonDataSource(baseCommit, tw.getObjectId(baseNth));
                ComparisonDataSource remoteData = new ComparisonDataSource(remoteCommit, tw.getObjectId(remoteNth));
                return new GitCompareInput(repo, baseData, baseData, remoteData, repoRelativeLocation);
            }
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
        }
        return null;
    }

    private void restoreSynchronizationData(IMemento[] children) {
        IMemento[] iMementoArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            String containerPath = child.getString(CONTAINER_PATH_KEY);
            Repository repo = this.getRepositoryForPath(containerPath);
            if (repo != null) {
                String srcRev = child.getString(SRC_REV_KEY);
                String dstRev = child.getString(DST_REV_KEY);
                boolean includeLocal = this.getBoolean(child.getBoolean(INCLUDE_LOCAL_KEY), true);
                Set<IContainer> includedPaths = this.getIncludedPaths(child);
                try {
                    GitSynchronizeData data = new GitSynchronizeData(repo, srcRev, dstRev, includeLocal);
                    if (includedPaths != null) {
                        data.setIncludedPaths(includedPaths);
                    }
                    this.gsds.add(data);
                }
                catch (IOException e) {
                    Activator.logError(e.getMessage(), e);
                }
            }
            ++n2;
        }
    }

    private Repository getRepositoryForPath(String containerPath) {
        IPath path = Path.fromPortableString((String)containerPath);
        IContainer mappedContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path);
        GitProjectData projectData = GitProjectData.get((IProject)((IProject)mappedContainer));
        RepositoryMapping mapping = projectData.getRepositoryMapping((IResource)mappedContainer);
        if (mapping != null) {
            return mapping.getRepository();
        }
        return null;
    }

    private boolean getBoolean(Boolean value, boolean defaultValue) {
        return value != null ? value : defaultValue;
    }

    private String getPathForContainer(IContainer container) {
        return container.getLocation().toPortableString();
    }

    private Set<IContainer> getIncludedPaths(IMemento memento) {
        IMemento[] pathNode;
        IMemento child = memento.getChild(INCLUDED_PATHS_NODE_KEY);
        HashSet<IContainer> result = new HashSet<IContainer>();
        if (child != null && (pathNode = child.getChildren(INCLUDED_PATH_KEY)) != null) {
            IMemento[] iMementoArray = pathNode;
            int n = pathNode.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento path = iMementoArray[n2];
                String includedPath = path.getString(INCLUDED_PATH_KEY);
                IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(includedPath));
                result.add(container);
                ++n2;
            }
            return result;
        }
        return null;
    }
}

