/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.synchronize.GitResourceVariantTreeSubscriber;
import org.eclipse.egit.core.synchronize.GitSubscriberMergeContext;
import org.eclipse.egit.core.synchronize.GitSubscriberResourceMappingContext;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.synchronize.GitModelSynchronizeParticipant;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GitModelSynchronize {
    private static final String providerId = "org.eclipse.egit.core.GitProvider";

    public static final void launch(GitSynchronizeData data, IResource[] resources) {
        GitModelSynchronize.launch(new GitSynchronizeDataSet(data), resources);
    }

    public static final void launch(GitSynchronizeDataSet gsdSet, IResource[] resources) {
        ResourceMapping[] mappings = GitModelSynchronize.getSelectedResourceMappings(resources);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        GitModelSynchronize.fireSynchronizeAction(window, gsdSet, mappings);
    }

    private static ResourceMapping[] getSelectedResourceMappings(IResource[] elements) {
        ArrayList<ResourceMapping> providerMappings = new ArrayList<ResourceMapping>();
        IResource[] iResourceArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping;
            IResource element = iResourceArray[n2];
            Object adapted = GitModelSynchronize.getResourceMapping(element);
            if (adapted != null && adapted instanceof ResourceMapping && GitModelSynchronize.isMappedToProvider(mapping = (ResourceMapping)adapted)) {
                providerMappings.add(mapping);
            }
            ++n2;
        }
        return providerMappings.toArray(new ResourceMapping[providerMappings.size()]);
    }

    private static Object getResourceMapping(Object object) {
        if (object instanceof ResourceMapping) {
            return object;
        }
        if (object instanceof IAdaptable) {
            return ((IAdaptable)object).getAdapter(ResourceMapping.class);
        }
        return null;
    }

    private static boolean isMappedToProvider(ResourceMapping element) {
        IProject[] projects;
        IProject[] iProjectArray = projects = element.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
            if (provider != null && provider.getID().equals(providerId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void fireSynchronizeAction(final IWorkbenchWindow window, final GitSynchronizeDataSet gsdSet, final ResourceMapping[] mappings) {
        final GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(gsdSet);
        Job syncJob = new Job(UIText.GitModelSynchonize_fetchGitDataJobName){

            protected IStatus run(IProgressMonitor monitor) {
                subscriber.init(monitor);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.SYNCHRONIZE_READ_DATA.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        syncJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                GitSubscriberResourceMappingContext remoteContext = new GitSubscriberResourceMappingContext(subscriber, gsdSet);
                SubscriberScopeManager manager = new SubscriberScopeManager(subscriber.getName(), mappings, (Subscriber)subscriber, (RemoteResourceMappingContext)remoteContext, true);
                GitSubscriberMergeContext context = new GitSubscriberMergeContext(subscriber, (ISynchronizationScopeManager)manager, gsdSet);
                GitModelSynchronizeParticipant participant = new GitModelSynchronizeParticipant(context);
                TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
                IWorkbenchPart activePart = null;
                if (window != null) {
                    activePart = window.getActivePage().getActivePart();
                }
                participant.run(activePart);
            }
        });
        syncJob.setUser(true);
        syncJob.schedule();
    }

    private GitModelSynchronize() {
    }
}

