/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SubmoduleCommand<V>
extends RepositoriesViewCommandHandler<V> {
    protected Map<Repository, List<String>> getSubmodules(List<RepositoryTreeNode<?>> nodes) {
        HashMap<Repository, List<String>> repoPaths = new HashMap<Repository, List<String>>();
        for (RepositoryTreeNode<?> node : nodes) {
            if (node.getType() != RepositoryTreeNodeType.REPO) continue;
            Repository parent = node.getParent().getRepository();
            String path = Repository.stripWorkDir((File)parent.getWorkTree(), (File)node.getRepository().getWorkTree());
            ArrayList<String> paths = (ArrayList<String>)repoPaths.get(parent);
            if (paths == null) {
                paths = new ArrayList<String>();
                repoPaths.put(parent, paths);
            }
            paths.add(path);
        }
        for (RepositoryTreeNode<?> node : nodes) {
            if (node.getType() != RepositoryTreeNodeType.SUBMODULES) continue;
            repoPaths.put(node.getParent().getRepository(), null);
        }
        return repoPaths;
    }
}

