/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.DeleteBranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.dialogs.UnmergedBranchDialog;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteBranchCommand
extends RepositoriesViewCommandHandler<RefNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final List nodes = this.getSelectedNodes(event);
        final AtomicReference unmergedNodesRef = new AtomicReference();
        Shell shell = this.getShell(event);
        try {
            new ProgressMonitorDialog(shell).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    List unmergedNodes = DeleteBranchCommand.this.deleteBranches(nodes, false, monitor);
                    unmergedNodesRef.set(unmergedNodes);
                }
            });
        }
        catch (InvocationTargetException e1) {
            Activator.handleError(UIText.RepositoriesView_BranchDeletionFailureMessage, e1.getCause(), true);
        }
        catch (InterruptedException interruptedException) {}
        if (((List)unmergedNodesRef.get()).isEmpty()) {
            return null;
        }
        UnmergedBranchDialog messageDialog = new UnmergedBranchDialog(shell, (List)unmergedNodesRef.get());
        if (messageDialog.open() != 0) {
            return null;
        }
        try {
            new ProgressMonitorDialog(shell).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DeleteBranchCommand.this.deleteBranches((List)unmergedNodesRef.get(), true, monitor);
                }
            });
        }
        catch (InvocationTargetException e1) {
            Activator.handleError(UIText.RepositoriesView_BranchDeletionFailureMessage, e1.getCause(), true);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    private List<RefNode> deleteBranches(final List<RefNode> nodes, final boolean forceDeletionOfUnmergedBranches, IProgressMonitor progressMonitor) throws InvocationTargetException {
        final ArrayList<RefNode> unmergedNodes = new ArrayList<RefNode>();
        try {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        monitor.beginTask(UIText.DeleteBranchCommand_DeletingBranchesProgress, nodes.size());
                        for (RefNode refNode : nodes) {
                            int result = DeleteBranchCommand.this.deleteBranch(refNode, (Ref)refNode.getObject(), forceDeletionOfUnmergedBranches);
                            if (result == 1) {
                                throw new CoreException(Activator.createErrorStatus(UIText.DeleteBranchCommand_CannotDeleteCheckedOutBranch, null));
                            }
                            if (result == 2) {
                                unmergedNodes.add(refNode);
                                continue;
                            }
                            monitor.worked(1);
                        }
                    }
                }, progressMonitor);
            }
            catch (CoreException ex) {
                throw new InvocationTargetException(ex);
            }
        }
        finally {
            progressMonitor.done();
        }
        return unmergedNodes;
    }

    private int deleteBranch(RefNode node, Ref ref, boolean force) throws CoreException {
        DeleteBranchOperation dbop = new DeleteBranchOperation(node.getRepository(), ref, force);
        dbop.execute(null);
        return dbop.getStatus();
    }
}

