/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.IOException;
import java.text.NumberFormat;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.GC;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.PropertyPage;

public class RepositoryStatisticsPage
extends PropertyPage {
    private final NumberFormat bigFpFmt = NumberFormat.getInstance(SystemReader.getInstance().getLocale());
    private final NumberFormat bigIntFmt;

    public RepositoryStatisticsPage() {
        this.bigFpFmt.setMaximumFractionDigits(2);
        this.bigIntFmt = NumberFormat.getInstance(SystemReader.getInstance().getLocale());
    }

    protected Control createContents(Composite parent) {
        Table table = new Table(parent, 67586);
        String[] titles = new String[]{UIText.RepositoryStatistics_Description, UIText.RepositoryStatistics_LooseObjects, UIText.RepositoryStatistics_PackedObjects};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
            ++i;
        }
        Repository repo = (Repository)this.getElement().getAdapter(Repository.class);
        if (repo == null) {
            return table;
        }
        if (repo instanceof FileRepository) {
            GC gc = new GC((FileRepository)repo);
            try {
                GC.RepoStatistics stats = gc.getStatistics();
                table.setLinesVisible(true);
                table.setHeaderVisible(true);
                GridData data = new GridData(4, 4, true, true);
                data.heightHint = 200;
                table.setLayoutData((Object)data);
                TableItem item = new TableItem(table, 0);
                item.setText(0, UIText.RepositoryStatistics_NrOfObjects);
                item.setText(1, this.bigIntFmt.format(stats.numberOfLooseObjects));
                item.setText(2, this.bigIntFmt.format(stats.numberOfPackedObjects));
                item = new TableItem(table, 0);
                item.setText(0, UIText.RepositoryStatistics_NrOfPackfiles);
                item.setText(2, this.bigIntFmt.format(stats.numberOfPackFiles).toString());
                item = new TableItem(table, 0);
                item.setText(0, UIText.RepositoryStatistics_NrOfRefs);
                item.setText(1, this.bigIntFmt.format(stats.numberOfLooseRefs).toString());
                item.setText(2, this.bigIntFmt.format(stats.numberOfPackedRefs).toString());
                item = new TableItem(table, 0);
                item.setText(0, UIText.RepositoryStatistics_SpaceNeededOnFilesystem);
                item.setText(1, this.describeSize(stats.sizeOfLooseObjects));
                item.setText(2, this.describeSize(stats.sizeOfPackedObjects));
                int i2 = 0;
                while (i2 < titles.length) {
                    table.getColumn(i2).pack();
                    ++i2;
                }
                parent.pack();
            }
            catch (IOException iOException) {}
        }
        return table;
    }

    private String describeSize(long nrOfBytes) {
        if (nrOfBytes < 1000L) {
            return String.valueOf(this.bigIntFmt.format(nrOfBytes)) + " Bytes";
        }
        if (nrOfBytes < 1000000L) {
            return String.valueOf(this.bigFpFmt.format((double)nrOfBytes / 1000.0)) + " kB (" + this.bigIntFmt.format(nrOfBytes) + ")";
        }
        if (nrOfBytes < 1000000000L) {
            return String.valueOf(this.bigFpFmt.format((double)nrOfBytes / 1000000.0)) + " MB (" + this.bigIntFmt.format(nrOfBytes) + ")";
        }
        return String.valueOf(this.bigFpFmt.format((double)nrOfBytes / 1.0E9)) + " GB (" + this.bigIntFmt.format(nrOfBytes) + ")";
    }
}

