/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class RepositoryRemotePropertySource
implements IPropertySource {
    private final StoredConfig myConfig;
    private final String myName;

    public RepositoryRemotePropertySource(StoredConfig config, String remoteName, PropertySheetPage page) {
        this.myConfig = config;
        this.myName = remoteName;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        try {
            this.myConfig.load();
        }
        catch (IOException e) {
            Activator.handleError(UIText.RepositoryRemotePropertySource_ErrorHeader, e, true);
        }
        catch (ConfigInvalidException e) {
            Activator.handleError(UIText.RepositoryRemotePropertySource_ErrorHeader, e, true);
        }
        ArrayList<PropertyDescriptor> resultList = new ArrayList<PropertyDescriptor>();
        PropertyDescriptor desc = new PropertyDescriptor((Object)"url", UIText.RepositoryRemotePropertySource_RemoteFetchURL_label);
        resultList.add(desc);
        desc = new PropertyDescriptor((Object)"fetch", UIText.RepositoryRemotePropertySource_FetchLabel);
        resultList.add(desc);
        desc = new PropertyDescriptor((Object)"pushurl", UIText.RepositoryRemotePropertySource_RemotePushUrl_label);
        resultList.add(desc);
        desc = new PropertyDescriptor((Object)"push", UIText.RepositoryRemotePropertySource_PushLabel);
        resultList.add(desc);
        return resultList.toArray(new IPropertyDescriptor[resultList.size()]);
    }

    public Object getPropertyValue(Object id) {
        String[] list = this.myConfig.getStringList("remote", this.myName, (String)id);
        if (list != null && list.length > 1) {
            StringBuilder sb = new StringBuilder();
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                sb.append('[');
                sb.append(s);
                sb.append(']');
                ++n2;
            }
            return sb.toString();
        }
        return this.myConfig.getString("remote", this.myName, (String)id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

