/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.commit.DiffStyleRangeFormatter;
import org.eclipse.egit.ui.internal.commit.DiffViewer;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IUpdate;

public class DiffEditorPage
extends FormPage {
    private DiffViewer viewer;
    private DiffStyleRangeFormatter formatter;

    public DiffEditorPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public DiffEditorPage(FormEditor editor) {
        this(editor, "diffPage", UIText.DiffEditorPage_Title);
    }

    private void formatDiff() {
        Document document = new Document();
        this.formatter = new DiffStyleRangeFormatter((IDocument)document);
        this.viewer.setFormatter(this.formatter);
        Job job = new Job(UIText.DiffEditorPage_TaskGeneratingDiff, (IDocument)document){
            private final /* synthetic */ IDocument val$document;
            {
                this.val$document = iDocument;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                RepositoryCommit commit = (RepositoryCommit)((Object)DiffEditorPage.this.getEditor().getAdapter(RepositoryCommit.class));
                FileDiff[] diffs = commit.getDiffs();
                monitor.beginTask("", diffs.length);
                Repository repository = commit.getRepository();
                FileDiff[] fileDiffArray = diffs;
                int n = diffs.length;
                int n2 = 0;
                while (n2 < n) {
                    FileDiff diff = fileDiffArray[n2];
                    if (monitor.isCanceled()) break;
                    monitor.setTaskName(diff.getPath());
                    if (diff.getBlobs().length == 2) {
                        try {
                            DiffEditorPage.this.formatter.write(repository, diff);
                        }
                        catch (IOException iOException) {}
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
                new UIJob(UIText.DiffEditorPage_TaskUpdatingViewer){

                    public IStatus runInUIThread(IProgressMonitor uiMonitor) {
                        if (UIUtils.isUsable((Viewer)DiffEditorPage.this.viewer)) {
                            DiffEditorPage.this.viewer.setDocument(val$document);
                            DiffEditorPage.this.viewer.refreshStyleRanges();
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected void addEditorActions(MenuManager manager) {
        final TextViewerAction copyAction = new TextViewerAction((ITextViewer)this.viewer, 4);
        copyAction.setText(UIText.SpellCheckingMessageArea_copy);
        copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        final TextViewerAction selectAllAction = new TextViewerAction((ITextViewer)this.viewer, 7);
        selectAllAction.setText(UIText.SpellCheckingMessageArea_selectAll);
        selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        manager.add((IAction)copyAction);
        manager.add((IAction)selectAllAction);
        manager.add((IContributionItem)new Separator());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                copyAction.update();
                selectAllAction.update();
            }
        });
    }

    protected void createFormContent(IManagedForm managedForm) {
        Composite body = managedForm.getForm().getBody();
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(body);
        this.viewer = new DiffViewer(body, (IVerticalRuler)new CompositeRuler(), 768);
        this.viewer.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.viewer.getControl());
        MenuManager manager = new MenuManager();
        this.addEditorActions(manager);
        Menu menu = manager.createContextMenu((Control)this.viewer.getTextWidget());
        IEditorSite site = this.getEditorSite();
        site.setSelectionProvider((ISelectionProvider)this.viewer);
        site.registerContextMenu("#AbstractTextEditorContext", manager, (ISelectionProvider)this.viewer, true);
        site.registerContextMenu("#EditorContext", manager, (ISelectionProvider)this.viewer, true);
        this.viewer.getTextWidget().setMenu(menu);
        this.formatDiff();
    }

    private static class TextViewerAction
    extends Action
    implements IUpdate {
        private int code = -1;
        private ITextOperationTarget target;

        public TextViewerAction(ITextViewer viewer, int operationCode) {
            this.code = operationCode;
            this.target = viewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            if (this.code == 2) {
                return;
            }
            boolean wasEnabled = this.isEnabled();
            boolean isEnabled = this.target.canDoOperation(this.code);
            this.setEnabled(isEnabled);
            if (wasEnabled != isEnabled) {
                this.firePropertyChange("enabled", wasEnabled ? Boolean.TRUE : Boolean.FALSE, isEnabled ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this.code != -1) {
                this.target.doOperation(this.code);
            }
        }
    }
}

