/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewContentProvider;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewLabelProvider;
import org.eclipse.egit.ui.internal.repository.RepositorySearchWizard;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class GitSelectRepositoryPage
extends WizardPage {
    private static final String LAST_SELECTED_REPO_PREF = "GitSelectRepositoryPage.lastRepository";
    private final RepositoryUtil util;
    private TreeViewer tv;
    private Button addRepo;
    private IEclipsePreferences.IPreferenceChangeListener configChangeListener;

    public GitSelectRepositoryPage() {
        super(GitSelectRepositoryPage.class.getName());
        this.setTitle(UIText.GitSelectRepositoryPage_PageTitle);
        this.setMessage(UIText.GitSelectRepositoryPage_PageMessage);
        this.util = Activator.getDefault().getRepositoryUtil();
    }

    public Repository getRepository() {
        Object obj = ((IStructuredSelection)this.tv.getSelection()).getFirstElement();
        if (obj == null) {
            return null;
        }
        return ((RepositoryTreeNode)obj).getRepository();
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        FilteredTree tree = new FilteredTree(main, 2820, new PatternFilter(), true);
        this.tv = tree.getViewer();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        this.tv.setContentProvider((IContentProvider)new RepositoriesViewContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new RepositoriesViewLabelProvider());
        Composite tb = new Composite(main, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(tb);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)tb);
        this.addRepo = new Button(tb, 8);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)this.addRepo);
        this.addRepo.setText(UIText.GitSelectRepositoryPage_AddButton);
        this.addRepo.setToolTipText(UIText.GitSelectRepositoryPage_AddTooltip);
        this.addRepo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List configuredDirs = GitSelectRepositoryPage.this.util.getConfiguredRepositories();
                RepositorySearchWizard wizard = new RepositorySearchWizard(configuredDirs);
                WizardDialog dlg = new WizardDialog(GitSelectRepositoryPage.this.getShell(), (IWizard)wizard);
                if (dlg.open() == 0 && !wizard.getDirectories().isEmpty()) {
                    Set<String> dirs = wizard.getDirectories();
                    for (String dir : dirs) {
                        GitSelectRepositoryPage.this.util.addConfiguredRepository(new File(dir));
                    }
                    GitSelectRepositoryPage.this.checkPage();
                }
            }
        });
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GitSelectRepositoryPage.this.checkPage();
            }
        });
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GitSelectRepositoryPage.this.checkPage();
                if (GitSelectRepositoryPage.this.isPageComplete()) {
                    GitSelectRepositoryPage.this.getContainer().showPage(GitSelectRepositoryPage.this.getNextPage());
                }
            }
        });
        this.tv.setInput((Object)this.util.getConfiguredRepositories());
        this.configChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                Display display = GitSelectRepositoryPage.this.tv.getControl().getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        GitSelectRepositoryPage.this.refreshRepositoryList();
                        GitSelectRepositoryPage.this.checkPage();
                    }
                });
            }
        };
        this.util.getPreferences().addPreferenceChangeListener(this.configChangeListener);
        this.setPageComplete(false);
        Dialog.applyDialogFont((Control)main);
        this.setControl((Control)main);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (visible && this.tv.getSelection().isEmpty()) {
            String repoDir = settings.get(LAST_SELECTED_REPO_PREF);
            if (repoDir != null) {
                TreeItem[] treeItemArray = this.tv.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    RepositoryNode node = (RepositoryNode)item.getData();
                    if (node.getRepository().getDirectory().getPath().equals(repoDir)) {
                        this.tv.setSelection((ISelection)new StructuredSelection((Object)node));
                    }
                    ++n2;
                }
            }
        } else {
            Object element = ((IStructuredSelection)this.tv.getSelection()).getFirstElement();
            if (element instanceof RepositoryNode) {
                settings.put(LAST_SELECTED_REPO_PREF, ((RepositoryNode)element).getRepository().getDirectory().getPath());
            }
        }
    }

    private void refreshRepositoryList() {
        List dirsAfter;
        List dirsBefore = (List)this.tv.getInput();
        if (!dirsBefore.containsAll(dirsAfter = this.util.getConfiguredRepositories())) {
            this.tv.setInput((Object)dirsAfter);
            for (String dir : dirsAfter) {
                if (dirsBefore.contains(dir)) continue;
                try {
                    RepositoryNode node = new RepositoryNode(null, (Repository)new FileRepository(new File(dir)));
                    this.tv.setSelection((ISelection)new StructuredSelection((Object)node));
                }
                catch (IOException e1) {
                    Activator.handleError(e1.getMessage(), e1, false);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkPage() {
        block5: {
            block4: {
                this.setErrorMessage(null);
                try {
                    if (((List)this.tv.getInput()).isEmpty()) {
                        this.setErrorMessage(UIText.GitSelectRepositoryPage_NoRepoFoundMessage);
                        break block4;
                    }
                    if (!this.tv.getSelection().isEmpty()) break block5;
                    this.setErrorMessage(UIText.GitSelectRepositoryPage_PleaseSelectMessage);
                }
                catch (Throwable throwable) {
                    this.setPageComplete(this.getErrorMessage() == null);
                    throw throwable;
                }
            }
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    public void dispose() {
        super.dispose();
        this.util.getPreferences().removePreferenceChangeListener(this.configChangeListener);
    }
}

