/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.blame;

import java.util.Date;
import org.eclipse.egit.ui.internal.blame.AuthorColors;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.graphics.RGB;

public class BlameRevision
extends Revision {
    private int start;
    private int lines = 1;
    private RevCommit commit;
    private Repository repository;

    public Object getHoverInfo() {
        return this;
    }

    public RGB getColor() {
        return AuthorColors.getDefault().getCommitterRGB(this.getAuthor());
    }

    public String getId() {
        return this.commit.abbreviate(7).name();
    }

    public Date getDate() {
        PersonIdent person = this.commit.getAuthorIdent();
        if (person == null) {
            person = this.commit.getCommitterIdent();
        }
        return person != null ? person.getWhen() : new Date(0L);
    }

    public BlameRevision register() {
        this.addRange((ILineRange)new LineRange(this.start, this.lines));
        return this;
    }

    public BlameRevision addLine() {
        ++this.lines;
        return this;
    }

    public BlameRevision reset(int number) {
        this.start = number;
        this.lines = 1;
        return this;
    }

    public BlameRevision setCommit(RevCommit commit) {
        this.commit = commit;
        return this;
    }

    public RevCommit getCommit() {
        return this.commit;
    }

    public BlameRevision setRepository(Repository repository) {
        this.repository = repository;
        return this;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getAuthor() {
        return this.commit.getAuthorIdent().getName();
    }
}

