/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.dialogs.CompareTreeView;
import org.eclipse.egit.ui.internal.history.CommitSelectionDialog;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CompareWithCommitActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repo = this.getRepository(true, event);
        IResource[] resources = this.getSelectedResources(event);
        if (repo == null) {
            return null;
        }
        CommitSelectionDialog dlg = new CommitSelectionDialog(this.getShell(event), repo, resources);
        if (dlg.open() != 0) {
            return null;
        }
        if (resources.length == 1 && resources[0] instanceof IFile) {
            ITypedElement ancestor;
            ITypedElement next;
            IFile baseFile = (IFile)resources[0];
            ITypedElement base = SaveableCompareEditorInput.createFileElement((IFile)baseFile);
            try {
                RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resources[0]);
                next = this.getElementForCommit(mapping.getRepository(), mapping.getRepoRelativePath((IResource)baseFile), dlg.getCommitId());
                ancestor = CompareUtils.getFileRevisionTypedElementForCommonAncestor(mapping.getRepoRelativePath((IResource)baseFile), repo.resolve("HEAD"), dlg.getCommitId(), repo);
            }
            catch (IOException e) {
                Activator.handleError(UIText.CompareWithIndexAction_errorOnAddToIndex, e, true);
                return null;
            }
            GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, ancestor, null);
            in.getCompareConfiguration().setRightLabel(dlg.getCommitId().name());
            CompareUI.openCompareEditor((CompareEditorInput)in);
        } else {
            try {
                CompareTreeView view = (CompareTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.CompareTreeView");
                view.setInput(resources, dlg.getCommitId().name());
            }
            catch (PartInitException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
        return null;
    }

    private ITypedElement getElementForCommit(Repository repository, String gitPath, ObjectId commitId) throws IOException {
        RevWalk rw = new RevWalk(repository);
        RevCommit commit = rw.parseCommit((AnyObjectId)commitId);
        rw.release();
        return CompareUtils.getFileRevisionTypedElement(gitPath, commit, repository);
    }

    public boolean isEnabled() {
        return this.getRepository() != null;
    }
}

