/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.commit.CommitUI;
import org.eclipse.egit.ui.internal.operations.GitScopeUtil;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class CommitActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource[] resourcesInScope;
        Repository[] repos = this.getRepositories(event);
        if (repos.length == 0) {
            return null;
        }
        Shell shell = this.getShell(event);
        try {
            IResource[] selectedResources = this.getSelectedResources(event);
            if (selectedResources.length > 0) {
                IWorkbenchPart part = this.getPart(event);
                resourcesInScope = GitScopeUtil.getRelatedChanges(part, selectedResources);
            } else {
                resourcesInScope = new IResource[]{};
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        CommitUI commitUi = new CommitUI(shell, repos[0], resourcesInScope, false);
        commitUi.commit();
        return null;
    }

    public boolean isEnabled() {
        return this.getRepositories().length > 0;
    }
}

